{****************************************************************************************

"AutomateProjectCreation" HelpNDoc script. Copyright (c) IBE Software
---------------------------------------------------------------------
See: http://www.helpndoc.com/articles/2014-05-23-use-scripts-automate-help-and-documentation-creation
Use an external text file as well as multiple HTML files to create a new HelpNDoc
project. This script will open TOC_FILE and for each line, it will create a new topic.
It will then try to locate a content file with that topic's name and use it as topic
content.

Customization:
--------------
* BASE_PATH => the path where the table of contents and topics are located
* TOC_FILE => the name of the text file containing topic captions
* CONTENT_EXT => the extension of the file to import

****************************************************************************************}

const
  // The base path of the source files
  BASE_PATH = 'c:\tmp\';
  // The name of the toc text file
  TOC_FILE = 'topics.txt';
  // The extension of the content files
  CONTENT_EXT = '.html';

var
  // List of lines in the file
  oList: TStringList;
  // Current line number
  nLine: Integer;
  // ID for the newly created topic
  sTopicId: string;  
  // Editor
  oEditor: TObject; 

begin
  // Create objects
  oList := TStringList.Create();        
  oEditor := HndEditor.CreateTemporaryEditor();
  try
    // Load the lines from a file
    oList.LoadFromFile(BASE_PATH + TOC_FILE);
    // Iterate through each line
    for nLine := 0 to oList.Count - 1 do
    begin
      // Create a new topic
      sTopicId := HndTopics.CreateTopic();
      // Set its caption based on the current line
      HndTopics.SetTopicCaption(sTopicId, oList[nLine]);  
      // Load the content from another file
      HndEditor.Clear(oEditor);
      HndEditor.InsertFile(oEditor, BASE_PATH + oList[nLine] + CONTENT_EXT);
      // Set the content of the topic
      HndEditor.SetAsTopicContent(oEditor, sTopicId);
    end;
  finally
    // Free objects  
    HndEditor.DestroyTemporaryEditor(oEditor);
    oList.Free;
  end;
end.