function castRay(x)
	local cameraX = 2 * x / w - 1
	local rayPosX = player.posX
	local rayPosY = player.posY
	local rayDirX = player.dirX + player.planeX * cameraX
	local rayDirY = player.dirY + player.planeY * cameraX
	
	local mapX = math.floor(rayPosX)
	local mapY = math.floor(rayPosY)
	
	local sideDistX
	local sideDistY
	
	local deltaDistX = math.sqrt(1 + (rayDirY ^ 2) / (rayDirX ^ 2))
	local deltaDistY = math.sqrt(1 + (rayDirX ^ 2) / (rayDirY ^ 2))
	local perWallDist
	
	local stepX
	local stepY
	
	local hit = 0
	local side = 0
	
	if (rayDirX < 0) then
	  	stepX = -1
	  	sideDistX = (rayPosX - mapX) * deltaDistX
	else
	  	stepX = 1
	  	sideDistX = (mapX + 1.0 - rayPosX) * deltaDistX
	end
	if (rayDirY < 0) then
	  	stepY = -1
	  	sideDistY = (rayPosY - mapY) * deltaDistY
	else
	  	stepY = 1
	  	sideDistY = (mapY + 1.0 - rayPosY) * deltaDistY
	end

	local numSteps = 0
	while (hit == 0 and numSteps < renderDist) do
		local kk = {
			x = mapX,
			y = mapY,
		}
		if not checkMatch(floorTable, kk) then
			table.insert(floorTable, kk)
		end

	  	if (sideDistX < sideDistY) then
			sideDistX = sideDistX + deltaDistX
			mapX = mapX + stepX
			side = 0
	  	else
			sideDistY = sideDistY + deltaDistY
			mapY = mapY + stepY
			side = 1
	  	end
	  	
	  	if mapX > 0 and mapX <= #map[1] and mapY > 0 and mapY <= #map then
		  	if (map[mapX][mapY] > 0) then
		  		-- Checking if hit a fence. If so, continue casting and create a fence line
		  		if map[mapX][mapY] == 9 then
		  			if (side == 0)then
						perpWallDist = math.abs((mapX - rayPosX + (1 - stepX) / 2) / rayDirX)
					else
						perpWallDist = math.abs((mapY - rayPosY + (1 - stepY) / 2) / rayDirY)
					end
					  
					lineHeight = math.abs(math.floor(h / perpWallDist))
					  
					drawStart = -lineHeight / 2 + ((h / 2) + TILT)

					drawEnd = lineHeight / 2 + ((h / 2) + TILT)
					  
					-- Texturing calculations
					local texNum = 0
					if mapX > 0 and mapX <= #map[1] and mapY > 0 and mapY <= #map then
						texNum = map[mapX][mapY]
					end

					if texNum < 0 then texNum = 0 end
					   
					-- Calculate value of wallX
					local wallX -- Where exactly the wall was hit
					if (side == 1) then
						wallX = rayPosX + ((mapY - rayPosY + (1 - stepY) / 2) / rayDirY) * rayDirX
					else
						wallX = rayPosY + ((mapX - rayPosX + (1 - stepX) / 2) / rayDirX) * rayDirY
					end
					wallX = wallX - math.floor(wallX)
					   
					-- X coordinate on the texture
					local texX = math.floor(wallX * textureWidth)
					if(side == 0 and rayDirX > 0) then texX = textureWidth - texX - 1 end
					if(side == 1 and rayDirY < 0) then texX = textureWidth - texX - 1 end

					-- Color
					local deathColor = 1 - (perpWallDist / maxFogDist)
					if deathColor < 0 then deathColor = 0 end

					local tempColor = {}
					if (side == 1) then
						tempColor = {127 * deathColor, 127 * deathColor, 127 * deathColor}
					else
						tempColor = {255 * deathColor, 255 * deathColor, 255 * deathColor}
					end

						local i = {
							x = x,
							hor = texX,
							start = drawStart,
							scale = (drawEnd - drawStart) / textureHeight,
							texture = texNum,
							color = tempColor,
							z = perpWallDist,
							type = "wall"
						}
						table.insert(spritePool, i)
		  		else
					hit = 1

					local kk = {
						x = mapX,
						y = mapY,
					}
					if not checkMatch(floorTable, kk) then
						table.insert(floorTable, kk)
					end
				end
		  	end
		end

		numSteps = numSteps + 1
	end
	  
	if (side == 0)then
		perpWallDist = math.abs((mapX - rayPosX + (1 - stepX) / 2) / rayDirX)
	else
		perpWallDist = math.abs((mapY - rayPosY + (1 - stepY) / 2) / rayDirY)
	end
	  
	lineHeight = math.abs(math.floor(h / perpWallDist))
	  
	drawStart = -lineHeight / 2 + ((h / 2) + TILT)

	drawEnd = lineHeight / 2 + ((h / 2) + TILT)
	  
	-- Texturing calculations
	local texNum = 0
	if mapX > 0 and mapX <= #map[1] and mapY > 0 and mapY <= #map then
		texNum = map[mapX][mapY]
	end

	if texNum < 0 then texNum = 0 end
	   
	-- Calculate value of wallX
	local wallX -- Where exactly the wall was hit
	if (side == 1) then
		wallX = rayPosX + ((mapY - rayPosY + (1 - stepY) / 2) / rayDirY) * rayDirX
	else
		wallX = rayPosY + ((mapX - rayPosX + (1 - stepX) / 2) / rayDirX) * rayDirY
	end
	wallX = wallX - math.floor(wallX)
	   
	-- X coordinate on the texture
	local texX = math.floor(wallX * textureWidth)
	if(side == 0 and rayDirX > 0) then texX = textureWidth - texX - 1 end
	if(side == 1 and rayDirY < 0) then texX = textureWidth - texX - 1 end

	local i = {
		x = x,
		hor = texX,
		start = drawStart,
		scale = (drawEnd - drawStart) / textureHeight,
		texture = texNum,
		z = perpWallDist,
		type = "wall"
	}

	-- Color
	local deathColor = 1 - (perpWallDist / maxFogDist)
	if deathColor < 0 then deathColor = 0 end

	if (side == 1) then
		i.color = {127 * deathColor, 127 * deathColor, 127 * deathColor}
	else
		i.color = {255 * deathColor, 255 * deathColor, 255 * deathColor}
	end

	table.insert(wallPool, i)

	-- zBuffer for sprite casting
	zBuffer[x] = perpWallDist -- Perpendicular distance is used
end