function loadEverything()
	-- Current Map
	map = {
		{8,8,8,8,8,9,8,8,8,8,8,4,4,6,4,4,6,4,6,4,4,4,6,4},
		{8,0,0,0,0,0,0,0,0,0,8,4,0,0,0,0,0,0,0,0,0,0,0,4},
		{8,0,3,3,0,9,0,0,0,8,8,4,0,0,0,0,0,0,0,0,0,0,0,6},
		{8,0,-3,3,0,0,-5,0,0,-8,0,0,0,0,0,0,-1,-4,0,0,0,0,0,6},
		{8,0,3,3,0,0,0,0,0,8,8,4,0,0,0,0,0,0,0,0,0,0,0,4},
		{8,0,0,0,0,0,0,0,0,0,8,4,0,0,0,0,0,6,6,6,0,6,4,6},
		{8,8,8,8,0,8,8,8,8,8,8,4,4,4,4,4,4,6,0,0,0,0,0,6},
		{7,7,7,7,-7,7,7,7,7,0,8,0,8,0,8,0,8,4,0,4,0,6,0,6},
		{7,7,0,0,-2,0,0,0,7,8,0,8,0,8,0,8,8,6,0,0,0,0,0,6},
		{7,-2,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,8,6,0,0,0,0,0,4},
		{7,-2,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,8,6,0,6,0,6,0,6},
		{7,7,0,0,0,0,0,0,7,8,0,8,-7,8,0,8,8,6,4,6,0,6,6,6},
		{7,7,7,7,0,7,7,7,7,8,8,4,0,6,8,4,8,3,3,3,0,3,3,3},
		{2,2,2,2,0,2,2,2,2,4,6,4,0,0,6,0,6,3,0,0,0,0,0,3},
		{2,2,0,0,0,0,0,2,2,4,0,0,0,0,0,0,4,3,0,0,0,0,0,3},
		{2,-1,0,0,0,0,0,0,2,4,0,0,0,0,0,0,4,3,0,0,0,0,0,3},
		{1,-1,0,0,0,0,0,0,1,4,4,4,4,4,6,-2,6,3,3,0,0,0,3,3},
		{2,-1,0,0,0,0,0,0,2,2,2,-7,2,2,2,6,6,0,0,5,0,5,0,5},
		{2,2,0,0,0,0,0,2,2,2,-2,0,-2,2,2,0,5,0,5,0,0,0,5,5},
		{2,-1,0,0,0,0,0,0,6,0,0,0,0,0,2,5,0,5,0,5,0,5,0,5},
		{1,-1,0,0,0,0,0,0,-8,0,0,0,0,0,0,-8,0,0,0,0,0,0,0,5},
		{2,-1,0,0,0,0,0,0,6,0,0,0,0,0,2,5,0,5,0,5,0,5,0,5},
		{2,2,0,0,0,0,0,2,2,2,0,0,0,2,2,0,5,0,5,0,0,0,5,5},
		{2,2,2,2,1,2,2,2,2,2,2,1,2,2,2,5,5,5,5,5,5,5,5,5},
	}
	floor = {
		{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
		{2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2},
		{3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},
		{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
		{2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2},
		{3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},
		{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
		{2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2},
		{3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},
		{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
		{2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2},
		{3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},
		{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
		{2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2},
		{3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},
		{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
		{2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2},
		{3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},
		{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
		{2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2},
		{3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},
		{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
		{2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2},
		{3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},
	}

	-- Player Table
	player = {
		posX = 22.5,
		posY = 12.5,

		dirX = -1,
		dirY = 0,

		planeX = 0,
		planeY = 0.66,

		moveMod = 5.0,
		rotMod = 0.8,
		strafeMod = 5.0,

		w = 0.5,
	}

	-- Pixel Scale
	pixelScale = 1

	-- Screen Width and Height; H:W = 3:4 (Default 512x384)
	w = 720
	h = 540

	-- Texture Width and Height
	textureWidth, textureHeight = 32, 32

	-- Window Settings
	--love.window.setMode(w, h, {vsync = true})
	--love.window.setTitle("Raycasting Demo")

	-- All the canvases
	canvas = love.graphics.newCanvas( )
	
	-- Mouse modification
	love.mouse.setVisible(false)
	love.mouse.setPosition(w/2, h/2)

	-- The majority of table declarations
	zBuffer = {}
	quads = {}
	cornerImg = {}

	directory = {
		[1] = "img/tile/bluestone.png",
		[2] = "img/tile/colorstone.png",
		[3] = "img/tile/eagle.png",
		[4] = "img/tile/greystone.png",
		[5] = "img/tile/mossy.png",
		[6] = "img/tile/wood.png",
		[7] = "img/tile/redbrick.png",
		[8] = "img/tile/purplestone.png",
		[9] = "img/tile/fence.png",
		[10] = "img/tile/door.png"
	}

	-- Loads all the tiles
	img = {
		[1] = love.graphics.newImage(directory[1]),
		[2] = love.graphics.newImage(directory[2]),
		[3] = love.graphics.newImage(directory[3]),
		[4] = love.graphics.newImage(directory[4]),
		[5] = love.graphics.newImage(directory[5]),
		[6] = love.graphics.newImage(directory[6]),
		[7] = love.graphics.newImage(directory[7]),
		[8] = love.graphics.newImage(directory[8]),
		[9] = love.graphics.newImage(directory[9]),
		[10] = love.graphics.newImage(directory[10])
	}

	-- Loads all of the sprites
	spriteImg = {
		[1] = love.graphics.newImage("img/item/barrel.png"),
		[2] = love.graphics.newImage("img/item/pillar.png"),
		[3] = love.graphics.newImage("img/item/greenlight.png"),
		[4] = love.graphics.newImage("img/item/tallpillar.png"),
		[5] = love.graphics.newImage("img/item/book.png")
	}
	skyImg = love.graphics.newImage("img/sky.png")
	minSize = 120
	maxSize = 160
	curSize = minSize
	curShrink = false

	-- Generates the quads for the walls
	for x = 0, textureWidth do
		quads[x] = love.graphics.newQuad(x, 0, 1, textureHeight, textureWidth, textureHeight)
	end

	-- Generate corner images for the floor
	genCorner()

	-- Sprite tables and spawning sprites
	doors = {}
	doorOrder = {}
	doorDistance = {}

	sprites = {}
	spriteOrder = {}
	spriteDistance = {}

	for x = 1, #map[1] do
		for y = 1, #map do
			if map[x][y] < 0 and map[x][y] ~= -7 and map[x][y] ~= -8 then
				newSprite(x + 0.5, y + 0.5, math.abs(map[x][y]))
			elseif map[x][y] == -7 then
				newDoor(x + 0.5, y + 0.5, 10, true, x, y)
			elseif map[x][y] == -8 then
				newDoor(x + 0.5, y + 0.5, 10, false, x, y)
			end
		end
	end

	--[[ newSprite(21.5,12.5, 3)
	newSprite(19.5,5.5, 3)
	newSprite(11.0,5.5, 3)
	newSprite(11.0,13.5,3)
	newSprite(4.5, 7.5, 3)
	newSprite(4.5, 21.5,3)
	newSprite(4.5, 15.5,3)
	newSprite(15.5,21.5,3)
	
	newSprite(19.5, 11.5, 2)
	newSprite(19.5, 12.5, 2)
	newSprite(19.5, 13.5, 2)
	
	newSprite(22.5, 2.5, 1)
	newSprite(16.5, 2.5, 1)
	newSprite(17.0, 2.8, 1)
	newSprite(17.2, 2.2, 1)
	newSprite(4.5,  3.5, 1)
	newSprite(10.5, 16.5, 1)
	newSprite(11.0, 16.1,1)
	newSprite(11.5, 16.8,1) ]]--

	-- Fog control
	maxFogDist = 15

	-- Mouse lock to screen
	grabbed = true

	-- Max Render Distance
	renderDist = 50

	-- Sprite Pool to be sorted
	spritePool = {}

	-- Wall Pool (No transperancy)
	wallPool = {}

	-- Floor Table
	floorTable = {}
end