function drawFloor()
	-- Transform sprite with the inverse camera matrix
	local invDet = 1.0 / (player.planeX * player.dirY - player.dirX * player.planeY);

	local addX = 1.0
	local addSmall = 0.5

	-- NOTE: Add math.abs to the Xs to do "paper-folding" effect
	for i,v in ipairs(floorTable) do
		if v.x > 0 and v.x <= #floor[1] and v.y > 0 and v.y <= #floor then
			local v1, v2, v3, v4, canDraw = floorTile(v.x, v.y, addX, invDet)

			if canDraw then
				pers.quad(img[floor[v.x][v.y]], v1, v2, v3, v4)
			else
				local v1, v2, v3, v4, canDraw = floorTile(v.x, v.y, addSmall, invDet)
				if canDraw then pers.quad(cornerImg[floor[v.x][v.y]][1], v1, v2, v3, v4) end

				local v1, v2, v3, v4, canDraw = floorTile(v.x + addSmall, v.y, addSmall, invDet)
				if canDraw then pers.quad(cornerImg[floor[v.x][v.y]][2], v1, v2, v3, v4) end

				local v1, v2, v3, v4, canDraw = floorTile(v.x, v.y + addSmall, addSmall, invDet)
				if canDraw then pers.quad(cornerImg[floor[v.x][v.y]][3], v1, v2, v3, v4) end

				local v1, v2, v3, v4, canDraw = floorTile(v.x + addSmall, v.y + addSmall, addSmall, invDet)
				if canDraw then pers.quad(cornerImg[floor[v.x][v.y]][4], v1, v2, v3, v4) end
			end
		end
	end

end

function drawSky()
	local pi = math.pi
    local ss = 1 / pixelScale
	local sx = -((skyImg:getWidth() / (pi * 2)) * (getPlayerRot() % (pi * 2)))
	local sy = 0

	for i = -1, 1 do
	    love.graphics.setColor(255, 255, 255)
		love.graphics.draw(skyImg, sx + (skyImg:getWidth() * i), sy, 0, 1 / pixelScale, 1 / pixelScale)
	end
end