/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient;

import cz.vity.freerapid.plugins.exceptions.BuildMethodException;
import cz.vity.freerapid.plugins.exceptions.PluginImplementationException;
import cz.vity.freerapid.plugins.webclient.DefaultFileStreamRecognizer;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.plugins.webclient.MethodBuilder;
import cz.vity.freerapid.plugins.webclient.hoster.CaptchaSupport;
import cz.vity.freerapid.plugins.webclient.interfaces.DialogSupport;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpDownloadClient;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpFile;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpFileDownloadTask;
import cz.vity.freerapid.plugins.webclient.interfaces.PluginRunner;
import cz.vity.freerapid.plugins.webclient.interfaces.ShareDownloadService;
import cz.vity.freerapid.plugins.webclient.utils.JsonMapper;
import cz.vity.freerapid.plugins.webclient.utils.PlugUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpClientParams;

public abstract class AbstractRunner
implements PluginRunner {
    protected static final Logger logger = Logger.getLogger(AbstractRunner.class.getName());
    protected HttpDownloadClient client;
    private ShareDownloadService pluginService;
    protected HttpFileDownloadTask downloadTask;
    protected HttpFile httpFile;
    protected String fileURL;
    private String baseURL;
    private CaptchaSupport captchaSupport;
    private boolean initialized = false;
    private String referer;
    private String encoding = "UTF-8";

    @Override
    public void init(ShareDownloadService service, HttpFileDownloadTask downloadTask) {
        this.pluginService = service;
        this.downloadTask = downloadTask;
        this.client = downloadTask.getClient();
        this.httpFile = downloadTask.getDownloadFile();
        this.fileURL = this.httpFile.getFileUrl().toString();
        this.baseURL = this.httpFile.getFileUrl().getProtocol() + "://" + this.httpFile.getFileUrl().getAuthority();
        this.initialized = true;
    }

    @Override
    public void run() throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("Cannot run Run method. Runner was not initialized via init method");
        }
        logger.info("Starting 'run' for file " + this.fileURL);
    }

    @Override
    public void runCheck() throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("Cannot run runCheck method. Runner was not initialized via init method");
        }
        logger.info("Starting 'runCheck' for file " + this.fileURL);
    }

    protected CaptchaSupport getCaptchaSupport() {
        if (this.captchaSupport == null) {
            this.captchaSupport = new CaptchaSupport(this.client, this.getDialogSupport());
            return this.captchaSupport;
        }
        return this.captchaSupport;
    }

    protected DialogSupport getDialogSupport() {
        return this.pluginService.getPluginContext().getDialogSupport();
    }

    public ShareDownloadService getPluginService() {
        return this.pluginService;
    }

    protected boolean makeRequest(HttpMethod method) throws IOException {
        this.referer = method.getURI().toString();
        return this.client.makeRequest(method, false) == 200;
    }

    protected boolean makeRedirectedRequest(HttpMethod method) throws IOException {
        this.referer = method.getURI().toString();
        return this.client.makeRequest(method, true) == 200;
    }

    protected PostMethod getPostMethod(String uri) {
        return this.client.getPostMethod(uri);
    }

    protected GetMethod getGetMethod(String uri) {
        return this.client.getGetMethod(uri);
    }

    protected String getContentAsString() {
        return this.client.getContentAsString();
    }

    protected <T> T getContentAsObject(Class<T> objectClass) throws PluginImplementationException {
        String contentAsString = this.getContentAsString();
        if (contentAsString == null) {
            return null;
        }
        return new JsonMapper().deserialize(contentAsString, objectClass);
    }

    protected Matcher getMatcherAgainstContent(String regexp) {
        return PlugUtils.matcher(regexp, this.client.getContentAsString());
    }

    protected MethodBuilder getMethodBuilder() throws BuildMethodException {
        return new MethodBuilder(this.client).setBaseURL(this.getBaseURL()).setReferer(this.referer).setEncoding(this.encoding);
    }

    protected MethodBuilder getMethodBuilder(String content) throws BuildMethodException {
        return new MethodBuilder(content, this.client).setBaseURL(this.getBaseURL()).setReferer(this.referer);
    }

    protected void addCookie(Cookie cookie) {
        this.client.getHTTPClient().getState().addCookie(cookie);
    }

    protected Cookie[] getCookies() {
        return this.client.getHTTPClient().getState().getCookies();
    }

    protected Cookie getCookieByName(String name) {
        for (Cookie cookie : this.getCookies()) {
            if (!cookie.getName().equalsIgnoreCase(name)) continue;
            return cookie;
        }
        return null;
    }

    protected Cookie getCookieByValue(String value) {
        for (Cookie cookie : this.getCookies()) {
            if (!cookie.getValue().equalsIgnoreCase(value)) continue;
            return cookie;
        }
        return null;
    }

    protected String getBaseURL() {
        return this.baseURL;
    }

    protected void setClientParameter(String parameterName, Object parameterValue) {
        this.client.getHTTPClient().getParams().setParameter(parameterName, parameterValue);
    }

    protected void setClientParameter(String parameterName, int parameterValue) {
        this.client.getHTTPClient().getParams().setIntParameter(parameterName, parameterValue);
    }

    protected void setClientParameter(String parameterName, boolean parameterValue) {
        this.client.getHTTPClient().getParams().setBooleanParameter(parameterName, parameterValue);
    }

    protected HttpClientParams getClientParameters() {
        return this.client.getHTTPClient().getParams();
    }

    protected void setPageEncoding(String encoding) {
        this.encoding = encoding;
        this.setClientParameter("pageCharset", encoding);
        this.client.getHTTPClient().getParams().setHttpElementCharset(encoding);
    }

    protected void setFileStreamContentTypes(String ... streamContentTypes) {
        this.setFileStreamContentTypes(streamContentTypes, new String[0]);
    }

    protected void setTextContentTypes(String ... textContentTypes) {
        this.setFileStreamContentTypes(new String[0], textContentTypes);
    }

    protected void setFileStreamContentTypes(String[] streamContentTypes, String[] textContentTypes) {
        this.setClientParameter("fileStreamRecognizer", new DefaultFileStreamRecognizer(streamContentTypes, textContentTypes, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tryDownloadAndSaveFile(HttpMethod method) throws Exception {
        if (this.httpFile.getState() == DownloadState.PAUSED || this.httpFile.getState() == DownloadState.CANCELLED) {
            return false;
        }
        this.httpFile.setState(DownloadState.GETTING);
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Download link URI: " + method.getURI().toString());
            logger.info("Making final request for file");
        }
        try {
            InputStream inputStream = this.client.makeFinalRequestForFile(method, this.httpFile, true);
            if (inputStream != null) {
                logger.info("Saving to file");
                this.downloadTask.saveToFile(inputStream);
                boolean bl = true;
                return bl;
            }
            logger.info("Saving file failed");
            boolean bl = false;
            return bl;
        }
        finally {
            method.abort();
            method.releaseConnection();
        }
    }
}

