/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.QuietMode;
import cz.vity.freerapid.core.tasks.CheckPluginUpdateTask;
import cz.vity.freerapid.core.tasks.DownloadNewPluginsTask;
import cz.vity.freerapid.gui.dialogs.UpdateDialog;
import cz.vity.freerapid.gui.dialogs.WrappedPluginData;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.PluginsManager;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.model.PluginMetaData;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.xmlimport.ver1.Plugin;
import java.awt.Frame;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.SwingUtilities;
import org.java.plugin.registry.Version;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskEvent;
import org.jdesktop.application.TaskListener;

public class UpdateManager {
    private static final Logger logger = Logger.getLogger(UpdateManager.class.getName());
    private final ManagerDirector director;
    private final ApplicationContext context;
    private Timer timer;
    private AtomicBoolean updating = new AtomicBoolean(false);

    public UpdateManager(ManagerDirector director, ApplicationContext context) {
        this.director = director;
        this.context = context;
    }

    void initManager() {
        if (AppPrefs.getProperty("blindMode", false)) {
            AppPrefs.storeProperty("pluginUpdateMethod", 2);
        }
        this.initListeners();
        this.initUpdateTimer();
    }

    private void initListeners() {
        AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                String key = evt.getKey();
                if ("pluginUpdateCheckInterval".equals(key) || "pluginLastUpdateDateTime".equals(key)) {
                    UpdateManager.this.initUpdateTimer();
                }
            }
        });
    }

    private void initUpdateTimer() {
        Calendar scheduleTime;
        int interval = Math.max(AppPrefs.getProperty("pluginUpdateCheckInterval", 24), 4);
        long lastTimestamp = AppPrefs.getProperty("pluginLastUpdateDateTime", 0L);
        Calendar currentDateTime = Calendar.getInstance();
        if (lastTimestamp < 0L) {
            currentDateTime.add(11, 1);
            scheduleTime = currentDateTime;
        } else {
            scheduleTime = Calendar.getInstance();
            scheduleTime.setTimeInMillis(lastTimestamp);
            scheduleTime.add(11, interval);
            if (lastTimestamp == 0L || currentDateTime.after(scheduleTime)) {
                currentDateTime.add(13, 17);
                scheduleTime = currentDateTime;
            }
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer("UpdateTimer");
        logger.info(String.format("Rescheduling plugins update check to %1$ta %1$tb %1$td %1$tT", scheduleTime.getTime()));
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (UpdateManager.this.checkForUpdates()) {
                    UpdateManager.this.checkUpdate(true);
                }
            }
        }, scheduleTime.getTime(), (long)(interval * 1000) * 3600L);
    }

    private boolean checkForUpdates() {
        return AppPrefs.getProperty("check4PluginUpdatesAutomatically", true);
    }

    public void checkUpdate(final boolean quiet) {
        CheckPluginUpdateTask pluginUpdateTask = new CheckPluginUpdateTask(this.director, this.context, quiet);
        pluginUpdateTask.addTaskListener(new TaskListener.Adapter<List<Plugin>, Void>(){

            @Override
            public void succeeded(final TaskEvent<List<Plugin>> event) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!UpdateManager.this.updating.getAndSet(true)) {
                            UpdateManager.this.updateDetected((List)event.getValue(), quiet);
                            UpdateManager.this.updating.set(false);
                        } else {
                            logger.info("I don't know when this happens, but it happens");
                        }
                    }
                });
            }
        });
        this.context.getTaskService().execute(pluginUpdateTask);
    }

    private void updateDetected(List<Plugin> availablePlugins, boolean quiet) {
        int method = !quiet ? 1 : AppPrefs.getProperty("pluginUpdateMethod", 0);
        List<WrappedPluginData> datas = method == 2 || method == 3 ? this.generateUpdateData(availablePlugins, false) : this.generateUpdateData(availablePlugins, true);
        if (datas.isEmpty()) {
            if (!quiet) {
                Swinger.showInformationDialog(this.context.getResourceMap().getString("updatesNotFoundMessage", new Object[0]));
            }
            return;
        }
        if (method == 0) {
            int res;
            boolean bringToFront;
            boolean bl = bringToFront = !QuietMode.getInstance().isActive() || !QuietMode.getInstance().isDialogsDisabled();
            if (!bringToFront) {
                QuietMode.getInstance().playUserInteractionRequiredSound();
            }
            method = (res = Swinger.showOptionDialog(this.context.getResourceMap(), bringToFront, 3, "informationMessage", "updatesFoundMessage", new String[]{"updateWithDetails", "updateNowButton", "updateCancel"}, new Object[0])) == 0 ? 1 : (res == 1 ? 2 : -1);
        }
        switch (method) {
            case 1: {
                this.showUpdateDialog(datas, false);
                break;
            }
            case 2: {
                this.showUpdateDialog(datas, true);
                break;
            }
            case 3: {
                this.downloadUpdate(datas, quiet);
                break;
            }
        }
    }

    private void showUpdateDialog(List<WrappedPluginData> result, boolean startAutomatically) {
        final UpdateDialog dialog = new UpdateDialog((Frame)this.director.getMainFrame(), this.director);
        dialog.initData(result);
        MainApp app = (MainApp)this.context.getApplication();
        if (startAutomatically) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    dialog.okBtnAction();
                }
            });
        }
        app.prepareDialog(dialog, true);
    }

    private void downloadUpdate(List<WrappedPluginData> pluginList, boolean quiet) {
        Task task = this.getDownloadPluginsTask(pluginList, quiet);
        if (task != null) {
            this.executeUpdateTask(task);
        }
    }

    public DownloadFile getDownloadFileInstance(Plugin plugin) throws MalformedURLException {
        DownloadFile downloadFile = new DownloadFile();
        downloadFile.setFileUrl(new URL(plugin.getUrl()));
        downloadFile.setFileName(plugin.getFilename());
        downloadFile.setState(DownloadState.PAUSED);
        downloadFile.setErrorAttemptsCount(0);
        downloadFile.setFileSize(plugin.getFilesize());
        return downloadFile;
    }

    public Task getDownloadPluginsTask(List<WrappedPluginData> wrappedList, boolean quiet) {
        LinkedList<WrappedPluginData> fileList = new LinkedList<WrappedPluginData>();
        for (WrappedPluginData data : wrappedList) {
            DownloadFile httpFile;
            if (!data.isSelected() || (httpFile = data.getHttpFile()).getState() == DownloadState.COMPLETED) continue;
            fileList.add(data);
        }
        if (fileList.isEmpty()) {
            return null;
        }
        return new DownloadNewPluginsTask(this.director, this.context, fileList, quiet);
    }

    public void executeUpdateTask(Task task) {
        this.context.getTaskService().execute(task);
    }

    private List<WrappedPluginData> generateUpdateData(List<Plugin> list, boolean selectAll) {
        DownloadFile httpFile;
        PluginsManager pluginsManager = this.director.getPluginsManager();
        boolean downloadNotExisting = AppPrefs.getProperty("downloadNotExistingPlugins", true);
        LinkedList<WrappedPluginData> result = new LinkedList<WrappedPluginData>();
        HashSet<String> supportedPluginsIdByServer = new HashSet<String>(list.size());
        for (Plugin plugin : list) {
            boolean checked;
            boolean isNew;
            String id = plugin.getId();
            supportedPluginsIdByServer.add(id);
            Version newVersion = Version.parse(plugin.getVersion());
            plugin.setVersion(newVersion.toString());
            boolean bl = isNew = !pluginsManager.hasPlugin(id);
            if (!isNew) {
                Version oldVersion = Version.parse(pluginsManager.getPluginMetadata(id).getVersion());
                logger.info("id = " + id + "  oldVersion = " + oldVersion + "  newVersion = " + newVersion);
                if (newVersion.equals(oldVersion)) continue;
                PluginMetaData data = pluginsManager.getPluginMetadata(id);
                logger.info("found new plugin with id =" + id);
                if (!data.isUpdatesEnabled()) {
                    logger.info("It's disabled to download new plugins, ignoring " + id);
                    continue;
                }
            }
            boolean bl2 = checked = downloadNotExisting || !isNew;
            if (!checked && !selectAll) continue;
            try {
                httpFile = this.getDownloadFileInstance(plugin);
                WrappedPluginData pluginData = new WrappedPluginData(checked, httpFile, plugin);
                pluginData.setNew(isNew);
                if (!isNew) {
                    pluginData.setPluginInUse(pluginsManager.isPluginInUseForUpdates(id));
                }
                result.add(pluginData);
            }
            catch (MalformedURLException e) {
                LogUtils.processException(logger, e);
            }
        }
        boolean removeNotSupportedPLugins = AppPrefs.getProperty("removeNotSupportedPlugins", false);
        if (removeNotSupportedPLugins) {
            List<PluginMetaData> dataList = pluginsManager.getSupportedPlugins();
            for (PluginMetaData data : dataList) {
                if (supportedPluginsIdByServer.contains(data.getId())) continue;
                Plugin plugin = new Plugin();
                plugin.setId(data.getId());
                plugin.setVersion(data.getVersion());
                plugin.setVendor(data.getVendor());
                plugin.setServices(data.getServices());
                plugin.setUrl(data.getWWW());
                plugin.setFilename("xxxx.frp");
                plugin.setFilesize(0L);
                plugin.setPremium(String.valueOf(data.isPremium()));
                httpFile = new DownloadFile();
                httpFile.setState(DownloadState.QUEUED);
                WrappedPluginData pluginData = new WrappedPluginData(true, httpFile, plugin);
                pluginData.setToBeDeleted(true);
                result.add(pluginData);
            }
        }
        return result;
    }

    private static String getUniqueId(String id, String version) {
        return id + '@' + version;
    }
}

