/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.async;

import jlibs.xml.sax.async.QName;

final class QNamePool {
    private QName[] buckets;
    private int count;
    private int threshold;
    private final float loadFactor;

    public QNamePool(int initialCapacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.buckets = new QName[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public QNamePool() {
        this(101, 0.75f);
    }

    public QName add(int prefixLength, char[] buffer, int offset, int length) {
        int hash = 0;
        for (int i = 0; i < length; ++i) {
            hash = 31 * hash + buffer[offset + i];
        }
        int ibucket = (hash &= 0x7FFFFFF) % this.buckets.length;
        QName bucket = this.buckets[ibucket];
        while (bucket != null) {
            block6: {
                if (bucket.hash == hash && length == bucket.chars.length) {
                    char[] chars = bucket.chars;
                    for (int i = 0; i < length; ++i) {
                        if (buffer[offset + i] == chars[i]) {
                            continue;
                        }
                        break block6;
                    }
                    return bucket;
                }
            }
            bucket = bucket.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            ibucket = hash % this.buckets.length;
        }
        ++this.count;
        this.buckets[ibucket] = new QName(prefixLength, buffer, offset, length, hash, this.buckets[ibucket]);
        return this.buckets[ibucket];
    }

    protected void rehash() {
        QName[] oldTable = this.buckets;
        int oldCapacity = this.buckets.length;
        int newCapacity = oldCapacity * 2 + 1;
        this.buckets = new QName[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        int i = oldCapacity;
        while (i-- > 0) {
            QName old = oldTable[i];
            while (old != null) {
                QName b = old;
                old = old.next;
                int index = b.hash % newCapacity;
                b.next = this.buckets[index];
                this.buckets[index] = b;
            }
        }
    }
}

