/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.service;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.core.filterchain.DefaultIoFilterChain;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilterChainBuilder;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.DefaultIoFuture;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.service.IoServiceListener;
import org.apache.mina.core.service.IoServiceListenerSupport;
import org.apache.mina.core.service.IoServiceStatistics;
import org.apache.mina.core.session.AbstractIoSession;
import org.apache.mina.core.session.DefaultIoSessionDataStructureFactory;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.core.session.IoSessionDataStructureFactory;
import org.apache.mina.core.session.IoSessionInitializationException;
import org.apache.mina.core.session.IoSessionInitializer;
import org.apache.mina.util.ExceptionMonitor;
import org.apache.mina.util.NamePreservingRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIoService
implements IoService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractIoService.class);
    private static final AtomicInteger id = new AtomicInteger();
    private final String threadName;
    private final Executor executor;
    private final boolean createdExecutor;
    private IoHandler handler;
    private final IoSessionConfig sessionConfig;
    private final IoServiceListener serviceActivationListener = new IoServiceListener(){

        public void serviceActivated(IoService ioService) {
            AbstractIoService abstractIoService = (AbstractIoService)ioService;
            IoServiceStatistics ioServiceStatistics = abstractIoService.getStatistics();
            ioServiceStatistics.setLastReadTime(abstractIoService.getActivationTime());
            ioServiceStatistics.setLastWriteTime(abstractIoService.getActivationTime());
            ioServiceStatistics.setLastThroughputCalculationTime(abstractIoService.getActivationTime());
        }

        public void serviceDeactivated(IoService ioService) {
        }

        public void sessionCreated(IoSession ioSession) {
        }

        public void sessionDestroyed(IoSession ioSession) {
        }
    };
    private IoFilterChainBuilder filterChainBuilder = new DefaultIoFilterChainBuilder();
    private IoSessionDataStructureFactory sessionDataStructureFactory = new DefaultIoSessionDataStructureFactory();
    private final IoServiceListenerSupport listeners;
    protected final Object disposalLock = new Object();
    private volatile boolean disposing;
    private volatile boolean disposed;
    private IoServiceStatistics stats = new IoServiceStatistics(this);

    protected AbstractIoService(IoSessionConfig ioSessionConfig, Executor executor) {
        if (ioSessionConfig == null) {
            throw new IllegalArgumentException("sessionConfig");
        }
        if (this.getTransportMetadata() == null) {
            throw new IllegalArgumentException("TransportMetadata");
        }
        if (!this.getTransportMetadata().getSessionConfigType().isAssignableFrom(ioSessionConfig.getClass())) {
            throw new IllegalArgumentException("sessionConfig type: " + ioSessionConfig.getClass() + " (expected: " + this.getTransportMetadata().getSessionConfigType() + ")");
        }
        this.listeners = new IoServiceListenerSupport(this);
        this.listeners.add(this.serviceActivationListener);
        this.sessionConfig = ioSessionConfig;
        ExceptionMonitor.getInstance();
        if (executor == null) {
            this.executor = Executors.newCachedThreadPool();
            this.createdExecutor = true;
        } else {
            this.executor = executor;
            this.createdExecutor = false;
        }
        this.threadName = this.getClass().getSimpleName() + '-' + id.incrementAndGet();
    }

    public final IoFilterChainBuilder getFilterChainBuilder() {
        return this.filterChainBuilder;
    }

    public final DefaultIoFilterChainBuilder getFilterChain() {
        if (this.filterChainBuilder instanceof DefaultIoFilterChainBuilder) {
            return (DefaultIoFilterChainBuilder)this.filterChainBuilder;
        }
        throw new IllegalStateException("Current filter chain builder is not a DefaultIoFilterChainBuilder.");
    }

    public final boolean isActive() {
        return this.listeners.isActive();
    }

    public final boolean isDisposing() {
        return this.disposing;
    }

    public final void dispose() {
        this.dispose(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose(boolean bl) {
        if (this.disposed) {
            return;
        }
        Object object = this.disposalLock;
        synchronized (object) {
            if (!this.disposing) {
                this.disposing = true;
                try {
                    this.dispose0();
                }
                catch (Exception exception) {
                    ExceptionMonitor.getInstance().exceptionCaught(exception);
                }
            }
        }
        if (this.createdExecutor) {
            object = (ExecutorService)this.executor;
            object.shutdownNow();
            if (bl) {
                try {
                    LOGGER.debug("awaitTermination on {} called by thread=[{}]", (Object)this, (Object)Thread.currentThread().getName());
                    object.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
                    LOGGER.debug("awaitTermination on {} finished", (Object)this);
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.warn("awaitTermination on [{}] was interrupted", (Object)this);
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.disposed = true;
    }

    protected abstract void dispose0() throws Exception;

    public final int getManagedSessionCount() {
        return this.listeners.getManagedSessionCount();
    }

    public final IoHandler getHandler() {
        return this.handler;
    }

    public final void setHandler(IoHandler ioHandler) {
        if (ioHandler == null) {
            throw new IllegalArgumentException("handler cannot be null");
        }
        if (this.isActive()) {
            throw new IllegalStateException("handler cannot be set while the service is active.");
        }
        this.handler = ioHandler;
    }

    public IoSessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    public final IoSessionDataStructureFactory getSessionDataStructureFactory() {
        return this.sessionDataStructureFactory;
    }

    public IoServiceStatistics getStatistics() {
        return this.stats;
    }

    public final long getActivationTime() {
        return this.listeners.getActivationTime();
    }

    public final IoServiceListenerSupport getListeners() {
        return this.listeners;
    }

    protected final void executeWorker(Runnable runnable) {
        this.executeWorker(runnable, null);
    }

    protected final void executeWorker(Runnable runnable, String string) {
        String string2 = this.threadName;
        if (string != null) {
            string2 = string2 + '-' + string;
        }
        this.executor.execute(new NamePreservingRunnable(runnable, string2));
    }

    protected final void initSession(IoSession ioSession, IoFuture ioFuture, IoSessionInitializer ioSessionInitializer) {
        if (this.stats.getLastReadTime() == 0L) {
            this.stats.setLastReadTime(this.getActivationTime());
        }
        if (this.stats.getLastWriteTime() == 0L) {
            this.stats.setLastWriteTime(this.getActivationTime());
        }
        try {
            ((AbstractIoSession)ioSession).setAttributeMap(ioSession.getService().getSessionDataStructureFactory().getAttributeMap(ioSession));
        }
        catch (IoSessionInitializationException ioSessionInitializationException) {
            throw ioSessionInitializationException;
        }
        catch (Exception exception) {
            throw new IoSessionInitializationException("Failed to initialize an attributeMap.", exception);
        }
        try {
            ((AbstractIoSession)ioSession).setWriteRequestQueue(ioSession.getService().getSessionDataStructureFactory().getWriteRequestQueue(ioSession));
        }
        catch (IoSessionInitializationException ioSessionInitializationException) {
            throw ioSessionInitializationException;
        }
        catch (Exception exception) {
            throw new IoSessionInitializationException("Failed to initialize a writeRequestQueue.", exception);
        }
        if (ioFuture != null && ioFuture instanceof ConnectFuture) {
            ioSession.setAttribute(DefaultIoFilterChain.SESSION_CREATED_FUTURE, ioFuture);
        }
        if (ioSessionInitializer != null) {
            ioSessionInitializer.initializeSession(ioSession, ioFuture);
        }
        this.finishSessionInitialization0(ioSession, ioFuture);
    }

    protected void finishSessionInitialization0(IoSession ioSession, IoFuture ioFuture) {
    }

    protected static class ServiceOperationFuture
    extends DefaultIoFuture {
        public ServiceOperationFuture() {
            super(null);
        }

        public final void setDone() {
            this.setValue(Boolean.TRUE);
        }
    }
}

