/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.binder;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.binder.ListBindingBuilder;
import com.jgoodies.common.base.Preconditions;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;

public class ListBindingBuilderImpl
implements ListBindingBuilder {
    private final ListModel dataModel;
    private final ListSelectionModel selectionModel;

    public ListBindingBuilderImpl(Object[] data, ListSelectionModel selectionModel) {
        this(new ArrayToListModel(data), selectionModel);
    }

    public ListBindingBuilderImpl(List<?> data, ListSelectionModel selectionModel) {
        this(new ListToListModel(data), selectionModel);
    }

    public ListBindingBuilderImpl(ListModel dataModel, ListSelectionModel selectionModel) {
        this.dataModel = (ListModel)Preconditions.checkNotNull((Object)dataModel, (String)"The ListModel must not be null.");
        this.selectionModel = (ListSelectionModel)Preconditions.checkNotNull((Object)selectionModel, (String)"The ListSelectionModel must not be null.");
    }

    @Override
    public void to(JTable table) {
        Bindings.bind(table, this.dataModel, this.selectionModel);
    }

    @Override
    public void to(JList list) {
        list.setModel(this.dataModel);
        list.setSelectionModel(this.selectionModel);
    }

    private static final class ListToListModel
    extends AbstractListModel {
        private final List<?> list;

        ListToListModel(List<?> list) {
            this.list = list;
        }

        @Override
        public Object getElementAt(int index) {
            return this.list.get(index);
        }

        @Override
        public int getSize() {
            return this.list.size();
        }
    }

    private static final class ArrayToListModel
    extends AbstractListModel {
        private final Object[] array;

        ArrayToListModel(Object[] array) {
            this.array = array;
        }

        @Override
        public Object getElementAt(int index) {
            return this.array[index];
        }

        @Override
        public int getSize() {
            return this.array.length;
        }
    }
}

