/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.bugreport;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.FreeplaneVersion;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.ViewController;
import org.freeplane.plugin.bugreport.BugFormatter;
import org.freeplane.plugin.bugreport.BugReportDialogManager;
import org.freeplane.plugin.bugreport.IBugReportListener;
import org.freeplane.plugin.bugreport.ReportRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportGenerator
extends StreamHandler {
    private static final String BUGREPORT_USER_ID = "org.freeplane.plugin.bugreport.userid";
    private static final String REMOTE_LOG = "RemoteLog";
    private static final String NO_REPORTS_SENT_BEFORE = "no reports sent before";
    static final String LAST_BUG_REPORT_INFO = "last_bug_report_info";
    private static final String BUG_TRACKER_REFERENCE_URL = "http://freeplane.sourceforge.net/info/bugtracker.ref.txt";
    private static String BUG_TRACKER_URL = null;
    static boolean disabled = false;
    private static int errorCounter = 0;
    private static String info;
    private static final String OPTION = "org.freeplane.plugin.bugreport";
    private static ByteArrayOutputStream out;
    private static String version;
    private static String revision;
    private String hash = null;
    private boolean isRunning;
    private String log = null;
    private MessageDigest md = null;
    private boolean reportCollected = false;
    private IBugReportListener bugReportListener;
    JButton logButton;

    private static String toHexString(byte[] v) {
        String HEX_DIGITS = "0123456789abcdef";
        StringBuffer sb = new StringBuffer(v.length * 2);
        for (int i = 0; i < v.length; ++i) {
            int b = v[i] & 0xFF;
            sb.append("0123456789abcdef".charAt(b >>> 4)).append("0123456789abcdef".charAt(b & 0xF));
        }
        return sb.toString();
    }

    public IBugReportListener getBugReportListener() {
        return this.bugReportListener;
    }

    public void setBugReportListener(IBugReportListener bugReportListener) {
        this.bugReportListener = bugReportListener;
    }

    public ReportGenerator() {
        try {
            this.setEncoding("UTF-8");
        }
        catch (SecurityException e) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.setFormatter(new BugFormatter());
        this.setLevel(Level.SEVERE);
    }

    private String calculateHash(String errorMessage) {
        String[] lines = errorMessage.split("\n");
        StringBuffer hashInput = new StringBuffer();
        for (int i = 0; i < lines.length; ++i) {
            String s = lines[i];
            if (!s.startsWith("\tat org.freeplane.") && !s.startsWith("missing key ")) continue;
            hashInput.append(s);
        }
        if (hashInput.length() == 0) {
            return null;
        }
        hashInput.append(version);
        hashInput.append(revision);
        try {
            return this.calculateHash(hashInput.toString().getBytes(this.getEncoding()));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private String calculateHash(byte[] byteArray) {
        try {
            if (this.md == null) {
                this.md = MessageDigest.getInstance("MD5");
            }
            byte[] digest = this.md.digest(byteArray);
            return ReportGenerator.toHexString(digest);
        }
        catch (Exception e) {
            LogUtils.warn((Throwable)e);
            return null;
        }
    }

    private void createInfo() {
        if (info == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("freeplane_version = ");
            version = FreeplaneVersion.getVersion().toString();
            sb.append(version);
            sb.append("; freeplane_xml_version = ");
            sb.append("freeplane 1.3.0");
            revision = FreeplaneVersion.getVersion().getRevision();
            if (!revision.equals("")) {
                sb.append("\nbzr revision = ");
                sb.append(revision);
            }
            sb.append("\njava_version = ");
            sb.append(System.getProperty("java.version"));
            sb.append("; os_name = ");
            sb.append(System.getProperty("os.name"));
            sb.append("; os_version = ");
            sb.append(System.getProperty("os.version"));
            sb.append('\n');
            info = sb.toString();
        }
    }

    private String getBugTrackerUrl() {
        if (BUG_TRACKER_URL != null) {
            return BUG_TRACKER_URL;
        }
        try {
            URL url = new URL(BUG_TRACKER_REFERENCE_URL);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openConnection().getInputStream()));
            BUG_TRACKER_URL = in.readLine();
            return BUG_TRACKER_URL;
        }
        catch (Exception e) {
            disabled = true;
            return null;
        }
    }

    @Override
    public synchronized void publish(LogRecord record) {
        Controller controller = Controller.getCurrentController();
        if (controller == null) {
            return;
        }
        final ViewController viewController = controller.getViewController();
        if (out == null) {
            out = new ByteArrayOutputStream();
            this.setOutputStream(out);
        }
        if (!this.isLoggable(record)) {
            return;
        }
        if (!(disabled || this.isRunning || this.reportCollected)) {
            this.reportCollected = true;
            viewController.invokeLater((Runnable)new SubmitStarter());
        }
        viewController.invokeLater(new Runnable(){

            public void run() {
                try {
                    errorCounter++;
                    if (TextUtils.getRawText((String)"internal_error_tooltip", null) != null) {
                        if (ReportGenerator.this.logButton == null) {
                            ImageIcon errorIcon = new ImageIcon(ResourceController.getResourceController().getResource("/images/icons/messagebox_warning.png"));
                            ReportGenerator.this.logButton = new JButton(){

                                public Dimension getPreferredSize() {
                                    Dimension preferredSize = super.getPreferredSize();
                                    preferredSize.height = this.getIcon().getIconHeight();
                                    return preferredSize;
                                }
                            };
                            ReportGenerator.this.logButton.addActionListener(new LogOpener());
                            ReportGenerator.this.logButton.setIcon(errorIcon);
                            String tooltip = TextUtils.getText((String)"internal_error_tooltip");
                            ReportGenerator.this.logButton.setToolTipText(tooltip);
                            viewController.addStatusComponent("internal_error", (Component)ReportGenerator.this.logButton);
                        }
                        ReportGenerator.this.logButton.setText(TextUtils.format((String)"errornumber", (Object[])new Object[]{errorCounter}));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        super.publish(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSubmit() {
        try {
            this.close();
            String errorMessage = out.toString(this.getEncoding());
            if (errorMessage.indexOf(this.getClass().getPackage().getName()) != -1) {
                System.err.println("don't send bug reports from bugreport plugin");
                return;
            }
            this.createInfo();
            this.hash = this.calculateHash(errorMessage);
            if (this.hash == null) {
                return;
            }
            String reportHeader = this.createReportHeader();
            StringBuilder sb = new StringBuilder();
            sb.append(reportHeader).append('\n').append("previous report : ");
            String lastReportInfo = ResourceController.getResourceController().getProperty(LAST_BUG_REPORT_INFO, NO_REPORTS_SENT_BEFORE);
            sb.append(lastReportInfo).append('\n');
            String userId = ResourceController.getResourceController().getProperty(BUGREPORT_USER_ID);
            if (userId.length() > 0) {
                sb.append("user : ").append(userId).append('\n');
            }
            sb.append(info);
            sb.append(errorMessage);
            this.log = sb.toString();
            if (this.log.equals("")) {
                return;
            }
            ReportRegistry register = ReportRegistry.getInstance();
            if (register.isReportRegistered(this.hash)) {
                return;
            }
            String option = this.showBugReportDialog();
            if ("org.freeplane.plugin.bugreport.allowed".equals(option)) {
                register.registerReport(this.hash, reportHeader);
                LinkedHashMap<String, String> report = new LinkedHashMap<String, String>();
                report.put("hash", this.hash);
                report.put("log", this.log);
                report.put("version", version);
                report.put("revision", revision);
                String status = this.sendReport(report);
                if (this.bugReportListener == null || status == null) {
                    return;
                }
                this.bugReportListener.onReportSent(report, status);
            }
        }
        catch (UnsupportedEncodingException e) {
            LogUtils.severe((Throwable)e);
        }
        finally {
            out = null;
            this.reportCollected = false;
            this.isRunning = false;
        }
    }

    private String createReportHeader() {
        SimpleDateFormat dateFormatGmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormatGmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        String time = dateFormatGmt.format(new Date());
        String currentReportInfo = "at " + time + " CMT,  hash " + this.hash;
        return currentReportInfo;
    }

    private String showBugReportDialog() {
        String option = ResourceController.getResourceController().getProperty(OPTION, "org.freeplane.plugin.bugreport.ask");
        if (option.equals("org.freeplane.plugin.bugreport.ask")) {
            if (FreeplaneVersion.getVersion().isFinal()) {
                return "org.freeplane.plugin.bugreport.denied";
            }
            String question = TextUtils.getText((String)"org.freeplane.plugin.bugreport.question");
            if (!question.startsWith("<html>")) {
                question = HtmlUtils.plainToHTML((String)question);
            }
            Object[] options = new Object[]{TextUtils.getText((String)"org.freeplane.plugin.bugreport.always_agree"), TextUtils.getText((String)"org.freeplane.plugin.bugreport.agree"), TextUtils.getText((String)"org.freeplane.plugin.bugreport.deny"), TextUtils.getText((String)"org.freeplane.plugin.bugreport.always_deny")};
            String title = TextUtils.getText((String)"org.freeplane.plugin.bugreport.dialog.title");
            String reportName = TextUtils.getText((String)"org.freeplane.plugin.bugreport.report");
            int choice = BugReportDialogManager.showBugReportDialog(title, question, 1, options, options[1], reportName, this.log);
            switch (choice) {
                case 0: {
                    option = "org.freeplane.plugin.bugreport.allowed";
                    ResourceController.getResourceController().setProperty(OPTION, option);
                    break;
                }
                case 1: {
                    option = "org.freeplane.plugin.bugreport.allowed";
                    break;
                }
                case 2: {
                    option = "org.freeplane.plugin.bugreport.denied";
                    break;
                }
                case 3: {
                    option = "org.freeplane.plugin.bugreport.denied";
                    ResourceController.getResourceController().setProperty(OPTION, option);
                    break;
                }
                default: {
                    option = "org.freeplane.plugin.bugreport.denied";
                }
            }
        }
        return option;
    }

    private String sendReport(Map<String, String> reportFields) {
        try {
            StringBuilder data = new StringBuilder();
            for (Map.Entry<String, String> entry : reportFields.entrySet()) {
                if (data.length() != 0) {
                    data.append('&');
                }
                data.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
                data.append('=');
                data.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
            URL url = new URL(this.getBugTrackerUrl());
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data.toString());
            wr.flush();
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line = rd.readLine();
            if (line != null) {
                System.out.println(line);
            }
            wr.close();
            rd.close();
            return line;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void startSubmit() {
        this.isRunning = true;
        Thread submitterThread = new Thread((Runnable)new SubmitRunner(), REMOTE_LOG);
        submitterThread.start();
    }

    static {
        out = null;
    }

    private static class LogOpener
    implements ActionListener {
        private LogOpener() {
        }

        public void actionPerformed(ActionEvent e) {
            String freeplaneLogDirectoryPath = LogUtils.getLogDirectory();
            File file = new File(freeplaneLogDirectoryPath);
            if (file.isDirectory()) {
                ViewController viewController = Controller.getCurrentController().getViewController();
                try {
                    viewController.openDocument(file.toURL());
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    private class SubmitStarter
    implements Runnable {
        SubmitStarter() {
            if (Controller.getCurrentController().getViewController().isDispatchThread()) {
                return;
            }
            final Thread currentThread = Thread.currentThread();
            Controller.getCurrentController().getViewController().invokeLater(new Runnable(){

                public void run() {
                    try {
                        currentThread.join(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
        }

        public void run() {
            ReportGenerator.this.startSubmit();
        }
    }

    private class SubmitRunner
    implements Runnable {
        public void run() {
            ReportGenerator.this.runSubmit();
        }
    }
}

