/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.condpermadmin;

import java.security.cert.Certificate;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.permissions.CertificateUtil;
import org.osgi.framework.Bundle;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.condpermadmin.ConditionInfo;

public class BundleSignerCondition {
    private static final String CONDITION_TYPE = "org.osgi.service.condpermadmin.BundleSignerCondition";

    public static Condition getCondition(Bundle bundle, ConditionInfo info) {
        if (!CONDITION_TYPE.equals(info.getType())) {
            throw new IllegalArgumentException("ConditionInfo must be of type \"org.osgi.service.condpermadmin.BundleSignerCondition\"");
        }
        String[] args = info.getArgs();
        if (args.length != 1) {
            throw new IllegalArgumentException("Illegal number of args: " + args.length);
        }
        Certificate[] certs = ((BundleImpl)bundle).getCertificates();
        if (CertificateUtil.matchCertificates(certs, args[0]) >= 0) {
            return Condition.TRUE;
        }
        return Condition.FALSE;
    }

    private BundleSignerCondition() {
    }
}

