/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.security.AccessController;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.knopflerfish.framework.LDAPExpr;
import org.osgi.framework.AdminPermissionCollection;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;

public final class AdminPermission
extends BasicPermission {
    public static final String CLASS = "class";
    public static final String EXECUTE = "execute";
    public static final String EXTENSIONLIFECYCLE = "extensionLifecycle";
    public static final String LIFECYCLE = "lifecycle";
    public static final String LISTENER = "listener";
    public static final String METADATA = "metadata";
    public static final String RESOLVE = "resolve";
    public static final String RESOURCE = "resource";
    public static final String STARTLEVEL = "startlevel";
    public static final String CONTEXT = "context";
    LDAPExpr ldap;
    Bundle bundle;
    int actionMask;
    private static final String WILDCARD = "*";
    private static final int CLASS_BIT = 1;
    private static final int EXECUTE_BIT = 2;
    private static final int EXTENSIONLIFECYCLE_BIT = 4;
    private static final int LIFECYCLE_BIT = 8;
    private static final int LISTENER_BIT = 16;
    private static final int METADATA_BIT = 32;
    private static final int RESOLVE_BIT = 64;
    private static final int RESOURCE_BIT = 128;
    private static final int STARTLEVEL_BIT = 256;
    private static final int CONTEXT_BIT = 512;
    private static final int ALL_BITS = 1023;

    public AdminPermission() {
        this(WILDCARD, WILDCARD);
    }

    public AdminPermission(String filter, String actions) {
        super(filter == null ? (filter = WILDCARD) : filter);
        try {
            this.ldap = new LDAPExpr(filter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        this.parseActions(actions);
        this.bundle = null;
    }

    public AdminPermission(Bundle bundle, String actions) {
        super("BID#" + bundle.getBundleId());
        this.bundle = bundle;
        this.parseActions(actions);
    }

    AdminPermission(String filter, int actionMask) {
        super(filter);
        this.actionMask = actionMask;
        this.bundle = null;
    }

    AdminPermission(Bundle bundle, int actionMask) {
        super("BID#" + bundle.getBundleId());
        this.actionMask = actionMask;
    }

    private void parseActions(String actions) {
        StringTokenizer st = new StringTokenizer(actions, ",");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals(CLASS)) {
                this.actionMask |= 1;
                continue;
            }
            if (tok.equals(EXECUTE)) {
                this.actionMask |= 2;
                continue;
            }
            if (tok.equals(EXTENSIONLIFECYCLE)) {
                this.actionMask |= 4;
                continue;
            }
            if (tok.equals(LIFECYCLE)) {
                this.actionMask |= 8;
                continue;
            }
            if (tok.equals(LISTENER)) {
                this.actionMask |= 0x10;
                continue;
            }
            if (tok.equals(METADATA)) {
                this.actionMask |= 0x20;
                continue;
            }
            if (tok.equals(RESOLVE)) {
                this.actionMask |= 0x40;
                continue;
            }
            if (tok.equals(RESOURCE)) {
                this.actionMask |= 0x80;
                continue;
            }
            if (tok.equals(STARTLEVEL)) {
                this.actionMask |= 0x100;
                continue;
            }
            if (tok.equals(CONTEXT)) {
                this.actionMask |= 0x200;
                continue;
            }
            if (tok.equals(WILDCARD)) {
                this.actionMask = 1023;
                continue;
            }
            throw new IllegalArgumentException("Unknown action " + tok);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AdminPermission)) {
            return false;
        }
        AdminPermission ap = (AdminPermission)obj;
        if (this.bundle == null) {
            return this.actionMask == ap.actionMask && this.getName().equals(ap.getName());
        }
        return this.actionMask == ap.actionMask && this.bundle == ap.bundle;
    }

    public int hashCode() {
        if (this.bundle == null) {
            return this.getName().hashCode() ^ this.actionMask;
        }
        return this.bundle.hashCode() ^ this.actionMask;
    }

    public String getActions() {
        int length;
        StringBuffer sb = new StringBuffer();
        if ((this.actionMask & 1) != 0) {
            sb.append(CLASS);
            sb.append(',');
        }
        if ((this.actionMask & 2) != 0) {
            sb.append(EXECUTE);
            sb.append(',');
        }
        if ((this.actionMask & 4) != 0) {
            sb.append(EXTENSIONLIFECYCLE);
            sb.append(',');
        }
        if ((this.actionMask & 8) != 0) {
            sb.append(LIFECYCLE);
            sb.append(',');
        }
        if ((this.actionMask & 0x10) != 0) {
            sb.append(LISTENER);
            sb.append(',');
        }
        if ((this.actionMask & 0x20) != 0) {
            sb.append(METADATA);
            sb.append(',');
        }
        if ((this.actionMask & 0x40) != 0) {
            sb.append(RESOLVE);
            sb.append(',');
        }
        if ((this.actionMask & 0x80) != 0) {
            sb.append(RESOURCE);
            sb.append(',');
        }
        if ((this.actionMask & 0x100) != 0) {
            sb.append(STARTLEVEL);
            sb.append(',');
        }
        if ((this.actionMask & 0x200) != 0) {
            sb.append(CONTEXT);
            sb.append(',');
        }
        if ((length = sb.length()) > 0) {
            sb.deleteCharAt(length - 1);
        }
        return sb.toString();
    }

    private boolean match(final AdminPermission ap) {
        final Hashtable t = new Hashtable();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                t.put("id", new Long(ap.bundle.getBundleId()));
                t.put("location", ap.bundle.getLocation());
                t.put("name", ap.bundle.getSymbolicName());
                return null;
            }
        });
        return this.ldap.evaluate(t, false);
    }

    public boolean implies(Permission p) {
        if (!(p instanceof AdminPermission)) {
            return false;
        }
        AdminPermission ap = (AdminPermission)p;
        if (ap.bundle == null && !ap.getName().equals(WILDCARD)) {
            throw new RuntimeException("permission not contructed with bundle or *");
        }
        if ((this.actionMask & ap.actionMask) != ap.actionMask) {
            return false;
        }
        if (this.bundle != null) {
            return this.bundle == ap.bundle || ap.getName().equals(WILDCARD);
        }
        return this.getName().equals(WILDCARD) || this.match(ap);
    }

    public PermissionCollection newPermissionCollection() {
        return new AdminPermissionCollection();
    }
}

