/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.validator;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;
import org.knopflerfish.framework.Validator;

public class SelfSignedValidator
implements Validator {
    private static final String CERT_TYPE_X509 = "X.509";

    public Certificate[] checkCertificates(Certificate[] certs) {
        ArrayList<Certificate> failed = new ArrayList<Certificate>();
        ArrayList<Certificate> chain = new ArrayList<Certificate>();
        String certPathType = null;
        boolean chainEnd = false;
        X500Principal prevIssuer = null;
        int i = 0;
        while (i < certs.length) {
            if (certPathType == null) {
                certPathType = certs[i].getType();
            } else if (certPathType != certs[i].getType()) break;
            if (certPathType == CERT_TYPE_X509) {
                X509Certificate cert = (X509Certificate)certs[i];
                X500Principal issuer = cert.getIssuerX500Principal();
                X500Principal subject = cert.getSubjectX500Principal();
                if (prevIssuer != null && !prevIssuer.equals(subject)) break;
                if (subject.equals(issuer)) {
                    chainEnd = true;
                    prevIssuer = null;
                } else {
                    prevIssuer = issuer;
                }
            } else {
                failed.add(certs[i++]);
                continue;
            }
            if (chainEnd) {
                chain.clear();
                chainEnd = false;
                ++i;
                continue;
            }
            chain.add(certs[i++]);
        }
        failed.addAll(chain);
        while (i < certs.length) {
            failed.add(certs[i++]);
        }
        return failed.toArray(new Certificate[failed.size()]);
    }
}

