/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.validator;

import java.io.File;
import java.io.FileInputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidator;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.knopflerfish.framework.Framework;
import org.knopflerfish.framework.Validator;

public class JKSValidator
implements Validator {
    private static final String CERT_ALGORITHM_PKIX = "PKIX";
    private static final String CERT_TYPE_X509 = "X.509";
    private static final String PROP_BASE = "org.knopflerfish.framework.validator.jks.";
    private static String caCertsFileName = Framework.getProperty("org.knopflerfish.framework.validator.jks.ca_certs");
    private static String caCertsPassword = Framework.getProperty("org.knopflerfish.framework.validator.jks.ca_certs_password");
    private static final String certProvider = Framework.getProperty("org.knopflerfish.framework.validator.jks.cert_provider");
    private static String certAlgorithm = "PKIX";
    private static CertificateFactory certFactory = null;
    private static String certFactoryType = null;
    private static CertPathValidator certValidator = null;
    private static String certValidatorAlgorithm = null;
    private KeyStore keystore = this.getKeyStore();

    public Certificate[] checkCertificates(Certificate[] certs) {
        ArrayList<? extends Certificate> failed = new ArrayList<Certificate>();
        Iterator i = this.getCertificateChains(certs, failed).iterator();
        while (i.hasNext()) {
            CertPath c = (CertPath)i.next();
            try {
                CertPathValidator cpv = this.getCertPathValidator(certAlgorithm);
                CertPathParameters params = JKSValidator.getCertPathParameters(this.keystore, certAlgorithm);
                cpv.validate(c, params);
            }
            catch (GeneralSecurityException gse) {
                failed.addAll(c.getCertificates());
            }
        }
        return failed.toArray(new Certificate[failed.size()]);
    }

    private List getCertificateChains(Certificate[] c, List failed) {
        ArrayList<CertPath> res = new ArrayList<CertPath>();
        ArrayList<Certificate> chain = new ArrayList<Certificate>();
        String certPathType = null;
        boolean foundAnchor = false;
        int i = 0;
        while (i < c.length) {
            if (certPathType == null) {
                certPathType = c[i].getType();
            } else if (certPathType != c[i].getType()) break;
            if (certPathType == CERT_TYPE_X509) {
                X509Certificate cert = (X509Certificate)c[i];
                if (cert.getIssuerX500Principal().equals(cert.getSubjectX500Principal())) {
                    foundAnchor = true;
                }
            } else {
                failed.add(c[i++]);
                continue;
            }
            chain.add(c[i++]);
            if (!foundAnchor) continue;
            try {
                res.add(JKSValidator.getCertificateFactory(certPathType).generateCertPath(chain));
            }
            catch (GeneralSecurityException gse) {
                failed.addAll(chain);
            }
            chain.clear();
            foundAnchor = false;
        }
        failed.addAll(chain);
        while (i < c.length) {
            failed.add(c[i++]);
        }
        return res;
    }

    static CertificateFactory getCertificateFactory(String certType) throws GeneralSecurityException {
        if (certFactory == null || certFactoryType != certType) {
            certFactoryType = certType;
            certFactory = certProvider != null ? CertificateFactory.getInstance(certType, certProvider) : CertificateFactory.getInstance(certType);
        }
        return certFactory;
    }

    static CertPathParameters getCertPathParameters(KeyStore keystore, String certAlgo) throws GeneralSecurityException {
        if (CERT_ALGORITHM_PKIX.equals(certAlgo)) {
            PKIXParameters p = new PKIXParameters(keystore);
            p.setRevocationEnabled(false);
            return p;
        }
        throw new GeneralSecurityException(certAlgo + " not supported");
    }

    CertPathValidator getCertPathValidator(String certAlgo) throws GeneralSecurityException {
        if (certValidator == null || certValidatorAlgorithm != certAlgo) {
            certValidatorAlgorithm = certAlgo;
            certValidator = certProvider != null ? CertPathValidator.getInstance(certAlgo, certProvider) : CertPathValidator.getInstance(certAlgo);
        }
        return certValidator;
    }

    KeyStore getKeyStore() {
        if (caCertsFileName == null) {
            caCertsFileName = System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar);
        }
        if (caCertsPassword == null) {
            caCertsPassword = "changeit";
        }
        try {
            FileInputStream is = new FileInputStream(caCertsFileName);
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(is, caCertsPassword.toCharArray());
            return keystore;
        }
        catch (Exception e) {
            System.err.println("Failed to load keystore, " + caCertsFileName + ": " + e);
            return null;
        }
    }
}

