/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.security.AccessControlContext;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.knopflerfish.framework.permissions.ConditionalPermission;
import org.knopflerfish.framework.permissions.Debug;
import org.osgi.service.condpermadmin.Condition;

class PostponementCheck
implements PrivilegedAction {
    private AccessControlContext acc;
    private Permission perm;
    private ArrayList checkedClasses;
    private ArrayList ppList;
    private int[] perms;
    private int[] curr;

    PostponementCheck(AccessControlContext acc, Permission perm, PostponementCheck previous) {
        this.acc = acc;
        this.perm = perm;
        this.checkedClasses = previous != null ? previous.getCheckedClasses() : null;
        this.ppList = null;
    }

    ArrayList getCheckedClasses() {
        if (this.checkedClasses != null) {
            return (ArrayList)this.checkedClasses.clone();
        }
        return null;
    }

    public void savePostponement(List postponement) {
        if (this.ppList == null) {
            this.ppList = new ArrayList(2);
        }
        this.ppList.add(postponement);
    }

    public Object run() {
        this.acc.checkPermission(this.perm);
        this.checkPostponements();
        return null;
    }

    private void initPermutations() {
        int depth = this.ppList.size();
        this.perms = new int[depth];
        this.curr = new int[depth];
        for (int i = 0; i < depth; ++i) {
            this.perms[i] = ((List)this.ppList.get(i)).size();
            this.curr[i] = 0;
        }
    }

    private Map getNextPermutation() {
        if (this.curr != null) {
            HashMap res = new HashMap();
            boolean increment = true;
            for (int i = 0; i < this.curr.length; ++i) {
                ConditionalPermission cp = (ConditionalPermission)((List)this.ppList.get(i)).get(this.curr[i]);
                Iterator pi = cp.getPostponed();
                while (pi.hasNext()) {
                    Object o = pi.next();
                    Class<?> co = o.getClass();
                    ArrayList<ConditionalPermission> x = (ArrayList<ConditionalPermission>)res.get(co);
                    if (x == null) {
                        x = new ArrayList<ConditionalPermission>(2);
                    }
                    x.add(0, (ConditionalPermission)o);
                    x.add(cp);
                    res.put(co, x);
                }
                if (!increment) continue;
                int n = i;
                this.curr[n] = this.curr[n] + 1;
                if (this.curr[n] == this.perms[i]) {
                    this.curr[i] = 0;
                    continue;
                }
                increment = false;
            }
            if (increment) {
                this.curr = null;
            }
            return res;
        }
        return null;
    }

    private void checkPostponements() {
        if (this.ppList != null) {
            Map cm;
            HashMap condDict = new HashMap();
            if (this.checkedClasses == null) {
                this.checkedClasses = new ArrayList();
            }
            this.initPermutations();
            boolean permcount = true;
            while ((cm = this.getNextPermutation()) != null) {
                boolean ok = true;
                Iterator i = cm.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry me = i.next();
                    Class cc = (Class)me.getKey();
                    if (this.checkedClasses.contains(cc)) {
                        ok = false;
                        break;
                    }
                    ArrayList cs = (ArrayList)me.getValue();
                    Hashtable d = (Hashtable)condDict.get(cc);
                    if (d == null) {
                        d = new Hashtable();
                        condDict.put(cc, d);
                    }
                    this.checkedClasses.add(cc);
                    try {
                        int j;
                        int size = cs.size() / 2;
                        Condition[] conditions = new Condition[size];
                        ConditionalPermission[] immutables = new ConditionalPermission[size];
                        for (j = 0; j < size; ++j) {
                            Condition ce;
                            conditions[j] = ce = (Condition)cs.get(size - j - 1);
                            immutables[j] = ce.isMutable() ? null : (ConditionalPermission)cs.get(size + j);
                        }
                        ok = conditions[0].isSatisfied(conditions, d);
                        for (j = 0; j < size; ++j) {
                            if (immutables[j] == null) continue;
                            immutables[j].setImmutable(conditions[j], ok);
                        }
                    }
                    catch (Throwable t) {
                        ok = false;
                    }
                    this.checkedClasses.remove(this.checkedClasses.size() - 1);
                    if (ok) continue;
                    break;
                }
                if (!ok) continue;
                if (Debug.permissions) {
                    Debug.println("CHECK_POSTPONE: postponement ok");
                }
                return;
            }
            if (Debug.permissions) {
                Debug.println("CHECK_POSTPONE: postponement failed");
            }
            throw new SecurityException("Postponed conditions failed");
        }
    }
}

