/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.io.DataInputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.knopflerfish.framework.Framework;
import org.knopflerfish.framework.permissions.ConditionalPermission;
import org.knopflerfish.framework.permissions.ConditionalPermissionInfoImpl;
import org.knopflerfish.framework.permissions.ConditionalPermissionInfoStorage;
import org.knopflerfish.framework.permissions.ConditionalPermissionSecurityManager;
import org.knopflerfish.framework.permissions.Debug;
import org.knopflerfish.framework.permissions.PermUtil;
import org.knopflerfish.framework.permissions.PermissionInfoStorage;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.service.permissionadmin.PermissionInfo;

public class PermissionsWrapper
extends PermissionCollection {
    private static final long serialVersionUID = 1L;
    String location;
    private Bundle bundle;
    private PermissionInfoStorage pinfos;
    private ConditionalPermissionInfoStorage cpinfos;
    private PermissionCollection implicitPermissions;
    private PermissionCollection localPermissions;
    private volatile PermissionCollection systemPermissions;
    private File dataRoot;
    private boolean readOnly = false;
    private ArrayList condPermList = null;

    PermissionsWrapper(Framework fw, PermissionInfoStorage pis, ConditionalPermissionInfoStorage cpis, String loc, Bundle b, InputStream localPerms) {
        this.pinfos = pis;
        this.cpinfos = cpis;
        this.location = loc;
        this.bundle = b;
        this.dataRoot = fw.getDataStorage(b.getBundleId());
        this.localPermissions = localPerms != null ? this.makeLocalPermissionCollection(localPerms) : null;
        this.implicitPermissions = this.makeImplicitPermissionCollection(fw, b);
        this.initCondPermList();
        this.systemPermissions = this.makePermissionCollection();
    }

    public void add(Permission permission) {
        PermissionCollection p = this.getPerms();
        if (p == null) {
            throw new RuntimeException("NYI! Using Conditional Permissions");
        }
        p.add(permission);
    }

    public Enumeration elements() {
        final PermissionCollection p = this.getPerms();
        if (p == null) {
            throw new RuntimeException("NYI! Using Conditional Permissions 2");
        }
        return new Enumeration(){
            private Enumeration implicitElements;
            private Enumeration systemElements;
            {
                this.implicitElements = PermissionsWrapper.this.implicitPermissions.elements();
                this.systemElements = p.elements();
            }

            public boolean hasMoreElements() {
                if (this.implicitElements != null) {
                    if (this.implicitElements.hasMoreElements()) {
                        return true;
                    }
                    this.implicitElements = null;
                }
                return this.systemElements.hasMoreElements();
            }

            public Object nextElement() {
                if (this.implicitElements != null) {
                    try {
                        return this.implicitElements.nextElement();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        this.implicitElements = null;
                    }
                }
                return this.systemElements.nextElement();
            }
        };
    }

    public boolean implies(Permission permission) {
        boolean res;
        String me = "PermissionWrapper.implies: ";
        if (this.implicitPermissions.implies(permission)) {
            if (Debug.permissions) {
                Debug.println(me + "Implicitly OK for, " + permission);
            }
            return true;
        }
        if (this.localPermissions != null && !this.localPermissions.implies(permission)) {
            if (Debug.permissions) {
                Debug.println(me + "No localpermissions for, " + permission);
            }
            return false;
        }
        PermissionCollection p = this.getPerms();
        if (p != null) {
            res = p.implies(permission);
            if (Debug.permissions) {
                Debug.println(me + (res ? "OK" : "No") + " framework permission for," + permission);
            }
        } else {
            res = this.conditionalPermissionImplies(permission);
            if (Debug.permissions) {
                Debug.println(me + (res ? "OK" : "No") + " conditional permission for," + permission);
            }
        }
        return res;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly() {
        if (!this.readOnly) {
            this.readOnly = true;
            PermissionCollection p = this.getPerms();
            if (p != null) {
                p.setReadOnly();
            }
        }
    }

    synchronized void invalidate() {
        this.systemPermissions = null;
    }

    synchronized void updateLocalPermissions(InputStream localPerms) {
        this.localPermissions = localPerms != null ? this.makeLocalPermissionCollection(localPerms) : null;
    }

    private PermissionCollection getPerms0() {
        if (this.systemPermissions == null) {
            PermissionCollection p = this.makePermissionCollection();
            if (this.readOnly && p != null) {
                p.setReadOnly();
            }
            this.systemPermissions = p;
        }
        return this.systemPermissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PermissionCollection getPerms() {
        if (Framework.isDoubleCheckedLockingSafe) {
            if (this.systemPermissions == null) {
                PermissionsWrapper permissionsWrapper = this;
                synchronized (permissionsWrapper) {
                    return this.getPerms0();
                }
            }
            return this.systemPermissions;
        }
        PermissionsWrapper permissionsWrapper = this;
        synchronized (permissionsWrapper) {
            return this.getPerms0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PermissionCollection makeLocalPermissionCollection(InputStream localPerms) {
        try {
            String l;
            DataInputStream dis = new DataInputStream(localPerms);
            Permissions res = new Permissions();
            while ((l = dis.readLine()) != null) {
                if ((l = l.trim()).startsWith("#") || l.startsWith("//") || l.length() == 0) continue;
                try {
                    Permission p = PermUtil.makePermission(new PermissionInfo(l), null);
                    if (p == null) continue;
                    res.add(p);
                }
                catch (Exception e) {}
            }
            Permissions permissions = res;
            return permissions;
        }
        catch (IOException e) {
            PermissionCollection permissionCollection = null;
            return permissionCollection;
        }
        finally {
            try {
                localPerms.close();
            }
            catch (IOException _ignore) {}
        }
    }

    private PermissionCollection makeImplicitPermissionCollection(Framework fw, Bundle b) {
        Permissions pc = new Permissions();
        if (this.dataRoot != null) {
            pc.add(new FilePermission(this.dataRoot.getPath(), "read,write"));
            pc.add(new FilePermission(new File(this.dataRoot, "-").getPath(), "read,write,delete"));
        }
        pc.add(new AdminPermission(b, "resource,metadata,class"));
        return pc;
    }

    private PermissionCollection makePermissionCollection() {
        PermissionInfo[] pi = this.pinfos.get(this.location, this);
        boolean useDefault = pi == null;
        Permissions res = new Permissions();
        if (useDefault) {
            if (Debug.tck401compat ? this.condPermList.size() > 0 : this.cpinfos != null && this.cpinfos.size() > 0) {
                return null;
            }
            pi = this.pinfos.getDefault(this);
        }
        for (int i = pi.length - 1; i >= 0; --i) {
            Permission p = PermUtil.makePermission(pi[i], useDefault ? null : this.dataRoot);
            if (p == null) continue;
            res.add(p);
        }
        return res;
    }

    private boolean conditionalPermissionImplies(Permission permission) {
        ArrayList<ConditionalPermission> postponement = null;
        SecurityManager sm = System.getSecurityManager();
        ConditionalPermissionSecurityManager cpsm = sm instanceof ConditionalPermissionSecurityManager ? (ConditionalPermissionSecurityManager)((Object)sm) : null;
        Iterator i = ((AbstractList)this.condPermList).iterator();
        while (i.hasNext()) {
            ConditionalPermission cp = (ConditionalPermission)i.next();
            if (Debug.permissions) {
                Debug.println("conditionalPermissionImplies: Check if " + cp + " implies " + permission + " for " + this.bundle);
            }
            if (cp.checkImmediateOk(permission, cpsm == null)) {
                if (cp.hasPostponed()) {
                    if (Debug.permissions) {
                        Debug.println("conditionalPermissionImplies: " + cp + " with postponement implies " + permission + " for " + this.bundle);
                    }
                    if (postponement == null) {
                        postponement = new ArrayList<ConditionalPermission>();
                    }
                    postponement.add(cp);
                    continue;
                }
                if (Debug.permissions) {
                    Debug.println("conditionalPermissionImplies: " + cp + " implies " + permission + " for " + this.bundle);
                }
                return true;
            }
            if (!Debug.permissions) continue;
            Debug.println("conditionalPermissionImplies: " + cp + " does NOT imply " + permission + " for " + this.bundle);
        }
        if (postponement != null) {
            cpsm.savePostponement(postponement);
            return true;
        }
        return false;
    }

    synchronized void updateChangedConditionalPermission(ConditionalPermissionInfoImpl cpi, ConditionalPermissionInfoImpl old) {
        ConditionalPermission new_cp;
        ConditionalPermission conditionalPermission = new_cp = cpi != null ? cpi.getConditionalPermission(this.bundle) : null;
        if (old != null) {
            for (int i = this.condPermList.size() - 1; i >= 0; --i) {
                ConditionalPermission cp = (ConditionalPermission)this.condPermList.get(i);
                if (!cp.isParent(old)) continue;
                if (new_cp != null) {
                    this.condPermList.set(i, new_cp);
                } else {
                    this.condPermList.remove(i);
                }
                return;
            }
        }
        if (new_cp != null) {
            this.condPermList.add(new_cp);
        }
        this.invalidate();
    }

    private void initCondPermList() {
        this.condPermList = new ArrayList();
        Enumeration e = this.cpinfos.getAll();
        while (e.hasMoreElements()) {
            ConditionalPermissionInfoImpl cpi = (ConditionalPermissionInfoImpl)e.nextElement();
            if (Debug.permissions) {
                Debug.println("conditionalPermissionImplies: " + cpi + " Bundle#" + this.bundle.getBundleId());
            }
            this.updateChangedConditionalPermission(cpi, null);
        }
    }
}

