/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.io.InputStream;
import java.security.PermissionCollection;
import java.security.Policy;
import java.util.Hashtable;
import java.util.Iterator;
import org.knopflerfish.framework.Framework;
import org.knopflerfish.framework.permissions.ConditionalPermissionAdminImpl;
import org.knopflerfish.framework.permissions.ConditionalPermissionInfoStorage;
import org.knopflerfish.framework.permissions.FrameworkPolicy;
import org.knopflerfish.framework.permissions.PermissionAdminImpl;
import org.knopflerfish.framework.permissions.PermissionInfoStorage;
import org.knopflerfish.framework.permissions.PermissionsWrapper;
import org.osgi.framework.Bundle;

public class PermissionsHandle {
    Framework framework;
    private PermissionInfoStorage pinfos;
    private ConditionalPermissionInfoStorage cpinfos;
    private Hashtable pcCache = new Hashtable();
    private PermissionAdminImpl pa;
    private ConditionalPermissionAdminImpl cpa;

    public PermissionsHandle(Framework fw) {
        this.framework = fw;
        this.pinfos = new PermissionInfoStorage();
        this.pa = new PermissionAdminImpl(this.pinfos);
        if (System.getSecurityManager() instanceof SecurityManager) {
            this.cpinfos = new ConditionalPermissionInfoStorage(this);
            this.cpa = new ConditionalPermissionAdminImpl(this.cpinfos);
        } else {
            this.cpinfos = null;
            this.cpa = null;
        }
        Policy.setPolicy(new FrameworkPolicy(Policy.getPolicy(), this));
    }

    public PermissionAdminImpl getPermissionAdminService() {
        return this.pa;
    }

    public ConditionalPermissionAdminImpl getConditionalPermissionAdminService() {
        return this.cpa;
    }

    public PermissionCollection getPermissionCollection(Long bid) {
        return (PermissionCollection)this.pcCache.get(bid);
    }

    public PermissionCollection createPermissionCollection(String loc, Bundle b, InputStream localPerms) {
        Long bid = new Long(b.getBundleId());
        PermissionsWrapper pc = new PermissionsWrapper(this.framework, this.pinfos, this.cpinfos, loc, b, localPerms);
        this.pcCache.put(bid, pc);
        return pc;
    }

    public boolean purgePermissionCollection(Long bid, PermissionCollection pc) {
        this.pinfos.purgeCallback(pc);
        if (this.pcCache.get(bid) == pc) {
            this.pcCache.remove(bid);
            return true;
        }
        return false;
    }

    Iterator getPermissionWrappers() {
        return this.pcCache.values().iterator();
    }
}

