/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.knopflerfish.framework.Util;
import org.knopflerfish.framework.permissions.Debug;
import org.knopflerfish.framework.permissions.PermUtil;
import org.knopflerfish.framework.permissions.PermissionsWrapper;
import org.osgi.service.permissionadmin.PermissionInfo;

class PermissionInfoStorage {
    static final String DEFAULTPERM = "(java.security.AllPermission)";
    private PermissionInfo[] initialDefault = null;
    private File permDir;
    private long lastPermFile;
    private HashMap permissions = new HashMap();
    private PermissionInfo[] defaultPermissions;
    private HashMap defaultInvalidateCallbacks = new HashMap();

    public PermissionInfoStorage() {
        this.initialDefault = new PermissionInfo[]{new PermissionInfo(DEFAULTPERM)};
        this.defaultPermissions = this.initialDefault;
        this.permDir = Util.getFileStorage("perms");
        if (this.permDir == null) {
            System.err.println("Property org.osgi.framework.dir not set,permission data will not be saved between sessions");
        } else {
            this.load();
        }
    }

    synchronized PermissionInfo[] get(String location, PermissionsWrapper callInvalidate) {
        Element res = (Element)this.permissions.get(location);
        if (res != null) {
            if (callInvalidate != null) {
                if (res.invalidateCallback == null) {
                    res.invalidateCallback = new ArrayList(2);
                }
                res.invalidateCallback.add(callInvalidate);
            }
            return res.pi;
        }
        return null;
    }

    synchronized PermissionInfo[] getDefault(PermissionsWrapper callInvalidate) {
        if (callInvalidate != null) {
            ArrayList<PermissionsWrapper> cil = (ArrayList<PermissionsWrapper>)this.defaultInvalidateCallbacks.get(callInvalidate.location);
            if (cil == null) {
                cil = new ArrayList<PermissionsWrapper>(2);
                this.defaultInvalidateCallbacks.put(callInvalidate.location, cil);
            }
            cil.add(callInvalidate);
        }
        return this.defaultPermissions;
    }

    synchronized String[] getKeys() {
        int size = this.permissions.size();
        if (size == 0) {
            return null;
        }
        String[] res = new String[size];
        int ix = 0;
        Iterator i = this.permissions.keySet().iterator();
        while (i.hasNext()) {
            res[ix++] = (String)i.next();
        }
        return res;
    }

    synchronized void put(String location, PermissionInfo[] perms) {
        ArrayList vpw;
        Element old = this.permissions.put(location, new Element(perms));
        this.save(location, perms);
        ArrayList arrayList = vpw = old != null ? old.invalidateCallback : (ArrayList)this.defaultInvalidateCallbacks.remove(location);
        if (vpw != null) {
            Iterator i = ((AbstractList)vpw).iterator();
            while (i.hasNext()) {
                ((PermissionsWrapper)i.next()).invalidate();
            }
        }
    }

    synchronized void putDefault(PermissionInfo[] permissions) {
        this.defaultPermissions = permissions != null ? permissions : this.initialDefault;
        this.save(null, this.defaultPermissions);
        Iterator i = this.defaultInvalidateCallbacks.values().iterator();
        while (i.hasNext()) {
            Iterator j = ((AbstractList)((ArrayList)i.next())).iterator();
            while (j.hasNext()) {
                ((PermissionsWrapper)j.next()).invalidate();
            }
        }
        this.defaultInvalidateCallbacks.clear();
    }

    synchronized void remove(String location) {
        Element old = (Element)this.permissions.remove(location);
        this.save(location, null);
        if (old != null && old.invalidateCallback != null) {
            Iterator i = ((AbstractList)old.invalidateCallback).iterator();
            while (i.hasNext()) {
                ((PermissionsWrapper)i.next()).invalidate();
            }
        }
    }

    synchronized void purgeCallback(PermissionCollection pc) {
        PermissionsWrapper pw = (PermissionsWrapper)pc;
        Element e = (Element)this.permissions.get(pw.location);
        if (e != null && e.invalidateCallback != null && ((AbstractCollection)e.invalidateCallback).remove(pw)) {
            if (e.invalidateCallback.isEmpty()) {
                e.invalidateCallback = null;
            }
        } else {
            ArrayList cil = (ArrayList)this.defaultInvalidateCallbacks.get(pw.location);
            if (cil != null && ((AbstractCollection)cil).remove(pw) && cil.isEmpty()) {
                this.defaultInvalidateCallbacks.remove(pw);
            }
        }
    }

    private void save(final String location, final PermissionInfo[] perms) {
        if (this.permDir != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String loc;
                    File f;
                    if (location != null) {
                        if (PermissionInfoStorage.this.lastPermFile % 20L == 0L) {
                            PermissionInfoStorage.this.purge();
                        }
                        f = new File(PermissionInfoStorage.this.permDir, Long.toString(++PermissionInfoStorage.this.lastPermFile));
                        loc = location;
                    } else {
                        f = new File(PermissionInfoStorage.this.permDir, "default");
                        loc = "defaultPermissions";
                    }
                    BufferedWriter out = null;
                    try {
                        int p;
                        out = new BufferedWriter(new FileWriter(f));
                        while ((p = loc.indexOf(10)) != -1) {
                            out.write(loc.substring(0, ++p) + " ");
                            loc = loc.substring(p);
                        }
                        out.write(loc + "\n\n");
                        if (perms != null) {
                            for (int i = 0; i < perms.length; ++i) {
                                out.write(perms[i].getEncoded() + "\n");
                            }
                        } else {
                            out.write("NULL\n");
                        }
                        out.write("\n");
                        out.close();
                    }
                    catch (IOException e) {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException ignore) {
                                // empty catch block
                            }
                            f.delete();
                        }
                        Debug.printStackTrace("NYI! Report error", e);
                    }
                    return null;
                }
            });
        }
    }

    private void load() {
        File[] files = PermUtil.getSortedFiles(this.permDir);
        for (int i = 0; i < files.length; ++i) {
            this.load(files[i]);
        }
        try {
            this.lastPermFile = Long.parseLong(files[files.length - 1].getName());
        }
        catch (Exception e) {
            this.lastPermFile = -1L;
        }
    }

    private void load(File fh) {
        BufferedReader in = null;
        boolean isDefault = "default".equals(fh.getName());
        try {
            in = new BufferedReader(new FileReader(fh));
            String loc = this.parseLocation(in);
            ArrayList<PermissionInfo> piv = new ArrayList<PermissionInfo>();
            int c = in.read();
            while (c != -1) {
                StringBuffer pe = new StringBuffer();
                while (c != -1 && c != 10) {
                    pe.append((char)c);
                    c = in.read();
                }
                String line = pe.toString();
                if ("NULL".equals(line)) {
                    if (isDefault) {
                        this.defaultPermissions = null;
                    } else {
                        this.permissions.remove(loc);
                    }
                    try {
                        in.close();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    return;
                }
                if ("".equals(line)) break;
                piv.add(new PermissionInfo(line));
                c = in.read();
            }
            if (c == -1) {
                throw new IOException("Premature EOF when parsing permission file: " + fh.getName());
            }
            if (in.read() != -1) {
                throw new IOException("Garbage at end of file when parsing permission file: " + fh.getName());
            }
            in.close();
            PermissionInfo[] pi = new PermissionInfo[piv.size()];
            piv.toArray(pi);
            if (isDefault) {
                this.defaultPermissions = pi;
            } else {
                this.permissions.put(loc, new Element(pi));
            }
        }
        catch (IOException e) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            Debug.printStackTrace("NYI! Report error", e);
        }
    }

    private String parseLocation(Reader in) throws IOException {
        char cc;
        int c;
        StringBuffer loc = new StringBuffer();
        while ((c = in.read()) != -1 && ((cc = (char)c) != '\n' || (c = in.read()) == 32)) {
            loc.append(cc);
        }
        return loc.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void purge() {
        foundTwo = new HashMap<String, Boolean>();
        files = PermUtil.getSortedFiles(this.permDir);
        for (i = files.length - 1; i >= 0; --i) {
            block13: {
                in = null;
                try {
                    in = new BufferedReader(new FileReader(files[i]));
                    loc = this.parseLocation(in);
                    var8_8 = null;
                    ** if (in == null) goto lbl-1000
                }
                catch (Throwable var7_10) {
                    var8_8 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ignore) {
                            // empty catch block
                        }
                    }
                    throw var7_10;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        in.close();
                    }
                    catch (IOException ignore) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block13;
                    catch (IOException ignore) {
                        files[i].delete();
                        var8_8 = null;
                        if (in == null) continue;
                        try {
                            in.close();
                        }
                        catch (IOException ignore) {}
                        continue;
                    }
                }
            }
            if ((v = (Boolean)foundTwo.get(loc)) != null) {
                if (v.booleanValue()) {
                    files[i].delete();
                    continue;
                }
                foundTwo.put(loc, new Boolean(true));
                continue;
            }
            foundTwo.put(loc, new Boolean(false));
        }
    }

    class Element {
        PermissionInfo[] pi;
        ArrayList invalidateCallback = null;

        Element(PermissionInfo[] pi) {
            this.pi = pi;
        }
    }
}

