/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.util.List;
import org.knopflerfish.framework.permissions.ConditionalPermissionSecurityManager;
import org.knopflerfish.framework.permissions.Debug;
import org.knopflerfish.framework.permissions.PostponementCheck;

public class KFSecurityManager
extends SecurityManager
implements ConditionalPermissionSecurityManager {
    private final ThreadLocal postponementCheck = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPermission(Permission perm, Object context) {
        if (!(context instanceof AccessControlContext)) {
            throw new SecurityException("context not an AccessControlContext");
        }
        PostponementCheck old = (PostponementCheck)this.postponementCheck.get();
        PostponementCheck pc = new PostponementCheck((AccessControlContext)context, perm, old);
        this.postponementCheck.set(pc);
        try {
            AccessController.doPrivileged(pc);
        }
        finally {
            this.postponementCheck.set(old);
        }
    }

    public void checkPermission(Permission perm) {
        this.checkPermission(perm, this.getSecurityContext());
    }

    public void savePostponement(List postponement) {
        PostponementCheck pc = (PostponementCheck)this.postponementCheck.get();
        if (pc == null) {
            Debug.printStackTrace("TBD! Should not happen!? How did we get here", new Throwable());
        }
        pc.savePostponement(postponement);
    }
}

