/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.knopflerfish.framework.Framework;
import org.osgi.framework.BundleException;

public class Debug {
    static final boolean tck401compat = new Boolean(Framework.getProperty("org.knopflerfish.framework.tck401compat", "false"));
    static final boolean permissions = new Boolean(Framework.getProperty("org.knopflerfish.framework.debug.permissions", "false"));
    static final boolean certificates = new Boolean(Framework.getProperty("org.knopflerfish.framework.debug.certificates", "false"));
    private static ThreadLocal insideDebug = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new Boolean(false);
        }
    };

    private static void inside(boolean b) {
        insideDebug.set(new Boolean(b));
    }

    private static boolean isInside() {
        return (Boolean)insideDebug.get();
    }

    private static void println0(String str) {
        System.out.println("## DEBUG: " + str);
    }

    static void println(final String str) {
        if (!Debug.isInside()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Debug.inside(true);
                    Debug.println0(str);
                    Debug.inside(false);
                    return null;
                }
            });
        }
    }

    private static void printStackTrace0(String str, Throwable t) {
        Throwable n;
        System.out.println("## DEBUG: " + str);
        t.printStackTrace();
        if (t instanceof BundleException && (n = ((BundleException)t).getNestedException()) != null) {
            System.out.println("Nested bundle exception:");
            n.printStackTrace();
        }
    }

    static void printStackTrace(final String str, final Throwable t) {
        if (!Debug.isInside()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Debug.inside(true);
                    Debug.printStackTrace0(str, t);
                    Debug.inside(false);
                    return null;
                }
            });
        }
    }
}

