/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.knopflerfish.framework.Util;
import org.knopflerfish.framework.permissions.ConditionalPermissionInfoImpl;
import org.knopflerfish.framework.permissions.Debug;
import org.knopflerfish.framework.permissions.PermUtil;
import org.knopflerfish.framework.permissions.PermissionsHandle;
import org.knopflerfish.framework.permissions.PermissionsWrapper;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.permissionadmin.PermissionInfo;

class ConditionalPermissionInfoStorage {
    private File condPermDir;
    private long lastFile;
    private HashMap cpiMap = new HashMap();
    private long unique_id = 0L;
    private PermissionsHandle ph;

    ConditionalPermissionInfoStorage(PermissionsHandle ph) {
        this.ph = ph;
        this.condPermDir = Util.getFileStorage("condperm");
        if (this.condPermDir == null) {
            System.err.println("Property org.osgi.framework.dir not set,conditional permission info will not be saved between sessions");
        } else {
            this.load();
        }
    }

    synchronized ConditionalPermissionInfo get(String name) {
        return (ConditionalPermissionInfo)this.cpiMap.get(name);
    }

    synchronized Enumeration getAll() {
        return new Vector(this.cpiMap.values()).elements();
    }

    synchronized ConditionalPermissionInfo put(String name, ConditionInfo[] conds, PermissionInfo[] perms) {
        if (name == null) {
            name = this.uniqueName();
        } else if (name.equals("")) {
            throw new IllegalArgumentException("Name can not be an empty string");
        }
        ConditionalPermissionInfoImpl res = new ConditionalPermissionInfoImpl(this, name, conds, perms);
        ConditionalPermissionInfoImpl old = this.cpiMap.put(name, res);
        this.save(name, res);
        if (Debug.permissions) {
            Debug.println("CondPermStorage set " + res);
            if (old != null) {
                Debug.println("CondPermStorage replaced " + old);
            }
        }
        this.updateChangedConditionalPermission(res, old);
        return res;
    }

    synchronized void remove(String name) {
        ConditionalPermissionInfoImpl old = (ConditionalPermissionInfoImpl)this.cpiMap.remove(name);
        if (old != null) {
            this.save(name, null);
            if (Debug.permissions) {
                Debug.println("CondPermStorage removed " + old);
            }
            this.updateChangedConditionalPermission(null, old);
        }
    }

    synchronized int size() {
        return this.cpiMap.size();
    }

    private String uniqueName() {
        String res;
        while (this.cpiMap.containsKey(res = "ucpi" + Long.toString(this.unique_id++))) {
        }
        return res;
    }

    private void updateChangedConditionalPermission(ConditionalPermissionInfoImpl cpi, ConditionalPermissionInfoImpl old) {
        Iterator i = this.ph.getPermissionWrappers();
        while (i.hasNext()) {
            ((PermissionsWrapper)i.next()).updateChangedConditionalPermission(cpi, old);
        }
    }

    private void save(final String name, final ConditionalPermissionInfo cpi) {
        if (this.condPermDir != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (ConditionalPermissionInfoStorage.this.lastFile % 20L == 0L) {
                        ConditionalPermissionInfoStorage.this.purge();
                    }
                    File f = new File(ConditionalPermissionInfoStorage.this.condPermDir, Long.toString(++ConditionalPermissionInfoStorage.this.lastFile));
                    StringBuffer buf = new StringBuffer();
                    if (cpi != null) {
                        buf.append(cpi.toString());
                    } else {
                        buf.append('!');
                        PermUtil.quote(name, buf);
                    }
                    buf.append('\n');
                    BufferedWriter out = null;
                    try {
                        out = new BufferedWriter(new FileWriter(f));
                        out.write(buf.toString());
                        out.close();
                    }
                    catch (IOException e) {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException ignore) {
                                // empty catch block
                            }
                            f.delete();
                        }
                        Debug.printStackTrace("NYI! Report error", e);
                    }
                    return null;
                }
            });
        }
    }

    private void load() {
        File[] files = PermUtil.getSortedFiles(this.condPermDir);
        for (int i = 0; i < files.length; ++i) {
            this.load(files[i]);
        }
        try {
            this.lastFile = Long.parseLong(files[files.length - 1].getName());
        }
        catch (Exception e) {
            this.lastFile = -1L;
        }
    }

    private void load(File fh) {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(fh));
            String l = in.readLine();
            while (l != null) {
                if (!(l = l.trim()).equals("") && !l.startsWith("#")) {
                    if (l.startsWith("!")) {
                        StringBuffer buf = new StringBuffer();
                        PermUtil.unquote(l.toCharArray(), 1, buf);
                        this.cpiMap.remove(buf.toString());
                    } else {
                        ConditionalPermissionInfoImpl res = new ConditionalPermissionInfoImpl(this, l);
                        this.cpiMap.put(res.getName(), res);
                    }
                }
                l = in.readLine();
            }
            in.close();
        }
        catch (Exception e) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            Debug.printStackTrace("NYI! Report error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void purge() {
        found = new HashSet<String>();
        files = PermUtil.getSortedFiles(this.condPermDir);
        remove = new ArrayList<File>();
        buf = new StringBuffer();
        empty = false;
        for (i = files.length - 1; i >= 0; --i) {
            block16: {
                in = null;
                try {
                    try {
                        in = new BufferedReader(new FileReader(files[i]));
                        l = in.readLine();
                        while (l != null) {
                            if (!(l = l.trim()).equals("") && !l.startsWith("#")) {
                                empty = l.startsWith("!");
                                PermUtil.unquote(l.toCharArray(), empty != false ? 1 : 0, buf);
                                break;
                            }
                            l = in.readLine();
                        }
                        var10_11 = null;
                        if (in == null) break block16;
                    }
                    catch (IOException ignore) {
                        files[i].delete();
                        var10_11 = null;
                        if (in == null) continue;
                        try {
                            in.close();
                        }
                        catch (IOException ignore) {}
                        continue;
                    }
                }
                catch (Throwable var9_13) {
                    var10_11 = null;
                    if (in == null) throw var9_13;
                    ** try [egrp 2[TRYBLOCK] [4 : 192->200)] { 
lbl39:
                    // 1 sources

                    in.close();
                    throw var9_13;
lbl41:
                    // 1 sources

                    catch (IOException ignore) {
                        // empty catch block
                    }
                    throw var9_13;
                }
                try {}
                catch (IOException ignore) {}
                in.close();
            }
            if (buf.length() <= 0) continue;
            if (found.add(buf.toString())) {
                if (empty) {
                    remove.add(files[i]);
                }
            } else if (!files[i].delete()) {
                remove.remove(files[i]);
            }
            buf.setLength(0);
        }
        i = remove.iterator();
        while (i.hasNext() != false) {
            ((File)i.next()).delete();
        }
    }
}

