/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.PermissionCollection;
import java.util.ArrayList;
import org.knopflerfish.framework.permissions.CertificateUtil;
import org.knopflerfish.framework.permissions.ConditionalPermission;
import org.knopflerfish.framework.permissions.ConditionalPermissionInfoStorage;
import org.knopflerfish.framework.permissions.Debug;
import org.knopflerfish.framework.permissions.PermUtil;
import org.osgi.framework.Bundle;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.permissionadmin.PermissionInfo;

public class ConditionalPermissionInfoImpl
implements ConditionalPermissionInfo {
    private static final String SIGNER_CONDITION_TYPE = "org.osgi.service.condpermadmin.BundleSignerCondition";
    private final ConditionalPermissionInfoStorage cps;
    private final String name;
    private final ConditionInfo[] conditionInfos;
    private final PermissionInfo[] permissionInfos;
    private PermissionCollection permissions;
    static final Class[] argClasses = new Class[]{class$org$osgi$framework$Bundle == null ? (class$org$osgi$framework$Bundle = ConditionalPermissionInfoImpl.class$("org.osgi.framework.Bundle")) : class$org$osgi$framework$Bundle, class$org$osgi$service$condpermadmin$ConditionInfo == null ? (class$org$osgi$service$condpermadmin$ConditionInfo = ConditionalPermissionInfoImpl.class$("org.osgi.service.condpermadmin.ConditionInfo")) : class$org$osgi$service$condpermadmin$ConditionInfo};
    static /* synthetic */ Class class$org$osgi$framework$Bundle;
    static /* synthetic */ Class class$org$osgi$service$condpermadmin$ConditionInfo;

    ConditionalPermissionInfoImpl(ConditionalPermissionInfoStorage cps, String name, ConditionInfo[] conds, PermissionInfo[] perms) {
        this.cps = cps;
        this.name = name;
        this.conditionInfos = conds;
        this.permissionInfos = perms;
        this.permissions = null;
    }

    /*
     * WARNING - void declaration
     */
    ConditionalPermissionInfoImpl(ConditionalPermissionInfoStorage cps, String encoded) {
        this.cps = cps;
        char[] eca = encoded.toCharArray();
        StringBuffer buf = new StringBuffer();
        int pos = PermUtil.skipWhite(eca, 0);
        pos = PermUtil.unquote(eca, pos, buf);
        this.name = buf.toString();
        ArrayList<ConditionInfo> cal = new ArrayList<ConditionInfo>();
        ArrayList<PermissionInfo> pal = new ArrayList<PermissionInfo>();
        pos = PermUtil.skipWhite(eca, pos);
        if (eca[pos++] != '{') {
            throw new IllegalArgumentException("Missing open brace");
        }
        while (true) {
            void var9_9;
            int ec;
            char c;
            if ((c = eca[pos = PermUtil.skipWhite(eca, pos)]) == '[') {
                ec = 93;
            } else if (c == '(') {
                ec = 41;
            } else {
                if (c == '}') break;
                throw new IllegalArgumentException("Unexpected char '" + c + "' at pos " + pos);
            }
            int start_pos = pos++;
            do {
                if ((c = eca[pos]) == '\"') {
                    pos = PermUtil.unquote(eca, pos, null);
                    continue;
                }
                ++pos;
            } while (c != var9_9);
            String info = new String(eca, start_pos, pos - start_pos);
            if (c == ']') {
                cal.add(new ConditionInfo(info));
                continue;
            }
            pal.add(new PermissionInfo(info));
        }
        this.conditionInfos = cal.toArray(new ConditionInfo[cal.size()]);
        this.permissionInfos = pal.toArray(new PermissionInfo[pal.size()]);
    }

    public ConditionInfo[] getConditionInfos() {
        return this.conditionInfos;
    }

    public PermissionInfo[] getPermissionInfos() {
        return this.permissionInfos;
    }

    public void delete() {
        this.cps.remove(this.name);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        int i;
        StringBuffer res = PermUtil.quote(this.name, null);
        res.append(" { ");
        if (this.conditionInfos != null) {
            for (i = 0; i < this.conditionInfos.length; ++i) {
                res.append(this.conditionInfos[i].getEncoded());
                res.append(' ');
            }
        }
        if (this.permissionInfos != null) {
            for (i = 0; i < this.permissionInfos.length; ++i) {
                res.append(this.permissionInfos[i].getEncoded());
                res.append(' ');
            }
        }
        res.append('}');
        return res.toString();
    }

    /*
     * WARNING - void declaration
     */
    ConditionalPermission getConditionalPermission(Bundle bundle) {
        String me = "ConditionalPermissionInfoImpl.getConditionalPermission: ";
        ArrayList<void> conds = new ArrayList<void>(this.conditionInfos.length);
        for (int i = 0; i < this.conditionInfos.length; ++i) {
            try {
                void var6_6;
                Condition c;
                Class<?> clazz = Class.forName(this.conditionInfos[i].getType());
                Constructor<?> cons = null;
                Method method = null;
                try {
                    method = clazz.getMethod("getCondition", argClasses);
                    if ((method.getModifiers() & 8) == 0) {
                        method = null;
                    }
                }
                catch (NoSuchMethodException ignore) {
                    // empty catch block
                }
                if (method != null) {
                    if (Debug.permissions) {
                        Debug.println(me + "Invoke, " + method + " for bundle " + bundle);
                    }
                    c = (Condition)method.invoke(null, bundle, this.conditionInfos[i]);
                } else {
                    try {
                        cons = clazz.getConstructor(argClasses);
                    }
                    catch (NoSuchMethodException ignore) {
                        // empty catch block
                    }
                    if (cons != null) {
                        if (Debug.permissions) {
                            Debug.println(me + "Construct, " + cons + " for bundle " + bundle);
                        }
                        c = (Condition)cons.newInstance(bundle, this.conditionInfos[i]);
                    } else {
                        Debug.println("NYI! Log faulty ConditionInfo object!?");
                        continue;
                    }
                }
                if (!(var6_6.isMutable() || var6_6.isPostponed() && !Debug.tck401compat)) {
                    if (var6_6.isSatisfied()) {
                        if (!Debug.permissions) continue;
                        Debug.println(me + "Immutable condition ok, continue");
                        continue;
                    }
                    if (Debug.permissions) {
                        Debug.println(me + "Immutable condition NOT ok, abort");
                    }
                    return null;
                }
                conds.add(var6_6);
                continue;
            }
            catch (Throwable t) {
                Debug.printStackTrace("NYI! Log failed Condition creation", t);
                return null;
            }
        }
        return new ConditionalPermission(conds.toArray(new Condition[conds.size()]), this.getPermissions(), this);
    }

    PermissionCollection getPermissions() {
        if (this.permissions == null) {
            this.permissions = PermUtil.makePermissionCollection(this.permissionInfos, null);
        }
        return this.permissions;
    }

    boolean hasSigners(String[] signers) {
        for (int i = 0; i < this.conditionInfos.length; ++i) {
            if (SIGNER_CONDITION_TYPE.equals(this.conditionInfos[i].getType())) {
                String[] args = this.conditionInfos[i].getArgs();
                if (args.length == 1 && CertificateUtil.matchSigners(signers, args[0]) >= 0) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

