/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.knopflerfish.framework.permissions.ConditionalPermissionInfoImpl;
import org.osgi.service.condpermadmin.Condition;

public class ConditionalPermission {
    private ConditionalPermissionInfoImpl parent;
    private Condition[] conditions;
    private final PermissionCollection permissions;
    private List postponed = null;

    ConditionalPermission(Condition[] conds, PermissionCollection perms, ConditionalPermissionInfoImpl cpi) {
        this.parent = cpi;
        this.conditions = conds;
        this.permissions = perms;
    }

    boolean checkImmediateOk(Permission perm, boolean checkPostponed) {
        if (this.conditions == null) {
            return false;
        }
        this.postponed = new ArrayList(1);
        for (int i = 0; i < this.conditions.length; ++i) {
            Condition c = this.conditions[i];
            if (c == null) continue;
            if (checkPostponed || !c.isPostponed()) {
                boolean mutable = c.isMutable();
                if (c.isSatisfied()) {
                    if (mutable) continue;
                    this.conditions[i] = null;
                    continue;
                }
                if (!mutable) {
                    this.conditions = null;
                }
                return false;
            }
            this.postponed.add(c);
        }
        return this.permissions.implies(perm);
    }

    boolean hasPostponed() {
        return !this.postponed.isEmpty();
    }

    Iterator getPostponed() {
        return this.postponed.iterator();
    }

    void setImmutable(Condition c, boolean result) {
        if (this.conditions == null) {
            return;
        }
        if (result) {
            for (int i = 0; i < this.conditions.length; ++i) {
                if (c != this.conditions[i]) continue;
                this.conditions[i] = null;
                break;
            }
        } else {
            this.conditions = null;
        }
    }

    boolean isParent(ConditionalPermissionInfoImpl cpi) {
        return cpi == this.parent;
    }

    public String toString() {
        return "HASH: " + this.hashCode() + " INFO: " + this.parent.toString();
    }
}

