/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;
import org.knopflerfish.framework.permissions.Debug;
import org.knopflerfish.framework.permissions.RDN;

public class CertificateUtil {
    public static int matchCertificates(Certificate[] certs, String pattern) throws IllegalArgumentException {
        if (certs != null) {
            if (Debug.certificates) {
                Debug.println("MatchCertificates: " + certs.length + " number of certs with " + pattern);
            }
            ArrayList pat = CertificateUtil.parseDNs(pattern);
            StringBuffer chain = new StringBuffer();
            X500Principal issuer = null;
            for (int i = 0; i < certs.length; ++i) {
                if (certs[i] instanceof X509Certificate) {
                    X509Certificate c = (X509Certificate)certs[i];
                    X500Principal subject = c.getSubjectX500Principal();
                    X500Principal prev_issuer = issuer;
                    issuer = c.getIssuerX500Principal();
                    if (Debug.certificates) {
                        Debug.println("SUBJECT " + i + ": " + subject.getName("CANONICAL"));
                        Debug.println("ISSUER " + i + ": " + issuer.getName("CANONICAL"));
                    }
                    if (prev_issuer != null && !prev_issuer.equals(subject)) {
                        throw new IllegalArgumentException("Certificate chain not correctly chained");
                    }
                    chain.append(subject.getName("CANONICAL"));
                    if (subject.equals(issuer)) {
                        ArrayList dn = CertificateUtil.parseDNs(chain.toString());
                        if (CertificateUtil.matchDNs(dn, 0, pat, 0)) {
                            if (Debug.certificates) {
                                Debug.println("MatchCertificates matched on: " + i);
                            }
                            return i;
                        }
                        if (Debug.certificates) {
                            Debug.println("MatchCertificates failed on: " + i);
                        }
                        chain.setLength(0);
                        issuer = null;
                        continue;
                    }
                    chain.append(" ; ");
                    continue;
                }
                throw new IllegalArgumentException("Unknown Certificate type");
            }
            if (chain.length() > 0) {
                throw new IllegalArgumentException("Incomplete certificate chain");
            }
        }
        return -1;
    }

    public static int matchSigners(String[] signers, String pattern) {
        if (Debug.certificates) {
            Debug.println("MatchSigners: " + signers.length + " number of certs with " + pattern);
        }
        ArrayList pat = CertificateUtil.parseDNs(pattern);
        for (int i = 0; i < signers.length; ++i) {
            if (signers[i] == null) continue;
            ArrayList dn = CertificateUtil.parseDNs(signers[i]);
            if (Debug.certificates) {
                Debug.println("SUBJECT " + i + ": " + signers[0]);
            }
            if (!CertificateUtil.matchDNs(dn, 0, pat, 0)) continue;
            return i;
        }
        return -1;
    }

    private static ArrayList parseDN(String dn) {
        ArrayList<Object> res = new ArrayList<Object>();
        int len = (dn = dn.trim()).length();
        if (len == 0) {
            return null;
        }
        if (dn.equals("-")) {
            res.add(dn);
            return res;
        }
        if (dn.charAt(0) == '*') {
            res.add("*");
            if (len == 1) {
                return res;
            }
            int pos = 1;
            while (dn.charAt(pos) == ' ') {
                ++pos;
            }
            if (dn.charAt(pos) == ',') {
                dn = dn.substring(pos + 1);
            } else {
                throw new IllegalArgumentException("wildcard has trailing characters: " + dn);
            }
        }
        dn = new X500Principal(dn).getName("CANONICAL");
        len = dn.length();
        for (int end = 0; end < len; ++end) {
            boolean quit = false;
            boolean multi_rdn = false;
            int start = end;
            block7: while (!quit && end < len) {
                switch (dn.charAt(end)) {
                    case '+': {
                        multi_rdn = true;
                    }
                    case ',': {
                        quit = true;
                        continue block7;
                    }
                    case '\\': {
                        end += 2;
                        continue block7;
                    }
                }
                ++end;
            }
            res.add(new RDN(dn, start, end, multi_rdn));
        }
        return res;
    }

    private static ArrayList parseDNs(String dns) {
        int end;
        ArrayList<ArrayList> res = new ArrayList<ArrayList>();
        int start = 0;
        int len = dns.length();
        boolean quote = false;
        block5: for (end = 0; end < len; ++end) {
            switch (dns.charAt(end)) {
                case '\"': {
                    quote = !quote;
                    continue block5;
                }
                case '\\': {
                    if (++end != len) continue block5;
                    throw new IllegalArgumentException("Escape character at end of string");
                }
                case ';': {
                    if (quote) continue block5;
                    res.add(CertificateUtil.parseDN(dns.substring(start, end)));
                    start = end + 1;
                }
            }
        }
        if (quote) {
            throw new IllegalArgumentException("Unterminated quote at end of string");
        }
        if (start < end) {
            res.add(CertificateUtil.parseDN(dns.substring(start, end)));
        }
        return res;
    }

    private static int wildcardDN(ArrayList dn) {
        Object o;
        if (dn.size() == 1 && (o = dn.get(0)) instanceof String) {
            if ("-".equals(o)) {
                return Integer.MAX_VALUE;
            }
            if ("*".equals(o)) {
                return 1;
            }
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean matchDN(ArrayList dn, ArrayList pattern) {
        void var4_4;
        boolean p_base;
        int d_end = dn.size() - 1;
        int p_end = pattern.size() - 1;
        if (pattern.get(0) instanceof String) {
            if (d_end < p_end - 1) {
                return false;
            }
            p_base = true;
        } else if (d_end == p_end) {
            p_base = false;
        } else {
            return false;
        }
        while (p_end >= var4_4) {
            Object d;
            Object p = pattern.get(p_end--);
            if (((RDN)(d = dn.get(d_end--))).match((RDN)p)) continue;
            return false;
        }
        return d_end < 0 || !((RDN)dn.get((int)d_end)).multi;
    }

    private static boolean matchDNs(ArrayList dns, int dns_ix, ArrayList patterns, int patterns_ix) {
        if (patterns_ix == patterns.size()) {
            return true;
        }
        if (dns_ix == dns.size()) {
            return false;
        }
        ArrayList pat = (ArrayList)patterns.get(patterns_ix);
        int x = CertificateUtil.wildcardDN(pat);
        if (x > 0) {
            for (int i = 0; i <= x; ++i) {
                if (!CertificateUtil.matchDNs(dns, dns_ix + i, patterns, patterns_ix + 1)) continue;
                return true;
            }
            return false;
        }
        if (!CertificateUtil.matchDN((ArrayList)dns.get(dns_ix), pat)) {
            return false;
        }
        return CertificateUtil.matchDNs(dns, dns_ix + 1, patterns, patterns_ix + 1);
    }
}

