/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.bundlestorage.memory;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.FileArchive;
import org.knopflerfish.framework.Framework;
import org.knopflerfish.framework.HeaderDictionary;
import org.knopflerfish.framework.bundlestorage.memory.Archive;
import org.knopflerfish.framework.bundlestorage.memory.BundleStorageImpl;

class BundleArchiveImpl
implements BundleArchive {
    private static final boolean fileReference = new Boolean(Framework.getProperty("org.knopflerfish.framework.bundlestorage.file.reference", "false"));
    private FileArchive archive;
    private long id;
    private String location;
    private boolean startOnLaunch;
    private BundleStorageImpl storage;
    private FileArchive[] archives;
    private int startLevel = -1;
    private boolean bPersistent = false;
    private long lastModified;
    private ArrayList failedPath = null;

    BundleArchiveImpl(BundleStorageImpl bundleStorage, InputStream is, String bundleLocation, long bundleId) throws Exception {
        this(bundleStorage, is, bundleLocation, false, bundleId);
    }

    private BundleArchiveImpl(BundleStorageImpl bundleStorage, InputStream is, String bundleLocation, boolean bundleStartOnLaunch, long bundleId) throws Exception {
        URL source = new URL(bundleLocation);
        this.archive = this.isReference(source) ? new org.knopflerfish.framework.bundlestorage.file.Archive(null, 0, is, source, bundleLocation, false) : new Archive(is);
        this.storage = bundleStorage;
        this.id = bundleId;
        this.location = bundleLocation;
        this.startOnLaunch = bundleStartOnLaunch;
        this.setClassPath();
    }

    BundleArchiveImpl(BundleArchiveImpl old, InputStream is) throws Exception {
        this.location = old.location;
        this.storage = old.storage;
        this.id = old.id;
        this.startOnLaunch = old.startOnLaunch;
        this.bPersistent = old.bPersistent;
        this.archive = new Archive(is);
        this.setClassPath();
    }

    public String getAttribute(String key) {
        return this.archive.getAttribute(key);
    }

    public Hashtable getLocalizationEntries(String localeFile) {
        InputStream is = this.archive.getInputStream(localeFile);
        if (is != null) {
            Properties l = new Properties();
            try {
                l.load(is);
            }
            catch (IOException _ignore) {
                // empty catch block
            }
            try {
                is.close();
            }
            catch (IOException _ignore) {
                // empty catch block
            }
            return l;
        }
        return null;
    }

    public HeaderDictionary getUnlocalizedAttributes() {
        return new HeaderDictionary(this.archive.getManifest().getMainAttributes());
    }

    public long getBundleId() {
        return this.id;
    }

    public String getBundleLocation() {
        return this.location;
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public void setStartLevel(int level) {
        this.startLevel = level;
    }

    public void setPersistent(boolean b) {
        this.bPersistent = b;
    }

    public boolean isPersistent() {
        return this.bPersistent;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long timemillisecs) throws IOException {
        this.lastModified = timemillisecs;
    }

    public byte[] getClassBytes(Integer sub, String path) throws IOException {
        return this.archives[sub].getClassBytes(path);
    }

    public Vector componentExists(String component, boolean onlyFirst) {
        Vector<Integer> v = null;
        if (component.startsWith("/")) {
            component = component.substring(1);
        }
        if (0 == component.length()) {
            v = new Vector<Integer>();
            for (int i = 0; i < this.archives.length; ++i) {
                v.addElement(new Integer(i));
                if (!onlyFirst) {
                    continue;
                }
                break;
            }
        } else {
            for (int i = 0; i < this.archives.length; ++i) {
                InputStream is = this.archives[i].getInputStream(component);
                if (is == null) continue;
                if (v == null) {
                    v = new Vector();
                }
                v.addElement(new Integer(i));
                try {
                    is.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                if (!onlyFirst) {
                    continue;
                }
                break;
            }
        }
        return v;
    }

    public InputStream getInputStream(String component, int ix) {
        if (component.startsWith("/")) {
            component = component.substring(1);
        }
        if (ix == -1) {
            return this.archive.getInputStream(component);
        }
        return this.archives[ix].getInputStream(component);
    }

    public String getNativeLibrary(String libName) {
        return null;
    }

    public boolean getStartOnLaunchFlag() {
        return this.startOnLaunch;
    }

    public void setStartOnLaunchFlag(boolean value) throws IOException {
        if (this.startOnLaunch != value) {
            this.startOnLaunch = value;
        }
    }

    public void purge() {
        this.storage.removeArchive(this);
    }

    public void close() {
    }

    public List getFailedClassPathEntries() {
        return this.failedPath;
    }

    private boolean isFile(URL source) {
        return source != null && "file".equals(source.getProtocol());
    }

    private boolean isReference(URL source) {
        return source != null && ("reference".equals(source.getProtocol()) || fileReference && this.isFile(source));
    }

    private void setClassPath() throws IOException {
        String bcp = this.getAttribute("Bundle-ClassPath");
        if (bcp != null) {
            ArrayList<FileArchive> a = new ArrayList<FileArchive>();
            StringTokenizer st = new StringTokenizer(bcp, ",");
            while (st.hasMoreTokens()) {
                String path = st.nextToken().trim();
                if (".".equals(path)) {
                    a.add(this.archive);
                    continue;
                }
                try {
                    FileArchive subArchive = this.archive.getSubArchive(path);
                    if (subArchive == this.archive) continue;
                    a.add(subArchive);
                }
                catch (IOException ioe) {
                    if (this.failedPath == null) {
                        this.failedPath = new ArrayList(1);
                    }
                    this.failedPath.add(path);
                }
            }
            this.archives = a.toArray(new FileArchive[a.size()]);
        } else {
            this.archives = new FileArchive[]{this.archive};
        }
    }

    public Enumeration findResourcesPath(String path) {
        return this.archive.findResourcesPath(path);
    }

    public String getJarLocation() {
        return null;
    }

    public Certificate[] getCertificates() {
        return null;
    }

    public void invalidateCertificates() {
    }
}

