/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.bundlestorage.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.knopflerfish.framework.AutoManifest;
import org.knopflerfish.framework.FileArchive;
import org.knopflerfish.framework.FileTree;
import org.knopflerfish.framework.Framework;
import org.knopflerfish.framework.Util;
import org.osgi.framework.BundleException;

public class Archive
implements FileArchive {
    private static final String ARCHIVE = "jar";
    private static final String SUBDIR = "sub";
    private static final String CERTS_SUFFIX = ".crt";
    private static final String META_INF_DIR = "META-INF/";
    private static final String OSGI_OPT_DIR = "OSGI-OPT/";
    private static final String PROP_BASE = "org.knopflerfish.framework.bundlestorage.file.";
    private static final boolean unpack = new Boolean(Framework.getProperty("org.knopflerfish.framework.bundlestorage.file.unpack", "true"));
    private static final boolean alwaysUnpack = new Boolean(Framework.getProperty("org.knopflerfish.framework.bundlestorage.file.always_unpack", "false"));
    private static final boolean fileReference = new Boolean(Framework.getProperty("org.knopflerfish.framework.bundlestorage.file.reference", "false"));
    private static final boolean trustedStorage = new Boolean(Framework.getProperty("org.knopflerfish.framework.bundlestorage.file.trusted", "true"));
    private FileTree file;
    private boolean fileIsReference;
    private ZipFile jar;
    private final String location;
    private Certificate[] certs = null;
    Manifest manifest;
    private ZipEntry subJar;
    private boolean bClosed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Archive(File dir, int rev, InputStream is, URL source, String location, boolean checkSigned) throws IOException, BundleException {
        FileTree sourceFile;
        this.location = location;
        boolean isDirectory = false;
        this.fileIsReference = this.isReference(source);
        if (this.fileIsReference || this.isFile(source)) {
            sourceFile = new FileTree(this.getFile(source));
            isDirectory = sourceFile.isDirectory();
            if (isDirectory) {
                File mfd = new File(sourceFile.getAbsolutePath(), META_INF_DIR);
                File mf = new File(mfd, "MANIFEST.MF");
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(mf));
                try {
                    this.manifest = new Manifest(bis);
                }
                finally {
                    bis.close();
                }
            }
        } else {
            sourceFile = null;
        }
        BufferedInputStream bis = null;
        JarInputStream ji = null;
        if (this.manifest == null && dir != null) {
            bis = new BufferedInputStream(is);
            if (alwaysUnpack) {
                ji = new JarInputStream((InputStream)bis, checkSigned);
                this.manifest = ji.getManifest();
            } else if (unpack) {
                bis.mark(1000000);
                ji = new JarInputStream((InputStream)bis, checkSigned);
                this.manifest = ji.getManifest();
                if (this.manifest == null || !this.needUnpack(this.manifest.getMainAttributes())) {
                    ji = null;
                    bis.reset();
                }
            }
            if (ji != null) {
                this.file = new FileTree(dir, ARCHIVE + rev);
                this.file.mkdirs();
                if (this.manifest == null) {
                    if (checkSigned) {
                        throw new IOException("MANIFEST.MF must be first in archive when using signatures.");
                    }
                } else {
                    File f = new File(this.file, META_INF_DIR);
                    f.mkdir();
                    FileOutputStream fo = new FileOutputStream(new File(f, "MANIFEST.MF"));
                    BufferedOutputStream o = new BufferedOutputStream(fo);
                    try {
                        this.manifest.write(o);
                    }
                    finally {
                        o.close();
                    }
                }
                boolean verify = checkSigned;
                int verifiedEntries = 0;
                while (this.processNextJarEntry(ji, verify, this.file)) {
                    if (!verify) continue;
                    if (this.isArchiveSigned()) {
                        ++verifiedEntries;
                        continue;
                    }
                    verify = false;
                }
                if (verify) {
                    this.checkCertificates(verifiedEntries, true);
                }
                this.jar = null;
            }
        }
        if (ji == null) {
            if (isDirectory) {
                if (!this.fileIsReference && dir != null) {
                    this.file = new FileTree(dir, ARCHIVE + rev);
                    sourceFile.copyTo(this.file);
                } else {
                    this.file = sourceFile;
                }
                if (checkSigned) {
                    // empty if block
                }
                this.jar = null;
            } else {
                if (!this.fileIsReference && dir != null) {
                    this.file = new FileTree(dir, ARCHIVE + rev);
                    this.loadFile(this.file, bis);
                } else {
                    this.file = sourceFile;
                }
                if (checkSigned) {
                    this.processSignedJar(this.file);
                }
                this.jar = new ZipFile(this.file);
            }
        }
        this.manifest = this.manifest != null ? new AutoManifest(this.manifest, location) : this.getAutoManifest();
        this.checkManifest();
        this.handleAutoManifest();
        this.saveCertificates();
    }

    String getFile(URL source) {
        String file = source.getFile();
        if (file.startsWith("file:")) {
            return file.substring(5);
        }
        return file;
    }

    boolean isFile(URL source) {
        return source != null && "file".equals(source.getProtocol());
    }

    boolean isReference(URL source) {
        return source != null && ("reference".equals(source.getProtocol()) || fileReference && this.isFile(source));
    }

    Archive(File dir, int rev, String location, boolean checkSigned) throws IOException {
        int i;
        this.location = location;
        String[] f = dir.list();
        this.file = null;
        if (rev != -1) {
            this.file = new FileTree(dir, ARCHIVE + rev);
        } else {
            rev = Integer.MAX_VALUE;
            for (i = 0; i < f.length; ++i) {
                if (!f[i].startsWith(ARCHIVE)) continue;
                try {
                    int c = Integer.parseInt(f[i].substring(ARCHIVE.length()));
                    if (c >= rev) continue;
                    rev = c;
                    this.file = new FileTree(dir, f[i]);
                    continue;
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
        }
        for (i = 0; i < f.length; ++i) {
            if (f[i].startsWith(ARCHIVE)) {
                try {
                    int c = Integer.parseInt(f[i].substring(ARCHIVE.length()));
                    if (c != rev) {
                        new FileTree(dir, f[i]).delete();
                    }
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
            if (!f[i].startsWith(SUBDIR)) continue;
            try {
                int c = Integer.parseInt(f[i].substring(SUBDIR.length()));
                if (c == rev) continue;
                new FileTree(dir, f[i]).delete();
                continue;
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        if (this.file == null) {
            if (location != null) {
                try {
                    URL url = new URL(location);
                    this.file = new FileTree(this.getFile(url));
                }
                catch (Exception e) {
                    throw new IOException("Bad file URL stored in referenced jar in: " + dir.getAbsolutePath() + ", location=" + location);
                }
            }
            if (this.file == null || !this.file.exists()) {
                throw new IOException("No saved jar file found in: " + dir.getAbsolutePath() + ", old location=" + location);
            }
        }
        this.jar = this.file.isDirectory() ? null : new ZipFile(this.file);
        if (checkSigned) {
            this.loadCertificates();
        }
        if (this.manifest == null) {
            this.manifest = this.getAutoManifest();
        }
        this.handleAutoManifest();
    }

    Archive(Archive a, String path) throws IOException {
        this.location = a.location;
        if (a.jar != null) {
            this.jar = a.jar;
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            this.subJar = this.jar.getEntry(path);
            if (this.subJar == null) {
                this.subJar = this.jar.getEntry(path.substring(0, path.length() - 1));
            }
            if (this.subJar == null) {
                throw new IOException("No such JAR component: " + path);
            }
            this.file = a.file;
        } else {
            this.file = this.findFile(a.file, path);
            this.jar = this.file.isDirectory() ? null : new ZipFile(this.file);
        }
    }

    public String toString() {
        if (this.subJar != null) {
            return this.file.getAbsolutePath() + "(" + this.subJar.getName() + ")";
        }
        return this.file.getAbsolutePath();
    }

    int getRevision() {
        try {
            return Integer.parseInt(this.file.getName().substring(ARCHIVE.length()));
        }
        catch (NumberFormatException ignore) {
            return -1;
        }
    }

    public String getAttribute(String key) {
        Attributes a = this.manifest.getMainAttributes();
        if (a != null) {
            return a.getValue(key);
        }
        return null;
    }

    public byte[] getClassBytes(String classFile) throws IOException {
        if (this.bClosed) {
            return null;
        }
        InputFlow cif = this.getInputFlow(classFile);
        if (cif != null) {
            byte[] bytes;
            if (cif.length >= 0L) {
                bytes = new byte[(int)cif.length];
                DataInputStream dis = new DataInputStream(cif.is);
                dis.readFully(bytes);
            } else {
                bytes = new byte[]{};
                byte[] tmp = new byte[8192];
                try {
                    int len;
                    while ((len = cif.is.read(tmp)) > 0) {
                        byte[] oldbytes = bytes;
                        bytes = new byte[oldbytes.length + len];
                        System.arraycopy(oldbytes, 0, bytes, 0, oldbytes.length);
                        System.arraycopy(tmp, 0, bytes, oldbytes.length, len);
                    }
                }
                catch (EOFException ignore) {
                    // empty catch block
                }
            }
            cif.is.close();
            return bytes;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    InputFlow getInputFlow(String component) {
        if (this.bClosed) {
            return null;
        }
        if (component.startsWith("/")) {
            throw new RuntimeException("Assert! Path should never start with / here");
        }
        ZipEntry ze = null;
        try {
            if (this.jar != null) {
                if (this.subJar != null) {
                    if (this.subJar.isDirectory()) {
                        ze = this.jar.getEntry(this.subJar.getName() + component);
                        if (null == ze) return null;
                        InputStream is = this.jar.getInputStream(ze);
                        if (null != is) {
                            return new InputFlow(is, ze.getSize());
                        }
                        if (component.endsWith("/")) return new InputFlow(is, ze.getSize());
                        ZipEntry ze2 = this.jar.getEntry(this.subJar.getName() + component + "/");
                        is = this.jar.getInputStream(ze2);
                        return new InputFlow(is, ze.getSize());
                    }
                    if (component.equals("")) {
                        return new InputFlow(this.jar.getInputStream(this.subJar), this.subJar.getSize());
                    }
                    JarInputStream ji = new JarInputStream(this.jar.getInputStream(this.subJar));
                    do {
                        if ((ze = ji.getNextJarEntry()) != null) continue;
                        ji.close();
                        return null;
                    } while (!component.equals(ze.getName()));
                    return new InputFlow(ji, ze.getSize());
                }
                if (component.equals("")) {
                    File f = new File(this.jar.getName());
                    return new InputFlow(new FileInputStream(f), f.length());
                }
                ze = this.jar.getEntry(component);
                if (null == ze) return null;
                InputStream is = this.jar.getInputStream(ze);
                if (null != is) {
                    return new InputFlow(is, ze.getSize());
                }
                if (component.endsWith("/")) return new InputFlow(is, ze.getSize());
                ZipEntry ze2 = this.jar.getEntry(component + "/");
                is = this.jar.getInputStream(ze2);
                return new InputFlow(is, ze.getSize());
            }
            FileTree f = this.findFile(this.file, component);
            if (!f.exists()) return null;
            InputFlow inputFlow = new InputFlow(new FileInputStream(f), f.length());
            return inputFlow;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public Enumeration findResourcesPath(String path) {
        Vector<String> answer = new Vector<String>();
        if (this.jar != null) {
            path.replace('\\', '/');
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (!path.endsWith("/") && path.length() > 1) {
                path = path + "/";
            }
            Enumeration<? extends ZipEntry> entries = this.jar.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(path)) continue;
                int idx = name.lastIndexOf(47);
                if (entry.isDirectory()) {
                    idx = name.substring(0, idx).lastIndexOf(47);
                }
                if (idx > 0) {
                    if (!name.substring(0, idx + 1).equals(path)) continue;
                    answer.add(name);
                    continue;
                }
                if (!path.equals("")) continue;
                answer.add(name);
            }
        } else {
            FileTree f = this.findFile(this.file, path);
            if (!f.exists()) {
                return null;
            }
            if (!f.isDirectory()) {
                return null;
            }
            File[] files = f.listFiles();
            int length = files.length;
            for (int i = 0; i < length; ++i) {
                String filePath = files[i].getPath();
                filePath = filePath.substring(this.file.getPath().length() + 1);
                filePath = filePath.replace(File.separatorChar, '/');
                if (files[i].isDirectory()) {
                    filePath = filePath + "/";
                }
                answer.add(filePath);
            }
        }
        if (answer.size() == 0) {
            return null;
        }
        return answer.elements();
    }

    public FileArchive getSubArchive(String path) throws IOException {
        if (this.bClosed) {
            return null;
        }
        return new Archive(this, path);
    }

    public InputStream getInputStream(String component) {
        InputFlow aif = this.getInputFlow(component);
        return aif != null ? aif.is : null;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getNativeLibrary(String path) throws IOException {
        File lib;
        if (this.bClosed) {
            throw new IOException("Archive is closed");
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (this.jar != null) {
            lib = this.getSubFile(this, path);
            if (lib.exists()) return lib.getAbsolutePath();
            new File(lib.getParent()).mkdirs();
            ZipEntry ze = this.jar.getEntry(path);
            if (ze == null) throw new FileNotFoundException("No such sub-archive: " + path);
            InputStream is = this.jar.getInputStream(ze);
            try {
                this.loadFile(lib, is);
                return lib.getAbsolutePath();
            }
            finally {
                is.close();
            }
        } else {
            lib = this.findFile(this.file, path);
            if (lib.exists() || lib.getParent() == null) return lib.getAbsolutePath();
            final String libname = lib.getName();
            File[] list = lib.getParentFile().listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    int pos = name.lastIndexOf(libname);
                    return pos > 1 && name.charAt(pos - 1) == '_';
                }
            });
            if (list.length <= 0) return lib.getAbsolutePath();
            list[0].renameTo(lib);
        }
        return lib.getAbsolutePath();
    }

    void purge() {
        this.close();
        if (!this.fileIsReference) {
            this.file.delete();
        }
        this.getSubFileTree(this).delete();
        this.removeCertificates();
    }

    void close() {
        this.bClosed = true;
        if (this.subJar == null && this.jar != null) {
            try {
                this.jar.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    String getPath() {
        return this.file.getAbsolutePath();
    }

    Certificate[] getCertificates() {
        return this.certs;
    }

    void invalidateCertificates() {
        this.certs = null;
    }

    private void checkManifest() {
        Attributes a = this.manifest.getMainAttributes();
        Util.parseEntries("Export-Package", a.getValue("Export-Package"), false, true, false);
        Util.parseEntries("Import-Package", a.getValue("Import-Package"), false, true, false);
    }

    private boolean needUnpack(Attributes a) {
        Iterator nc = Util.parseEntries("Bundle-NativeCode", a.getValue("Bundle-NativeCode"), false, false, false);
        String bc = a.getValue("Bundle-ClassPath");
        return bc != null && !bc.trim().equals(".") || nc.hasNext();
    }

    private void handleAutoManifest() throws IOException {
        AutoManifest mf;
        if (this.manifest instanceof AutoManifest && (mf = (AutoManifest)this.manifest).isAuto()) {
            if (this.jar != null) {
                mf.addZipFile(this.jar);
            } else if (this.file != null && this.file.isDirectory()) {
                mf.addFile(this.file.getAbsolutePath(), this.file);
            }
        }
    }

    private FileTree findFile(File root, String path) {
        return new FileTree(root, path.replace('/', File.separatorChar));
    }

    private AutoManifest getAutoManifest() throws IOException {
        InputFlow mif = this.getInputFlow("META-INF/MANIFEST.MF");
        if (mif != null) {
            return new AutoManifest(new Manifest(mif.is), this.location);
        }
        throw new IOException("Manifest is missing");
    }

    private FileTree getSubFileTree(Archive archive) {
        return new FileTree(archive.file.getParent(), SUBDIR + archive.file.getName().substring(ARCHIVE.length()));
    }

    private File getSubFile(Archive archive, String path) {
        return new File(this.getSubFileTree(archive), path.replace('/', '-'));
    }

    private void loadFile(File output, InputStream is) throws IOException {
        OutputStream os = null;
        try {
            if (output != null) {
                os = new FileOutputStream(output);
            }
            byte[] buf = new byte[8192];
            try {
                int n;
                while ((n = is.read(buf)) >= 0) {
                    if (os == null) continue;
                    os.write(buf, 0, n);
                }
            }
            catch (EOFException ignore) {
                // empty catch block
            }
        }
        catch (IOException e) {
            if (os != null) {
                output.delete();
            }
            throw e;
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    private boolean isArchiveSigned() {
        return this.certs != null;
    }

    private boolean processNextJarEntry(JarInputStream ji, boolean verify, File saveDir) throws IOException {
        JarEntry je;
        while ((je = ji.getNextJarEntry()) != null) {
            if (je.isDirectory()) continue;
            String name = je.getName();
            if (saveDir != null && !name.startsWith(OSGI_OPT_DIR)) {
                StringTokenizer st = new StringTokenizer(name, "/");
                File f = new File(saveDir, st.nextToken());
                while (st.hasMoreTokens()) {
                    f.mkdir();
                    f = new File(f, st.nextToken());
                }
                this.loadFile(f, ji);
            } else {
                this.loadFile(null, ji);
            }
            ji.closeEntry();
            if (name.startsWith(META_INF_DIR)) continue;
            if (verify) {
                Object[] c = je.getCertificates();
                if (c != null) {
                    if (this.certs != null) {
                        if (!Arrays.equals(c, this.certs)) {
                            this.certs = null;
                        }
                    } else {
                        this.certs = c;
                    }
                } else {
                    this.certs = null;
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSignedJar(File file) throws IOException, BundleException {
        FileInputStream fis = new FileInputStream(file);
        try {
            BufferedInputStream bis = new BufferedInputStream(fis);
            JarInputStream ji = new JarInputStream(bis);
            int count = 0;
            this.manifest = ji.getManifest();
            while (this.processNextJarEntry(ji, true, null) && this.isArchiveSigned()) {
                ++count;
            }
            this.checkCertificates(count, true);
        }
        finally {
            fis.close();
        }
    }

    private void checkCertificates(int filesVerified, boolean complete) throws BundleException {
        if (filesVerified > 0) {
            int mentries;
            if (complete) {
                mentries = this.manifest.getEntries().size();
            } else {
                mentries = 0;
                Iterator<String> i = this.manifest.getEntries().keySet().iterator();
                while (i.hasNext()) {
                    String name = i.next();
                    if (name.startsWith(OSGI_OPT_DIR)) continue;
                    ++mentries;
                }
            }
            if (mentries != filesVerified) {
                this.certs = null;
                System.err.println("All entries in bundle not completly signed (" + mentries + " != " + filesVerified + ")");
            }
        }
    }

    public void saveCertificates() throws IOException {
        File f = new File(this.getPath() + CERTS_SUFFIX);
        if (this.certs != null) {
            try {
                FileOutputStream fos = new FileOutputStream(f);
                for (int i = 0; i < this.certs.length; ++i) {
                    fos.write(this.certs[i].getEncoded());
                }
                fos.close();
            }
            catch (CertificateEncodingException certificateEncodingException) {
                // empty catch block
            }
        }
    }

    private void loadCertificates() throws IOException {
        File f = new File(this.getPath() + CERTS_SUFFIX);
        if (f.canRead()) {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                FileInputStream fis = new FileInputStream(f);
                Collection<? extends Certificate> c = cf.generateCertificates(fis);
                if (c.size() > 0) {
                    this.certs = new Certificate[c.size()];
                    this.certs = c.toArray(this.certs);
                }
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
    }

    public void removeCertificates() {
        File f = new File(this.getPath() + CERTS_SUFFIX);
        f.delete();
    }

    class InputFlow {
        final InputStream is;
        final long length;

        InputFlow(InputStream is, long length) {
            this.is = is;
            this.length = length;
        }
    }
}

