/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.knopflerfish.framework.AttributeTokenizer;
import org.knopflerfish.framework.FileTree;
import org.knopflerfish.framework.Framework;

public class Util {
    protected static String WHITESPACE = " \t\n\r";
    protected static char CITCHAR = (char)34;
    static final Comparator strComp = new Comparator(){

        public int compare(Object oa, Object ob) throws ClassCastException {
            String a = (String)oa;
            String b = (String)ob;
            return a.compareTo(b);
        }
    };
    private static final byte[] encTab = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] decTab = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};
    static /* synthetic */ Class class$org$knopflerfish$framework$Main;

    public static FileTree getFileStorage(String name) {
        String fwdir = Framework.getProperty("org.osgi.framework.dir");
        if (fwdir == null || Framework.bIsMemoryStorage) {
            return null;
        }
        FileTree dir = new FileTree(new File(fwdir).getAbsoluteFile(), name);
        if (dir != null) {
            if (dir.exists()) {
                if (!dir.isDirectory()) {
                    throw new RuntimeException("Not a directory: " + dir);
                }
            } else if (!dir.mkdirs()) {
                throw new RuntimeException("Cannot create directory: " + dir);
            }
        }
        return dir;
    }

    public static int compareStringVersion(String ver1, String ver2) throws NumberFormatException {
        while (ver1 != null || ver2 != null) {
            int i2;
            int i1;
            if (ver1 != null) {
                int d1 = ver1.indexOf(".");
                if (d1 == -1) {
                    i1 = Integer.parseInt(ver1.trim());
                    ver1 = null;
                } else {
                    i1 = Integer.parseInt(ver1.substring(0, d1).trim());
                    ver1 = ver1.substring(d1 + 1);
                }
            } else {
                i1 = 0;
            }
            if (ver2 != null) {
                int d2 = ver2.indexOf(".");
                if (d2 == -1) {
                    i2 = Integer.parseInt(ver2.trim());
                    ver2 = null;
                } else {
                    i2 = Integer.parseInt(ver2.substring(0, d2).trim());
                    ver2 = ver2.substring(d2 + 1);
                }
            } else {
                i2 = 0;
            }
            if (i1 < i2) {
                return -1;
            }
            if (i1 <= i2) continue;
            return 1;
        }
        return 0;
    }

    public static ArrayList parseEnumeration(String d, String s) {
        ArrayList<String> result = new ArrayList<String>();
        if (s != null) {
            AttributeTokenizer at = new AttributeTokenizer(s);
            do {
                String key;
                if ((key = at.getKey()) == null) {
                    throw new IllegalArgumentException("Directive " + d + ", unexpected character at: " + at.getRest());
                }
                if (!at.getEntryEnd()) {
                    throw new IllegalArgumentException("Directive " + d + ", expected end of entry at: " + at.getRest());
                }
                int i = Math.abs(Util.binarySearch(result, strComp, key) + 1);
                result.add(i, key);
            } while (!at.getEnd());
            return result;
        }
        return null;
    }

    public static Iterator parseEntries(String a, String s, boolean single, boolean unique, boolean single_entry) {
        ArrayList result = new ArrayList();
        if (s != null) {
            AttributeTokenizer at = new AttributeTokenizer(s);
            do {
                String param;
                ArrayList<String> keys = new ArrayList<String>();
                HashMap<String, Object> params = new HashMap<String, Object>();
                TreeSet<String> directives = new TreeSet<String>();
                params.put("$directives", directives);
                String key = at.getKey();
                if (key == null) {
                    throw new IllegalArgumentException("Definition, " + a + ", expected key at: " + at.getRest() + ". Key values are terminated by a ';' or a ',' and may not " + "contain ':', '='.");
                }
                if (!single) {
                    keys.add(key);
                    while ((key = at.getKey()) != null) {
                        keys.add(key);
                    }
                }
                while ((param = at.getParam()) != null) {
                    ArrayList<String> old = (ArrayList<String>)params.get(param);
                    boolean is_directive = at.isDirective();
                    if (old != null && unique) {
                        throw new IllegalArgumentException("Definition, " + a + ", duplicate " + (is_directive ? "directive" : "attribute") + ": " + param);
                    }
                    String value = at.getValue();
                    if (value == null) {
                        throw new IllegalArgumentException("Definition, " + a + ", expected value at: " + at.getRest());
                    }
                    if (is_directive) {
                        directives.add(param);
                    }
                    if (unique) {
                        params.put(param, value);
                        continue;
                    }
                    if (old == null) {
                        old = new ArrayList<String>();
                        params.put(param, old);
                    }
                    old.add(value);
                }
                if (at.getEntryEnd()) {
                    if (single) {
                        params.put("$key", key);
                    } else {
                        params.put("$keys", keys);
                    }
                } else {
                    throw new IllegalArgumentException("Definition, " + a + ", expected end of entry at: " + at.getRest());
                }
                result.add(params);
                if (!single_entry || at.getEnd()) continue;
                throw new IllegalArgumentException("Definition, " + a + ", expected end of single entry at: " + at.getRest());
            } while (!at.getEnd());
        }
        return ((AbstractList)result).iterator();
    }

    static byte[] readResource(String name) throws IOException {
        int n;
        byte[] buf = new byte[1024];
        InputStream in = (class$org$knopflerfish$framework$Main == null ? (class$org$knopflerfish$framework$Main = Util.class$("org.knopflerfish.framework.Main")) : class$org$knopflerfish$framework$Main).getResourceAsStream(name);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        while ((n = in.read(buf)) > 0) {
            bout.write(buf, 0, n);
        }
        try {
            in.close();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return bout.toByteArray();
    }

    public static String[] splitwords(String s) {
        return Util.splitwords(s, WHITESPACE);
    }

    public static String[] splitwords(String s, String whiteSpace) {
        return Util.splitwords(s, whiteSpace, CITCHAR);
    }

    public static String[] splitwords(String s, String whiteSpace, char citChar) {
        boolean bCit = false;
        Vector<String> v = new Vector<String>();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (bCit || whiteSpace.indexOf(c) == -1) {
                if (c == citChar) {
                    bCit = !bCit;
                } else {
                    if (buf == null) {
                        buf = new StringBuffer();
                    }
                    buf.append(c);
                }
                ++i;
                continue;
            }
            if (buf != null) {
                v.addElement(buf.toString());
                buf = null;
            }
            while (i < s.length() && -1 != whiteSpace.indexOf(s.charAt(i))) {
                ++i;
            }
        }
        if (buf != null) {
            v.addElement(buf.toString());
        }
        Object[] r = new String[v.size()];
        v.copyInto(r);
        return r;
    }

    public static String replace(String s, String v1, String v2) {
        if (s == null || v1 == null || v2 == null || v1.length() == 0 || v1.equals(v2)) {
            return s;
        }
        int ix = 0;
        int v1Len = v1.length();
        int n = 0;
        while (-1 != (ix = s.indexOf(v1, ix))) {
            ++n;
            ix += v1Len;
        }
        if (n == 0) {
            return s;
        }
        int start = 0;
        int v2Len = v2.length();
        char[] r = new char[s.length() + n * (v2Len - v1Len)];
        int rPos = 0;
        while (-1 != (ix = s.indexOf(v1, start))) {
            while (start < ix) {
                r[rPos++] = s.charAt(start++);
            }
            for (int j = 0; j < v2Len; ++j) {
                r[rPos++] = v2.charAt(j);
            }
            start += v1Len;
        }
        ix = s.length();
        while (start < ix) {
            r[rPos++] = s.charAt(start++);
        }
        return new String(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getContent(File f) {
        DataInputStream in = null;
        in = new DataInputStream(new FileInputStream(f));
        String string = in.readUTF();
        Object var4_4 = null;
        if (in == null) return string;
        try {
            in.close();
            return string;
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return string;
        catch (IOException iOException) {
            try {
                Object var4_5 = null;
                if (in == null) return null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                in.close();
                return null;
            }
            catch (IOException ignore) {}
            return null;
        }
    }

    public static void putContent(File f, String content) throws IOException {
        Util.putContent(f, content, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putContent(File f, String content, boolean useUTF8) throws IOException {
        FilterOutputStream out = null;
        try {
            out = new DataOutputStream(new FileOutputStream(f));
            if (useUTF8) {
                ((DataOutputStream)out).writeUTF(content);
            } else {
                ((DataOutputStream)out).writeChars(content);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static void sort(List a, Comparator cf, boolean bReverse) {
        Util.sort(a, 0, a.size() - 1, cf, bReverse ? -1 : 1);
    }

    static void sort(List a, int lo0, int hi0, Comparator cf, int k) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            Object mid = a.get((lo0 + hi0) / 2);
            while (lo <= hi) {
                while (lo < hi0 && k * cf.compare(a.get(lo), mid) < 0) {
                    ++lo;
                }
                while (hi > lo0 && k * cf.compare(a.get(hi), mid) > 0) {
                    --hi;
                }
                if (lo > hi) continue;
                Util.swap(a, lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                Util.sort(a, lo0, hi, cf, k);
            }
            if (lo < hi0) {
                Util.sort(a, lo, hi0, cf, k);
            }
        }
    }

    private static void swap(List a, int i, int j) {
        Object tmp = a.get(i);
        a.set(i, a.get(j));
        a.set(j, tmp);
    }

    public static int binarySearch(List pl, Comparator c, Object p) {
        int l = 0;
        int u = pl.size() - 1;
        while (l <= u) {
            int m = (l + u) / 2;
            int v = c.compare(pl.get(m), p);
            if (v > 0) {
                l = m + 1;
                continue;
            }
            if (v < 0) {
                u = m - 1;
                continue;
            }
            return m;
        }
        return -(l + 1);
    }

    public static String base64Encode(String s) throws IOException {
        return Util.encode(s.getBytes(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encode(byte[] in, int len) throws IOException {
        String string;
        ByteArrayInputStream bais;
        block4: {
            ByteArrayOutputStream baos = null;
            bais = null;
            try {
                baos = new ByteArrayOutputStream();
                bais = new ByteArrayInputStream(in);
                Util.encode(bais, baos, len);
                string = new String(baos.toByteArray());
                Object var6_5 = null;
                if (baos == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var6_6 = null;
                    if (baos != null) {
                        baos.close();
                    }
                    if (bais == null) break block5;
                    bais.close();
                }
                throw throwable;
            }
            baos.close();
        }
        if (bais != null) {
            bais.close();
        }
        return string;
    }

    public static void encode(InputStream in, OutputStream out, int len) throws IOException {
        int b;
        if (len % 4 != 0) {
            throw new IllegalArgumentException("Length must be a multiple of 4");
        }
        int bits = 0;
        int nbits = 0;
        int nbytes = 0;
        while ((b = in.read()) != -1) {
            bits = bits << 8 | b;
            nbits += 8;
            while (nbits >= 6) {
                out.write(encTab[0x3F & bits >> (nbits -= 6)]);
                if (len == 0 || ++nbytes < len) continue;
                out.write(13);
                out.write(10);
                nbytes -= len;
            }
        }
        switch (nbits) {
            case 2: {
                out.write(encTab[0x3F & bits << 4]);
                out.write(61);
                out.write(61);
                break;
            }
            case 4: {
                out.write(encTab[0x3F & bits << 2]);
                out.write(61);
            }
        }
        if (len != 0) {
            if (nbytes != 0) {
                out.write(13);
                out.write(10);
            }
            out.write(13);
            out.write(10);
        }
    }

    static void mergeDictionaries(Dictionary target, Dictionary extra) {
        Enumeration e = extra.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if (target.get(key) != null) continue;
            target.put(key, extra.get(key));
        }
    }

    public static boolean filterMatch(String filter, String s) {
        return Util.patSubstr(s.toCharArray(), 0, filter.toCharArray(), 0);
    }

    private static boolean patSubstr(char[] s, int si, char[] pat, int pi) {
        if (pat.length - pi == 0) {
            return s.length - si == 0;
        }
        if (pat[pi] == '*') {
            ++pi;
            while (true) {
                if (Util.patSubstr(s, si, pat, pi)) {
                    return true;
                }
                if (s.length - si == 0) {
                    return false;
                }
                ++si;
            }
        }
        if (s.length - si == 0) {
            return false;
        }
        if (s[si] != pat[pi]) {
            return false;
        }
        return Util.patSubstr(s, ++si, pat, ++pi);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Comparator {
        public int compare(Object var1, Object var2);
    }
}

