/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.knopflerfish.framework.BundleClassLoader;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.Framework;
import org.knopflerfish.framework.Pkg;
import org.knopflerfish.framework.PropertiesDictionary;
import org.knopflerfish.framework.ServiceRegistrationImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;

public class ServiceReferenceImpl
implements ServiceReference {
    private ServiceRegistrationImpl registration;

    ServiceReferenceImpl(ServiceRegistrationImpl reg) {
        this.registration = reg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String key) {
        PropertiesDictionary propertiesDictionary = this.registration.properties;
        synchronized (propertiesDictionary) {
            if (this.registration.properties != null) {
                return this.cloneObject(this.registration.properties.get(key));
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPropertyKeys() {
        PropertiesDictionary propertiesDictionary = this.registration.properties;
        synchronized (propertiesDictionary) {
            return this.registration.properties.keyArray();
        }
    }

    public Bundle getBundle() {
        return this.registration.bundle;
    }

    public boolean equals(Object o) {
        if (o instanceof ServiceReferenceImpl) {
            return this.registration == ((ServiceReferenceImpl)o).registration;
        }
        return false;
    }

    public int hashCode() {
        return this.registration.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle[] getUsingBundles() {
        PropertiesDictionary propertiesDictionary = this.registration.properties;
        synchronized (propertiesDictionary) {
            if (this.registration.reference != null && this.registration.dependents.size() > 0) {
                Set bs = this.registration.dependents.keySet();
                Bundle[] res = new Bundle[bs.size()];
                return bs.toArray(res);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getService(BundleImpl bundle) {
        Object s = null;
        PropertiesDictionary propertiesDictionary = this.registration.properties;
        synchronized (propertiesDictionary) {
            if (this.registration.available && (!this.registration.unregistering || Framework.UNREGISTERSERVICE_VALID_DURING_UNREGISTERING)) {
                Integer ref = (Integer)this.registration.dependents.get(bundle);
                if (ref == null) {
                    String[] classes = (String[])this.registration.properties.get("objectClass");
                    bundle.framework.perm.checkGetServicePerms(classes);
                    if (this.registration.service instanceof ServiceFactory) {
                        try {
                            s = bundle.framework.perm.callGetService((ServiceFactory)this.registration.service, bundle, this.registration);
                        }
                        catch (Throwable pe) {
                            bundle.framework.listeners.frameworkError(this.registration.bundle, pe);
                            return null;
                        }
                        if (s == null) {
                            return null;
                        }
                        BundleClassLoader bcl = (BundleClassLoader)this.registration.bundle.getClassLoader();
                        for (int i = 0; i < classes.length; ++i) {
                            Class c = null;
                            try {
                                c = bcl.loadClass(classes[i], true);
                            }
                            catch (ClassNotFoundException ignore) {
                                // empty catch block
                            }
                            if (c.isInstance(s)) continue;
                            bundle.framework.listeners.frameworkError(this.registration.bundle, new BundleException("ServiceFactory produced an object that did not implement: " + classes[i]));
                            return null;
                        }
                        this.registration.serviceInstances.put(bundle, s);
                    } else {
                        s = this.registration.service;
                    }
                    this.registration.dependents.put(bundle, new Integer(1));
                } else {
                    int count = ref;
                    this.registration.dependents.put(bundle, new Integer(count + 1));
                    s = this.registration.service instanceof ServiceFactory ? this.registration.serviceInstances.get(bundle) : this.registration.service;
                }
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean ungetService(BundleImpl bundle, boolean checkRefCounter) {
        PropertiesDictionary propertiesDictionary = this.registration.properties;
        synchronized (propertiesDictionary) {
            boolean hadReferences = false;
            if (this.registration.reference != null) {
                Object sfi;
                int count;
                boolean removeService = false;
                Object countInteger = this.registration.dependents.remove(bundle);
                int n = count = countInteger != null ? (Integer)countInteger : 0;
                if (count > 0) {
                    hadReferences = true;
                }
                if (checkRefCounter) {
                    if (count > 1) {
                        this.registration.dependents.put(bundle, new Integer(count - 1));
                    } else if (count == 1) {
                        removeService = true;
                    }
                } else {
                    removeService = true;
                }
                if (removeService && (sfi = this.registration.serviceInstances.remove(bundle)) != null) {
                    try {
                        ((ServiceFactory)this.registration.service).ungetService(bundle, this.registration, sfi);
                    }
                    catch (Throwable e) {
                        bundle.framework.listeners.frameworkError(this.registration.bundle, e);
                    }
                }
            }
            return hadReferences;
        }
    }

    PropertiesDictionary getProperties() {
        return this.registration.properties;
    }

    Object cloneObject(Object val) {
        if (val instanceof Object[]) {
            int len = Array.getLength(val = ((Object[])val).clone());
            if (len > 0 && Array.get(val, 0).getClass().isArray()) {
                for (int i = 0; i < len; ++i) {
                    Array.set(val, i, this.cloneObject(Array.get(val, i)));
                }
            }
        } else if (val instanceof boolean[]) {
            val = ((boolean[])val).clone();
        } else if (val instanceof byte[]) {
            val = ((byte[])val).clone();
        } else if (val instanceof char[]) {
            val = ((char[])val).clone();
        } else if (val instanceof double[]) {
            val = ((double[])val).clone();
        } else if (val instanceof float[]) {
            val = ((float[])val).clone();
        } else if (val instanceof int[]) {
            val = ((int[])val).clone();
        } else if (val instanceof long[]) {
            val = ((long[])val).clone();
        } else if (val instanceof short[]) {
            val = ((short[])val).clone();
        } else if (val instanceof Vector) {
            Vector c = (Vector)((Vector)val).clone();
            for (int i = 0; i < c.size(); ++i) {
                c.setElementAt(this.cloneObject(c.elementAt(i)), i);
            }
            val = c;
        }
        return val;
    }

    public boolean isAssignableTo(Bundle bundle, String className) {
        Framework fwCtx = this.registration.bundle.framework;
        if (((BundleImpl)bundle).framework != fwCtx) {
            throw new IllegalArgumentException("Bundle is not from this framework");
        }
        if (BundleClassLoader.isBootDelegated(className)) {
            return true;
        }
        int pos = className.lastIndexOf(46);
        if (pos != -1) {
            String name = className.substring(0, pos);
            Pkg p = fwCtx.packages.getPkg(name);
            if (p != null) {
                ArrayList<BundlePackages> pkgConsumer;
                ArrayList pkgProvider;
                BundlePackages pkgExporter = this.registration.bundle.bpkgs.getProviderBundlePackages(name);
                if (pkgExporter == null) {
                    pkgProvider = this.registration.bundle.bpkgs.getRequiredBundlePackages(name);
                } else {
                    pkgProvider = new ArrayList(1);
                    pkgProvider.add(pkgExporter);
                }
                BundlePackages bb = ((BundleImpl)bundle).bpkgs;
                BundlePackages bbp = bb.getProviderBundlePackages(name);
                if (bbp == null) {
                    pkgConsumer = bb.getRequiredBundlePackages(name);
                } else {
                    pkgConsumer = new ArrayList<BundlePackages>(1);
                    pkgConsumer.add(bbp);
                }
                if (pkgConsumer == null) {
                    if (bb.getExport(name) != null) {
                        return pkgProvider != null ? pkgProvider.contains(bb) : true;
                    }
                    return true;
                }
                if (pkgProvider == null) {
                    if (p.providers.size() == 1) {
                        return true;
                    }
                    if (this.registration.service instanceof ServiceFactory) {
                        return true;
                    }
                    ClassLoader bCL = bb.getClassLoader();
                    if (bCL != null) {
                        try {
                            Class<?> bCls = bCL.loadClass(className);
                            return bCls.isAssignableFrom(this.registration.service.getClass());
                        }
                        catch (Exception e) {
                            return true;
                        }
                    }
                } else {
                    Iterator i = pkgProvider.iterator();
                    while (i.hasNext()) {
                        if (!pkgConsumer.contains(i.next())) continue;
                        return true;
                    }
                }
            } else {
                if (name.startsWith("java.") || this.registration.bundle == bundle) {
                    return true;
                }
                return true;
            }
        }
        return false;
    }
}

