/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.Listeners;
import org.knopflerfish.framework.ServiceListenerEntry;
import org.knopflerfish.framework.ServiceReferenceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;

class ServiceListenerState {
    protected static final String[] hashedKeys = new String[]{"objectClass".toLowerCase(), "service.id".toLowerCase(), "service.pid".toLowerCase()};
    private static final int OBJECTCLASS_IX = 0;
    private static final int SERVICE_ID_IX = 1;
    private static final int SERVICE_PID_IX = 2;
    protected static List hashedKeysV;
    List complicatedListeners = new ArrayList();
    Map[] cache = new HashMap[hashedKeys.length];
    Set serviceSet = new HashSet();

    ServiceListenerState() {
        hashedKeysV = new ArrayList();
        for (int i = 0; i < hashedKeys.length; ++i) {
            hashedKeysV.add(hashedKeys[i]);
            this.cache[i] = new HashMap();
        }
    }

    synchronized void add(Bundle bundle, ServiceListener listener, String filter) throws InvalidSyntaxException {
        ServiceListenerEntry sle = new ServiceListenerEntry(bundle, listener, filter);
        if (this.serviceSet.contains(sle)) {
            this.remove(bundle, listener);
        }
        this.serviceSet.add(sle);
        this.checkSimple(sle);
    }

    synchronized void remove(Bundle bundle, ServiceListener listener) {
        Iterator it = this.serviceSet.iterator();
        while (it.hasNext()) {
            ServiceListenerEntry sle = (ServiceListenerEntry)it.next();
            if (sle.bundle != bundle || sle.listener != listener) continue;
            this.removeFromCache(sle);
            it.remove();
            break;
        }
    }

    private void removeFromCache(ServiceListenerEntry sle) {
        if (sle.local_cache != null) {
            for (int i = 0; i < hashedKeys.length; ++i) {
                HashMap keymap = (HashMap)this.cache[i];
                List l = sle.local_cache[i];
                if (l == null) continue;
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    Object value = it.next();
                    List sles = (List)keymap.get(value);
                    sles.remove(sles.indexOf(sle));
                    if (!sles.isEmpty()) continue;
                    keymap.remove(value);
                }
            }
        } else {
            this.complicatedListeners.remove(sle);
        }
    }

    synchronized void removeAll(Bundle bundle) {
        Iterator it = this.serviceSet.iterator();
        while (it.hasNext()) {
            ServiceListenerEntry sle = (ServiceListenerEntry)it.next();
            if (sle.bundle != bundle) continue;
            this.removeFromCache(sle);
            it.remove();
        }
    }

    public void checkSimple(ServiceListenerEntry sle) {
        if (sle.ldap == null || Listeners.nocacheldap) {
            this.complicatedListeners.add(sle);
        } else {
            List[] local_cache = new List[hashedKeys.length];
            if (sle.ldap.isSimple(hashedKeysV, local_cache)) {
                sle.local_cache = local_cache;
                for (int i = 0; i < hashedKeys.length; ++i) {
                    if (local_cache[i] == null) continue;
                    Iterator it = local_cache[i].iterator();
                    while (it.hasNext()) {
                        Object value = it.next();
                        ArrayList<ServiceListenerEntry> sles = (ArrayList<ServiceListenerEntry>)this.cache[i].get(value);
                        if (sles == null) {
                            sles = new ArrayList<ServiceListenerEntry>();
                            this.cache[i].put(value, sles);
                        }
                        sles.add(sle);
                    }
                }
            } else {
                if (Debug.ldap) {
                    Debug.println("Too complicated filter: " + sle.ldap);
                }
                this.complicatedListeners.add(sle);
            }
        }
    }

    synchronized Set getMatchingListeners(ServiceReferenceImpl sr) {
        Object service_pid;
        HashSet<ServiceListenerEntry> set = new HashSet<ServiceListenerEntry>();
        int n = 0;
        Iterator it = this.complicatedListeners.iterator();
        while (it.hasNext()) {
            ServiceListenerEntry sle = (ServiceListenerEntry)it.next();
            if (sle.ldap == null || sle.ldap.evaluate(sr.getProperties(), false)) {
                set.add(sle);
            }
            ++n;
        }
        if (Debug.ldap) {
            Debug.println("Added " + set.size() + " out of " + n + " listeners with complicated filters");
        }
        String[] c = (String[])sr.getProperty("objectClass");
        for (int i = 0; i < c.length; ++i) {
            if (Debug.ldap) {
                System.err.print("objectclass matches: ");
            }
            this.addToSet(set, (List)this.cache[0].get(c[i]));
        }
        Long service_id = (Long)sr.getProperty("service.id");
        if (service_id != null) {
            if (Debug.ldap) {
                System.err.print("service_id matches: ");
            }
            this.addToSet(set, (List)this.cache[1].get(service_id.toString()));
        }
        if ((service_pid = sr.getProperty("service.pid")) != null && service_pid instanceof String) {
            if (Debug.ldap) {
                System.err.print("service_pid matches: ");
            }
            this.addToSet(set, (List)this.cache[2].get(service_pid));
        }
        return set;
    }

    private void addToSet(Set set, List l) {
        if (l != null) {
            if (Debug.ldap) {
                Debug.println(Integer.toString(l.size()));
            }
            Iterator it = l.iterator();
            while (it.hasNext()) {
                set.add(it.next());
            }
        } else if (Debug.ldap) {
            Debug.println("0");
        }
    }
}

