/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.ImportPkg;
import org.knopflerfish.framework.Pkg;
import org.knopflerfish.framework.Util;
import org.osgi.framework.Version;

class ExportPkg {
    final String name;
    final BundlePackages bpkgs;
    final ArrayList uses;
    final ArrayList mandatory;
    final ArrayList include;
    final ArrayList exclude;
    final Version version;
    final Map attributes;
    boolean zombie = false;
    boolean hasPermission = true;
    Pkg pkg = null;

    ExportPkg(String name, Map tokens, BundlePackages b) {
        this.bpkgs = b;
        this.name = name;
        if (name.startsWith("java.")) {
            throw new IllegalArgumentException("You can not export a java.* package");
        }
        this.uses = Util.parseEnumeration("uses", (String)tokens.remove("uses"));
        this.mandatory = Util.parseEnumeration("mandatory", (String)tokens.remove("mandatory"));
        this.include = Util.parseEnumeration("include", (String)tokens.remove("include"));
        this.exclude = Util.parseEnumeration("exclude", (String)tokens.remove("exclude"));
        String versionStr = (String)tokens.remove("version");
        String specVersionStr = (String)tokens.remove("specification-version");
        if (specVersionStr != null) {
            this.version = new Version(specVersionStr);
            if (versionStr != null && !this.version.equals(new Version(versionStr))) {
                throw new IllegalArgumentException("Both versionand specification-versionare specified, and differs");
            }
        } else {
            this.version = versionStr != null ? new Version(versionStr) : Version.emptyVersion;
        }
        if (tokens.containsKey("bundle-version")) {
            throw new IllegalArgumentException("Export definition illegally contains attribute, bundle-version");
        }
        if (tokens.containsKey("bundle-symbolic-name")) {
            throw new IllegalArgumentException("Export definition illegally contains attribute, bundle-symbolic-name");
        }
        Set directiveNames = (Set)tokens.remove("$directives");
        if (null != directiveNames) {
            Iterator dit = directiveNames.iterator();
            while (dit.hasNext()) {
                tokens.remove((String)dit.next());
            }
        }
        tokens.remove("$key");
        tokens.remove("$keys");
        this.attributes = tokens;
    }

    ExportPkg(ExportPkg ep, String name) {
        this.name = name;
        this.bpkgs = ep.bpkgs;
        this.uses = ep.uses;
        this.mandatory = ep.mandatory;
        this.include = ep.include;
        this.exclude = ep.exclude;
        this.version = ep.version;
        this.attributes = ep.attributes;
    }

    ExportPkg(ExportPkg ep, BundlePackages b) {
        this.name = ep.name;
        this.bpkgs = b;
        this.uses = ep.uses;
        this.mandatory = ep.mandatory;
        this.include = ep.include;
        this.exclude = ep.exclude;
        this.version = ep.version;
        this.attributes = ep.attributes;
    }

    synchronized void attachPkg(Pkg p) {
        this.pkg = p;
    }

    synchronized void detachPkg() {
        this.pkg = null;
        this.zombie = false;
    }

    boolean checkFilter(String fullClassName) {
        String clazz = null;
        boolean ok = true;
        if (fullClassName != null) {
            Iterator i;
            if (this.include != null) {
                clazz = fullClassName.substring(this.name.length() + 1);
                i = ((AbstractList)this.include).iterator();
                while (i.hasNext() && !Util.filterMatch((String)i.next(), clazz)) {
                    if (i.hasNext()) continue;
                    ok = false;
                }
            }
            if (ok && this.exclude != null) {
                if (clazz == null) {
                    clazz = fullClassName.substring(this.name.length() + 1);
                }
                i = ((AbstractList)this.exclude).iterator();
                while (i.hasNext()) {
                    if (!Util.filterMatch((String)i.next(), clazz)) continue;
                    ok = false;
                    break;
                }
            }
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean isProvider() {
        if (this.pkg != null) {
            Pkg pkg = this.pkg;
            synchronized (pkg) {
                return this.pkg.providers.contains(this) || this.bpkgs.isRequired();
            }
        }
        return false;
    }

    synchronized boolean isExported() {
        if (this.pkg != null && ((this.bpkgs.bundle.state & BundleImpl.RESOLVED_FLAGS) != 0 || this.zombie)) {
            BundlePackages bp = this.bpkgs.getProviderBundlePackages(this.name);
            return bp == null || bp.bundle == this.bpkgs.bundle;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Collection getPackageImporters() {
        if (this.pkg != null) {
            HashSet<BundleImpl> res = new HashSet<BundleImpl>();
            Pkg pkg = this.pkg;
            synchronized (pkg) {
                Iterator i = ((AbstractList)this.pkg.importers).iterator();
                while (i.hasNext()) {
                    ImportPkg ip = (ImportPkg)i.next();
                    if (ip.provider != this) continue;
                    res.add(ip.bpkgs.bundle);
                }
            }
            return res;
        }
        return null;
    }

    boolean checkPermission() {
        return this.hasPermission;
    }

    void setPermission(boolean perm) {
        this.hasPermission = perm;
    }

    public String pkgString() {
        if (this.version != Version.emptyVersion) {
            return this.name + ";" + "specification-version" + "=" + this.version;
        }
        return this.name;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.pkgString());
        sb.append('(');
        if (this.zombie) {
            sb.append("zombie, ");
        }
        sb.append(this.bpkgs.toString());
        sb.append(')');
        return sb.toString();
    }
}

