/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.knopflerfish.framework.Framework;
import org.osgi.framework.BundleException;

public class Debug {
    static boolean classLoader = "true".equalsIgnoreCase(Framework.getProperty("org.knopflerfish.framework.debug.classloader"));
    static boolean errors = "true".equalsIgnoreCase(Framework.getProperty("org.knopflerfish.framework.debug.errors"));
    static boolean packages = "true".equalsIgnoreCase(Framework.getProperty("org.knopflerfish.framework.debug.packages"));
    static boolean startlevel = "true".equalsIgnoreCase(Framework.getProperty("org.knopflerfish.framework.debug.startlevel"));
    static boolean url = "true".equalsIgnoreCase(Framework.getProperty("org.knopflerfish.framework.debug.url"));
    static boolean ldap = "true".equalsIgnoreCase(Framework.getProperty("org.knopflerfish.framework.debug.ldap"));
    static boolean service_reference = "true".equalsIgnoreCase(Framework.getProperty("org.knopflerfish.framework.debug.service_reference"));
    static boolean bundle_resource = "true".equalsIgnoreCase(Framework.getProperty("org.knopflerfish.framework.debug.bundle_resource"));
    static boolean bundle_context = "true".equalsIgnoreCase(Framework.getProperty("org.knopflerfish.framework.debug.bundle_context"));
    static boolean patch = "true".equalsIgnoreCase(Framework.getProperty("org.knopflerfish.framework.debug.patch"));
    static boolean automanifest = "true".equalsIgnoreCase(Framework.getProperty("org.knopflerfish.framework.debug.automanifest"));
    static boolean use_do_privilege = System.getSecurityManager() != null && "true".equalsIgnoreCase(Framework.getProperty("org.knopflerfish.framework.debug.print_with_do_privileged", "true"));

    private static void println0(String str) {
        System.out.println("## DEBUG: " + str);
    }

    static void println(final String str) {
        if (use_do_privilege) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Debug.println0(str);
                    return null;
                }
            });
        } else {
            Debug.println0(str);
        }
    }

    private static void printStackTrace0(String str, Throwable t) {
        Throwable n;
        System.out.println("## DEBUG: " + str);
        t.printStackTrace();
        if (t instanceof BundleException && (n = ((BundleException)t).getNestedException()) != null) {
            System.out.println("Nested bundle exception:");
            n.printStackTrace();
        }
    }

    static void printStackTrace(final String str, final Throwable t) {
        if (use_do_privilege) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Debug.printStackTrace0(str, t);
                    return null;
                }
            });
        } else {
            Debug.printStackTrace0(str, t);
        }
    }
}

