/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleClassLoader;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.Bundles;
import org.osgi.framework.AdminPermission;

class BundleURLConnection
extends URLConnection {
    static final Permission ADMIN_PERMISSION = new AdminPermission((String)null, "resource");
    private InputStream is = null;
    private Bundles bundles;
    private BundleImpl bundle;
    private int contentLength;
    private String contentType;
    private long lastModified;

    BundleURLConnection(URL u, Bundles b) {
        super(u);
        this.bundles = b;
    }

    private BundleArchive getBundleArchive() {
        this.bundle = null;
        long ai = -1L;
        long fi = -1L;
        try {
            String s = this.url.getHost();
            int i = s.indexOf(95);
            if (i >= 0) {
                fi = Long.parseLong(s.substring(i + 1));
                s = s.substring(0, i);
            }
            if ((i = s.indexOf(46)) >= 0) {
                ai = Long.parseLong(s.substring(i + 1));
                s = s.substring(0, i);
            }
            this.bundle = (BundleImpl)this.bundles.getBundle(Long.parseLong(s));
        }
        catch (NumberFormatException _ignore) {
            // empty catch block
        }
        if (this.bundle != null) {
            return this.bundle.getBundleArchive(ai, fi);
        }
        return null;
    }

    public void connect() throws IOException {
        if (!this.connected) {
            BundleArchive a = this.getBundleArchive();
            if (a != null) {
                this.is = this.bundle.secure.callGetInputStream(a, this.url.getFile(), this.url.getPort());
            }
            if (this.is != null) {
                this.connected = true;
                this.contentLength = BundleClassLoader.bDalvik ? -1 : this.is.available();
                this.contentType = URLConnection.guessContentTypeFromName(this.url.getFile());
                this.lastModified = a.getLastModified();
            } else {
                throw new IOException("URL not found");
            }
        }
    }

    public InputStream getInputStream() {
        try {
            this.connect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.is;
    }

    public String getContentType() {
        try {
            this.connect();
            return this.contentType;
        }
        catch (IOException e) {
            return null;
        }
    }

    public int getContentLength() {
        try {
            this.connect();
            return this.contentLength;
        }
        catch (IOException e) {
            return -1;
        }
    }

    public long getLastModified() {
        try {
            this.connect();
            return this.lastModified;
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public Permission getPermission() throws IOException {
        return ADMIN_PERMISSION;
    }
}

