/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import groovy.lang.Closure;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.NumberMath;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.clipboard.ClipboardController;
import org.freeplane.features.clipboard.mindmapmode.MClipboardController;
import org.freeplane.features.encrypt.Base64Coding;
import org.freeplane.features.encrypt.EncryptionController;
import org.freeplane.features.encrypt.PasswordStrategy;
import org.freeplane.features.encrypt.mindmapmode.MEncryptionController;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.features.format.IFormattedObject;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinkModel;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.EncryptionModel;
import org.freeplane.features.map.FreeNode;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapNavigationUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.note.NoteController;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.note.mindmapmode.MNoteController;
import org.freeplane.features.text.DetailTextModel;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.features.ui.ViewController;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.AbstractProxy;
import org.freeplane.plugin.script.proxy.AttributesProxy;
import org.freeplane.plugin.script.proxy.CloudProxy;
import org.freeplane.plugin.script.proxy.ConnectorInListProxy;
import org.freeplane.plugin.script.proxy.ConnectorOutListProxy;
import org.freeplane.plugin.script.proxy.ConnectorProxy;
import org.freeplane.plugin.script.proxy.Convertible;
import org.freeplane.plugin.script.proxy.ConvertibleNoteText;
import org.freeplane.plugin.script.proxy.ConvertibleText;
import org.freeplane.plugin.script.proxy.ExternalObjectProxy;
import org.freeplane.plugin.script.proxy.IconsProxy;
import org.freeplane.plugin.script.proxy.LinkProxy;
import org.freeplane.plugin.script.proxy.MapProxy;
import org.freeplane.plugin.script.proxy.NodeStyleProxy;
import org.freeplane.plugin.script.proxy.Proxy;
import org.freeplane.plugin.script.proxy.ProxyUtils;
import org.freeplane.plugin.script.proxy.ReminderProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NodeProxy
extends AbstractProxy<NodeModel>
implements Proxy.Node {
    private static final Integer ONE = 1;
    private static final Integer ZERO = 0;

    public NodeProxy(NodeModel node, ScriptContext scriptContext) {
        super(node, scriptContext);
        if (scriptContext != null) {
            scriptContext.accessNode(node);
        }
    }

    @Override
    public Proxy.Connector addConnectorTo(Proxy.Node target) {
        return this.addConnectorTo(target.getId());
    }

    @Override
    public Proxy.Connector addConnectorTo(String targetNodeID) {
        MLinkController linkController = (MLinkController)LinkController.getController();
        ConnectorModel connectorModel = linkController.addConnector((NodeModel)this.getDelegate(), targetNodeID);
        return new ConnectorProxy(connectorModel, this.getScriptContext());
    }

    @Override
    public Proxy.Node createChild() {
        MMapController mapController = (MMapController)this.getModeController().getMapController();
        NodeModel newNodeModel = new NodeModel(((NodeModel)this.getDelegate()).getMap());
        mapController.insertNode(newNodeModel, (NodeModel)this.getDelegate());
        return new NodeProxy(newNodeModel, this.getScriptContext());
    }

    @Override
    public Proxy.Node createChild(Object value) {
        Proxy.Node child = this.createChild();
        child.setObject(value);
        return child;
    }

    @Override
    public Proxy.Node createChild(int position) {
        MMapController mapController = (MMapController)this.getModeController().getMapController();
        NodeModel newNodeModel = new NodeModel(((NodeModel)this.getDelegate()).getMap());
        mapController.insertNode(newNodeModel, (NodeModel)this.getDelegate(), position);
        return new NodeProxy(newNodeModel, this.getScriptContext());
    }

    @Override
    public Proxy.Node appendChild(Proxy.NodeRO node) {
        return this.appendBranchImpl(node, false);
    }

    @Override
    public Proxy.Node appendBranch(Proxy.NodeRO node) {
        return this.appendBranchImpl(node, true);
    }

    private Proxy.Node appendBranchImpl(Proxy.NodeRO node, boolean withChildren) {
        MClipboardController clipboardController = (MClipboardController)ClipboardController.getController();
        NodeModel newNodeModel = clipboardController.duplicate((NodeModel)((NodeProxy)node).getDelegate(), withChildren);
        MMapController mapController = (MMapController)this.getModeController().getMapController();
        mapController.insertNode(newNodeModel, (NodeModel)this.getDelegate());
        return new NodeProxy(newNodeModel, this.getScriptContext());
    }

    @Override
    public void delete() {
        MMapController mapController = (MMapController)this.getModeController().getMapController();
        mapController.deleteNode((NodeModel)this.getDelegate());
    }

    @Override
    public Proxy.Attributes getAttributes() {
        return new AttributesProxy((NodeModel)this.getDelegate(), this.getScriptContext());
    }

    @Override
    public Convertible getAt(String attributeName) {
        Object value = this.getAttributes().getFirst(attributeName);
        return ProxyUtils.attributeValueToConvertible((NodeModel)this.getDelegate(), this.getScriptContext(), value);
    }

    @Override
    public Object putAt(String attributeName, Object value) {
        Proxy.Attributes attributes = this.getAttributes();
        if (value == null) {
            int index = attributes.findFirst(attributeName);
            if (index != -1) {
                attributes.remove(index);
            }
        } else {
            attributes.set(attributeName, value);
        }
        return value;
    }

    @Override
    public void setAttributes(Map<String, Object> attributeMap) {
        Proxy.Attributes attributes = this.getAttributes();
        attributes.clear();
        for (Map.Entry<String, Object> entry : attributeMap.entrySet()) {
            attributes.set(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void setDetails(Object details) {
        MTextController textController = (MTextController)TextController.getController();
        if (details == null) {
            textController.setDetailsHidden((NodeModel)this.getDelegate(), false);
            textController.setDetails((NodeModel)this.getDelegate(), null);
        } else {
            textController.setDetails((NodeModel)this.getDelegate(), this.convertConvertibleToHtml(details));
        }
    }

    @Override
    public void setHideDetails(boolean hide) {
        MTextController controller = MTextController.getController();
        controller.setDetailsHidden((NodeModel)this.getDelegate(), hide);
    }

    @Override
    public int getChildPosition(Proxy.Node childNode) {
        NodeModel childNodeModel = (NodeModel)((NodeProxy)childNode).getDelegate();
        return ((NodeModel)this.getDelegate()).getChildPosition(childNodeModel);
    }

    @Override
    public List<Proxy.Node> getChildren() {
        return ProxyUtils.createListOfChildren((NodeModel)this.getDelegate(), this.getScriptContext());
    }

    @Override
    public Proxy.Cloud getCloud() {
        return new CloudProxy(this);
    }

    @Override
    public Collection<Proxy.Connector> getConnectorsIn() {
        return new ConnectorInListProxy(this);
    }

    @Override
    public Collection<Proxy.Connector> getConnectorsOut() {
        return new ConnectorOutListProxy(this);
    }

    @Override
    public Convertible getDetails() {
        String detailsText = DetailTextModel.getDetailTextText((NodeModel)((NodeModel)this.getDelegate()));
        return detailsText == null ? null : new ConvertibleText((NodeModel)this.getDelegate(), this.getScriptContext(), detailsText);
    }

    @Override
    public String getDetailsText() {
        return DetailTextModel.getDetailTextText((NodeModel)((NodeModel)this.getDelegate()));
    }

    @Override
    public boolean getHideDetails() {
        DetailTextModel detailText = DetailTextModel.getDetailText((NodeModel)((NodeModel)this.getDelegate()));
        return detailText != null && detailText.isHidden();
    }

    @Override
    public Proxy.ExternalObject getExternalObject() {
        return new ExternalObjectProxy((NodeModel)this.getDelegate(), this.getScriptContext());
    }

    @Override
    public Proxy.Icons getIcons() {
        return new IconsProxy((NodeModel)this.getDelegate(), this.getScriptContext());
    }

    @Override
    public Proxy.Link getLink() {
        return new LinkProxy((NodeModel)this.getDelegate(), this.getScriptContext());
    }

    @Override
    public Proxy.Reminder getReminder() {
        return new ReminderProxy((NodeModel)this.getDelegate(), this.getScriptContext());
    }

    @Override
    public String getId() {
        return ((NodeModel)this.getDelegate()).createID();
    }

    @Override
    @Deprecated
    public String getNodeID() {
        return this.getId();
    }

    @Override
    public int getNodeLevel(boolean countHidden) {
        return ((NodeModel)this.getDelegate()).getNodeLevel(countHidden);
    }

    public String getPlainNote() {
        String noteText = NoteModel.getNoteText((NodeModel)((NodeModel)this.getDelegate()));
        return noteText == null ? null : HtmlUtils.htmlToPlain((String)noteText);
    }

    @Override
    public String getNoteText() {
        return NoteModel.getNoteText((NodeModel)((NodeModel)this.getDelegate()));
    }

    @Override
    public Convertible getNote() {
        String noteText = this.getNoteText();
        return noteText == null ? null : new ConvertibleNoteText((NodeModel)this.getDelegate(), this.getScriptContext());
    }

    @Override
    public Proxy.Node getParent() {
        NodeModel parentNode = ((NodeModel)this.getDelegate()).getParentNode();
        return parentNode != null ? new NodeProxy(parentNode, this.getScriptContext()) : null;
    }

    @Override
    @Deprecated
    public Proxy.Node getParentNode() {
        return this.getParent();
    }

    @Override
    public List<Proxy.Node> getPathToRoot() {
        return ProxyUtils.createNodeList(Arrays.asList(((NodeModel)this.getDelegate()).getPathToRoot()), this.getScriptContext());
    }

    @Override
    public Proxy.Node getNext() {
        NodeModel node = MapNavigationUtils.findNext((MapController.Direction)MapController.Direction.FORWARD, (NodeModel)((NodeModel)this.getDelegate()), null);
        return node == null ? null : new NodeProxy(node, this.getScriptContext());
    }

    @Override
    public Proxy.Node getPrevious() {
        NodeModel node = MapNavigationUtils.findPrevious((MapController.Direction)MapController.Direction.BACK, (NodeModel)((NodeModel)this.getDelegate()), null);
        return node == null ? null : new NodeProxy(node, this.getScriptContext());
    }

    @Override
    public String getPlainText() {
        return HtmlUtils.htmlToPlain((String)((NodeModel)this.getDelegate()).getText());
    }

    @Override
    @Deprecated
    public String getPlainTextContent() {
        return this.getPlainText();
    }

    @Override
    public Proxy.NodeStyle getStyle() {
        return new NodeStyleProxy((NodeModel)this.getDelegate(), this.getScriptContext());
    }

    @Override
    public boolean hasStyle(String styleName) {
        return NodeStyleProxy.hasStyle((NodeModel)this.getDelegate(), styleName);
    }

    @Override
    public String getText() {
        return ((NodeModel)this.getDelegate()).getText();
    }

    @Override
    public String getTransformedText() {
        TextController textController = TextController.getController();
        return textController.getTransformedTextNoThrow((NodeModel)this.getDelegate());
    }

    @Override
    public String getShortText() {
        TextController textController = TextController.getController();
        return textController.getShortText((NodeModel)this.getDelegate());
    }

    @Override
    public String getDisplayedText() {
        if (this.isMinimized()) {
            return this.getShortText();
        }
        return this.getTransformedText();
    }

    @Override
    public boolean isMinimized() {
        TextController textController = TextController.getController();
        return textController.isMinimized((NodeModel)this.getDelegate());
    }

    @Override
    public Object getObject() {
        Object userObject = ((NodeModel)this.getDelegate()).getUserObject();
        if (userObject instanceof IFormattedObject) {
            return ((IFormattedObject)userObject).getObject();
        }
        return userObject;
    }

    @Override
    public byte[] getBinary() {
        return Base64Coding.decode64((String)((NodeModel)this.getDelegate()).getText().replaceAll("\\s", ""));
    }

    @Override
    public String getFormat() {
        NodeModel nodeModel = (NodeModel)this.getDelegate();
        String format = TextController.getController().getNodeFormat(nodeModel);
        if (format == null && nodeModel.getUserObject() instanceof IFormattedObject) {
            return ((IFormattedObject)nodeModel.getUserObject()).getPattern();
        }
        return format;
    }

    @Override
    public Convertible getTo() {
        return ProxyUtils.nodeModelToConvertible((NodeModel)this.getDelegate(), this.getScriptContext());
    }

    @Override
    public Convertible getValue() {
        return this.getTo();
    }

    @Override
    public boolean isDescendantOf(Proxy.Node otherNode) {
        NodeModel otherNodeModel = (NodeModel)((NodeProxy)otherNode).getDelegate();
        NodeModel node = (NodeModel)this.getDelegate();
        do {
            if (!node.equals(otherNodeModel)) continue;
            return true;
        } while ((node = node.getParentNode()) != null);
        return false;
    }

    @Override
    public boolean isFolded() {
        return ((NodeModel)this.getDelegate()).isFolded();
    }

    @Override
    public boolean isFree() {
        FreeNode freeNode = (FreeNode)Controller.getCurrentModeController().getExtension(FreeNode.class);
        return freeNode.isActive((NodeModel)this.getDelegate());
    }

    @Override
    public boolean isLeaf() {
        return ((NodeModel)this.getDelegate()).isLeaf();
    }

    @Override
    public boolean isLeft() {
        return ((NodeModel)this.getDelegate()).isLeft();
    }

    @Override
    public boolean isRoot() {
        return ((NodeModel)this.getDelegate()).isRoot();
    }

    @Override
    public boolean isVisible() {
        return ((NodeModel)this.getDelegate()).isVisible();
    }

    @Override
    public void moveTo(Proxy.Node parentNodeProxy) {
        NodeModel parentNode = (NodeModel)((NodeProxy)parentNodeProxy).getDelegate();
        NodeModel movedNode = (NodeModel)this.getDelegate();
        MMapController mapController = (MMapController)this.getModeController().getMapController();
        mapController.moveNodeAsChild(movedNode, parentNode, movedNode.isLeft(), parentNode.isLeft() != movedNode.isLeft());
    }

    @Override
    public void moveTo(Proxy.Node parentNodeProxy, int position) {
        NodeModel parentNode = (NodeModel)((NodeProxy)parentNodeProxy).getDelegate();
        NodeModel movedNode = (NodeModel)this.getDelegate();
        MMapController mapController = (MMapController)this.getModeController().getMapController();
        ((FreeNode)Controller.getCurrentModeController().getExtension(FreeNode.class)).undoableDeactivateHook(movedNode);
        mapController.moveNode(movedNode, parentNode, position, ((NodeModel)this.getDelegate()).isLeft(), parentNode.isLeft() != movedNode.isLeft());
    }

    @Override
    public void removeConnector(Proxy.Connector connectorToBeRemoved) {
        ConnectorProxy connectorProxy = (ConnectorProxy)connectorToBeRemoved;
        ConnectorModel link = connectorProxy.getConnector();
        MLinkController linkController = (MLinkController)LinkController.getController();
        linkController.removeArrowLink((NodeLinkModel)link);
    }

    @Override
    public void setFolded(boolean folded) {
        MMapController mapController = (MMapController)this.getModeController().getMapController();
        mapController.setFolded((NodeModel)this.getDelegate(), folded);
    }

    @Override
    public void setFree(boolean free) {
        FreeNode freeNode = (FreeNode)Controller.getCurrentModeController().getExtension(FreeNode.class);
        if (free != freeNode.isActive((NodeModel)this.getDelegate())) {
            freeNode.undoableToggleHook((NodeModel)this.getDelegate());
        }
    }

    @Override
    public void setMinimized(boolean shortened) {
        MTextController textController = (MTextController)TextController.getController();
        textController.setIsMinimized((NodeModel)this.getDelegate(), shortened);
    }

    @Override
    public void setNote(Object value) {
        MNoteController noteController = (MNoteController)NoteController.getController();
        noteController.setNoteText((NodeModel)this.getDelegate(), this.convertConvertibleToHtml(value));
    }

    private String convertConvertibleToHtml(Object value) {
        if (value == null) {
            return null;
        }
        String text = Convertible.toString(value);
        if (text == null) {
            return null;
        }
        return HtmlUtils.isHtmlNode((String)text) ? text : HtmlUtils.plainToHTML((String)text);
    }

    @Override
    public void setNoteText(String text) {
        MNoteController noteController = (MNoteController)NoteController.getController();
        noteController.setNoteText((NodeModel)this.getDelegate(), text);
    }

    @Override
    public void setText(Object value) {
        if (value instanceof String) {
            MTextController textController = (MTextController)TextController.getController();
            textController.setNodeText((NodeModel)this.getDelegate(), (String)value);
        } else {
            this.setObject(value);
        }
    }

    @Override
    public void setObject(Object object) {
        MTextController textController = (MTextController)TextController.getController();
        textController.setNodeObject((NodeModel)this.getDelegate(), ProxyUtils.transformObject(object, null));
    }

    @Override
    public void setDateTime(Date date) {
        MTextController textController = (MTextController)TextController.getController();
        textController.setNodeObject((NodeModel)this.getDelegate(), (Object)ProxyUtils.createDefaultFormattedDateTime(date));
    }

    @Override
    public void setBinary(byte[] data) {
        this.setObject(Base64Coding.encode64((byte[])data).replaceAll("(.{74})", "$1\n"));
    }

    @Override
    public void setFormat(String format) {
        MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
        styleController.setNodeFormat((NodeModel)this.getDelegate(), format);
    }

    @Override
    public void setLeft(boolean isLeft) {
        ((NodeModel)this.getDelegate()).setLeft(isLeft);
    }

    @Override
    public Proxy.Map getMap() {
        MapModel map = ((NodeModel)this.getDelegate()).getMap();
        return map != null ? new MapProxy(map, this.getScriptContext()) : null;
    }

    @Override
    @Deprecated
    public List<Proxy.Node> find(ICondition condition) {
        NodeModel delegate = (NodeModel)this.getDelegate();
        if (this.getScriptContext() != null) {
            this.getScriptContext().accessBranch(delegate);
        }
        return ProxyUtils.find(condition, delegate, this.getScriptContext());
    }

    @Override
    public List<Proxy.Node> find(Closure<Boolean> closure) {
        NodeModel delegate = (NodeModel)this.getDelegate();
        if (this.getScriptContext() != null) {
            this.getScriptContext().accessBranch(delegate);
        }
        return ProxyUtils.find(closure, delegate, this.getScriptContext());
    }

    @Override
    public List<Proxy.Node> findAll() {
        NodeModel delegate = (NodeModel)this.getDelegate();
        if (this.getScriptContext() != null) {
            this.getScriptContext().accessBranch(delegate);
        }
        return ProxyUtils.findAll(delegate, this.getScriptContext(), true);
    }

    @Override
    public List<Proxy.Node> findAllDepthFirst() {
        NodeModel delegate = (NodeModel)this.getDelegate();
        if (this.getScriptContext() != null) {
            this.getScriptContext().accessBranch(delegate);
        }
        return ProxyUtils.findAll(delegate, this.getScriptContext(), false);
    }

    @Override
    public Date getLastModifiedAt() {
        return ((NodeModel)this.getDelegate()).getHistoryInformation().getLastModifiedAt();
    }

    @Override
    public void setLastModifiedAt(final Date date) {
        final Date oldDate = ((NodeModel)this.getDelegate()).getHistoryInformation().getLastModifiedAt();
        IActor actor = new IActor(){

            public void act() {
                ((NodeModel)NodeProxy.this.getDelegate()).getHistoryInformation().setLastModifiedAt(date);
            }

            public String getDescription() {
                return "setLastModifiedAt";
            }

            public void undo() {
                ((NodeModel)NodeProxy.this.getDelegate()).getHistoryInformation().setLastModifiedAt(oldDate);
            }
        };
        this.getModeController().execute(actor, ((NodeModel)this.getDelegate()).getMap());
    }

    @Override
    public Date getCreatedAt() {
        return ((NodeModel)this.getDelegate()).getHistoryInformation().getCreatedAt();
    }

    @Override
    public void setCreatedAt(final Date date) {
        final Date oldDate = ((NodeModel)this.getDelegate()).getHistoryInformation().getCreatedAt();
        IActor actor = new IActor(){

            public void act() {
                ((NodeModel)NodeProxy.this.getDelegate()).getHistoryInformation().setCreatedAt(date);
            }

            public String getDescription() {
                return "setCreatedAt";
            }

            public void undo() {
                ((NodeModel)NodeProxy.this.getDelegate()).getHistoryInformation().setCreatedAt(oldDate);
            }
        };
        this.getModeController().execute(actor, ((NodeModel)this.getDelegate()).getMap());
    }

    public Number and(Number number) {
        return NumberMath.and((Number)this.getTo().getNum0(), (Number)number);
    }

    public Number and(Proxy.Node node) {
        return NumberMath.and((Number)this.getTo().getNum0(), (Number)node.getTo().getNum0());
    }

    public Number div(Number number) {
        return NumberMath.divide((Number)this.getTo().getNum0(), (Number)number);
    }

    public Number div(Proxy.Node node) {
        return NumberMath.divide((Number)this.getTo().getNum0(), (Number)node.getTo().getNum0());
    }

    public Number minus(Number number) {
        return NumberMath.subtract((Number)this.getTo().getNum0(), (Number)number);
    }

    public Number minus(Proxy.Node node) {
        return NumberMath.subtract((Number)this.getTo().getNum0(), (Number)node.getTo().getNum0());
    }

    public Number mod(Number number) {
        return NumberMath.mod((Number)this.getTo().getNum0(), (Number)number);
    }

    public Number mod(Proxy.Node node) {
        return NumberMath.mod((Number)this.getTo().getNum0(), (Number)node.getTo().getNum0());
    }

    public Number multiply(Number number) {
        return NumberMath.multiply((Number)this.getTo().getNum0(), (Number)number);
    }

    public Number multiply(Proxy.Node node) {
        return NumberMath.multiply((Number)this.getTo().getNum0(), (Number)node.getTo().getNum0());
    }

    public Number or(Number number) {
        return NumberMath.or((Number)this.getTo().getNum0(), (Number)number);
    }

    public Number or(Proxy.Node node) {
        return NumberMath.or((Number)this.getTo().getNum0(), (Number)node.getTo().getNum0());
    }

    public Number plus(Number number) {
        return NumberMath.add((Number)this.getTo().getNum0(), (Number)number);
    }

    public Number plus(Proxy.Node node) {
        return NumberMath.add((Number)this.getTo().getNum0(), (Number)node.getTo().getNum0());
    }

    public Number power(Number number) {
        return DefaultGroovyMethods.power((Number)this.getTo().getNum0(), (Number)number);
    }

    public Number power(Proxy.Node node) {
        return DefaultGroovyMethods.power((Number)this.getTo().getNum0(), (Number)node.getTo().getNum0());
    }

    public Number xor(Number number) {
        return NumberMath.xor((Number)this.getTo().getNum0(), (Number)number);
    }

    public Number xor(Proxy.Node node) {
        return NumberMath.xor((Number)this.getTo().getNum0(), (Number)node.getTo().getNum0());
    }

    public Number negative() {
        return NumberMath.subtract((Number)ZERO, (Number)this.getTo().getNum0());
    }

    public Number next() {
        return NumberMath.add((Number)this.getTo().getNum0(), (Number)ONE);
    }

    public Number positive() {
        return this.getTo().getNum0();
    }

    public Number previous() {
        return NumberMath.subtract((Number)this.getTo().getNum0(), (Number)ONE);
    }

    @Override
    public boolean hasEncryption() {
        return this.getEncryptionModel() != null;
    }

    @Override
    public boolean isEncrypted() {
        EncryptionModel encryptionModel = this.getEncryptionModel();
        return encryptionModel != null && !encryptionModel.isAccessible();
    }

    @Override
    public void encrypt(String password) {
        if (!this.isEncrypted()) {
            this.getEncryptionController().toggleCryptState((NodeModel)this.getDelegate(), this.makePasswordStrategy(password));
        }
    }

    @Override
    public void decrypt(String password) {
        if (this.isEncrypted()) {
            this.getEncryptionController().toggleCryptState((NodeModel)this.getDelegate(), this.makePasswordStrategy(password));
        }
    }

    @Override
    public void removeEncryption(String password) {
        this.getEncryptionController().removeEncryption((NodeModel)this.getDelegate(), this.makePasswordStrategy(password));
    }

    private PasswordStrategy makePasswordStrategy(final String password) {
        return new PasswordStrategy(){

            public StringBuilder getPassword() {
                return new StringBuilder(password);
            }

            public StringBuilder getPasswordWithConfirmation() {
                return this.getPassword();
            }

            public void onWrongPassword() {
                LogUtils.info((String)("wrong password for node " + NodeProxy.this.getDelegate()));
                NodeProxy.this.setStatusInfo(TextUtils.getText((String)"accessories/plugins/EncryptNode.properties_wrong_password"));
            }

            public boolean isCancelled() {
                return false;
            }
        };
    }

    private void setStatusInfo(String text) {
        ViewController viewController = Controller.getCurrentController().getViewController();
        viewController.out(text);
    }

    private MEncryptionController getEncryptionController() {
        return (MEncryptionController)Controller.getCurrentModeController().getExtension(EncryptionController.class);
    }

    private EncryptionModel getEncryptionModel() {
        return EncryptionModel.getModel((NodeModel)((NodeModel)this.getDelegate()));
    }
}

