/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import groovy.lang.Closure;
import java.awt.Color;
import java.io.File;
import java.util.Map;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.AbstractProxy;
import org.freeplane.plugin.script.proxy.NodeProxy;
import org.freeplane.plugin.script.proxy.PropertiesProxy;
import org.freeplane.plugin.script.proxy.Proxy;
import org.freeplane.plugin.script.proxy.ProxyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapProxy
extends AbstractProxy<MapModel>
implements Proxy.Map {
    public MapProxy(MapModel map, ScriptContext scriptContext) {
        super(map, scriptContext);
    }

    @Override
    public Proxy.Node node(String id) {
        NodeModel node = ((MapModel)this.getDelegate()).getNodeForID(id);
        return node != null ? new NodeProxy(node, this.getScriptContext()) : null;
    }

    @Override
    public Proxy.Node getRoot() {
        NodeModel rootNode = ((MapModel)this.getDelegate()).getRootNode();
        return new NodeProxy(rootNode, this.getScriptContext());
    }

    @Override
    @Deprecated
    public Proxy.Node getRootNode() {
        return this.getRoot();
    }

    @Override
    public File getFile() {
        return ((MapModel)this.getDelegate()).getFile();
    }

    @Override
    public String getName() {
        IMapViewManager mapViewManager = this.getMapViewManager();
        for (Map.Entry map : mapViewManager.getMaps().entrySet()) {
            if (!((MapModel)map.getValue()).equals(this.getDelegate())) continue;
            return (String)map.getKey();
        }
        return null;
    }

    @Override
    public boolean isSaved() {
        return ((MapModel)this.getDelegate()).isSaved();
    }

    @Override
    public Color getBackgroundColor() {
        MapStyle mapStyle = (MapStyle)Controller.getCurrentModeController().getExtension(MapStyle.class);
        MapStyleModel model = (MapStyleModel)mapStyle.getMapHook();
        if (model != null) {
            return model.getBackgroundColor();
        }
        String colorPropertyString = ResourceController.getResourceController().getProperty("standardbackgroundcolor");
        Color defaultBgColor = ColorUtils.stringToColor((String)colorPropertyString);
        return defaultBgColor;
    }

    @Override
    public String getBackgroundColorCode() {
        return ColorUtils.colorToString((Color)this.getBackgroundColor());
    }

    @Override
    public boolean close(boolean force, boolean allowInteraction) {
        if (!(((MapModel)this.getDelegate()).isSaved() || force || allowInteraction)) {
            throw new RuntimeException("will not close an unsaved map without being told so");
        }
        IMapViewManager mapViewManager = this.getMapViewManager();
        this.changeToThisMap(mapViewManager);
        return mapViewManager.close(force);
    }

    private void changeToThisMap(IMapViewManager mapViewManager) {
        String mapKey = this.findMapViewKey(mapViewManager);
        if (mapKey == null) {
            throw new RuntimeException("map " + this.getDelegate() + " does not seem to be opened");
        }
        mapViewManager.changeToMapView(mapKey);
    }

    private IMapViewManager getMapViewManager() {
        return this.getModeController().getController().getMapViewManager();
    }

    private String findMapViewKey(IMapViewManager mapViewManager) {
        for (Map.Entry entry : mapViewManager.getMaps().entrySet()) {
            if (!((MapModel)entry.getValue()).equals(this.getDelegate())) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    @Override
    public boolean save(boolean allowInteraction) {
        if (!((MapModel)this.getDelegate()).isSaved() && ((MapModel)this.getDelegate()).getURL() == null && !allowInteraction) {
            throw new RuntimeException("no url set for map " + this.getDelegate());
        }
        this.changeToThisMap(this.getMapViewManager());
        return this.getModeController().save();
    }

    @Override
    public void setName(String title) {
        this.changeToThisMap(this.getMapViewManager());
        Controller.getCurrentController().getMapViewManager().getMapViewComponent().setName(title);
    }

    @Override
    public void setSaved(boolean isSaved) {
        Controller.getCurrentModeController().getMapController().setSaved((MapModel)this.getDelegate(), isSaved);
    }

    @Override
    public void setBackgroundColor(Color color) {
        MapStyle mapStyle = (MapStyle)Controller.getCurrentModeController().getExtension(MapStyle.class);
        MapStyleModel model = (MapStyleModel)mapStyle.getMapHook();
        mapStyle.setBackgroundColor(model, color);
    }

    @Override
    public void setBackgroundColorCode(String rgbString) {
        this.setBackgroundColor(ColorUtils.stringToColor((String)rgbString));
    }

    @Override
    public void setFilter(Closure<Boolean> closure) {
        FilterController filterController = FilterController.getCurrentFilterController();
        if (closure == null) {
            filterController.applyNoFiltering();
        } else {
            Filter filter = new Filter(ProxyUtils.createCondition(closure, this.getScriptContext()), false, false, true);
            filterController.applyFilter(filter, (MapModel)this.getDelegate(), true);
        }
    }

    @Override
    public void filter(Closure<Boolean> closure) {
        this.setFilter(closure);
    }

    @Override
    public void setFilter(boolean showAncestors, boolean showDescendants, Closure<Boolean> closure) {
        FilterController filterController = FilterController.getCurrentFilterController();
        if (closure == null) {
            filterController.applyNoFiltering();
        } else {
            Filter filter = new Filter(ProxyUtils.createCondition(closure, this.getScriptContext()), showAncestors, showDescendants, true);
            filterController.applyFilter(filter, (MapModel)this.getDelegate(), true);
        }
    }

    @Override
    public void filter(boolean showAncestors, boolean showDescendants, Closure<Boolean> closure) {
        this.setFilter(showAncestors, showDescendants, closure);
    }

    @Override
    public void redoFilter() {
        FilterController.getCurrentFilterController().redo();
    }

    @Override
    public void undoFilter() {
        FilterController.getCurrentFilterController().undo();
    }

    @Override
    public Proxy.Properties getStorage() {
        return new PropertiesProxy((MapModel)this.getDelegate(), this.getScriptContext());
    }
}

