/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import java.util.HashMap;
import java.util.LinkedHashMap;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.script.ExecuteScriptException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormulaCache
implements IExtension {
    private HashMap<String, LinkedHashMap<String, Object>> cache = new HashMap();

    public Object get(NodeModel nodeModel, String text) {
        LinkedHashMap<String, Object> cacheEntry = this.cache.get(nodeModel.getID());
        if (cacheEntry == null) {
            return null;
        }
        Object object = cacheEntry.get(text);
        if (object instanceof ExecuteScriptException) {
            throw (ExecuteScriptException)object;
        }
        return object;
    }

    public void put(NodeModel nodeModel, String text, Object value) {
        this.getOrAdd(nodeModel).put(text, value);
    }

    private LinkedHashMap<String, Object> getOrAdd(NodeModel node) {
        LinkedHashMap<String, Object> cacheEntry = this.cache.get(node.getID());
        if (cacheEntry == null) {
            cacheEntry = new LinkedHashMap(8);
            this.cache.put(node.getID(), cacheEntry);
        }
        return cacheEntry;
    }

    public void markAsDirtyIfFormulaNode(NodeModel node) {
        LinkedHashMap<String, Object> entry = this.cache.get(node.getID());
        if (entry != null) {
            entry.clear();
        }
    }
}

