/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import java.io.File;
import java.net.URI;
import java.net.URL;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.ModeController;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.AbstractProxy;
import org.freeplane.plugin.script.proxy.Proxy;
import org.freeplane.view.swing.features.filepreview.ExternalResource;
import org.freeplane.view.swing.features.filepreview.ViewerController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExternalObjectProxy
extends AbstractProxy<NodeModel>
implements Proxy.ExternalObject {
    ExternalObjectProxy(NodeModel delegate, ScriptContext scriptContext) {
        super(delegate, scriptContext);
    }

    private ExternalResource getExternalObjectModel() {
        return (ExternalResource)((NodeModel)this.getDelegate()).getExtension(ExternalResource.class);
    }

    @Override
    public String getUri() {
        ExternalResource externalObject = this.getExternalObjectModel();
        URI uri = externalObject == null ? null : externalObject.getUri();
        return uri == null ? null : uri.toString();
    }

    @Override
    @Deprecated
    public String getURI() {
        return this.getUri();
    }

    private ViewerController getViewerController() {
        return (ViewerController)this.getModeController().getExtension(ViewerController.class);
    }

    @Override
    public float getZoom() {
        ExternalResource externalObject = this.getExternalObjectModel();
        return externalObject == null ? 1.0f : externalObject.getZoom();
    }

    @Override
    public void setUri(String target) {
        if (!this.removeIfTargetIsNull(target)) {
            this.setUriImpl(this.convertToUri(target));
        }
    }

    public void setUri(Object target) {
        if (!this.removeIfTargetIsNull(target)) {
            this.setUriImpl(this.convertToUri(target));
        }
    }

    @Override
    public void setFile(File target) {
        if (!this.removeIfTargetIsNull(target)) {
            this.setUriImpl(this.convertToUri(target));
        }
    }

    private URI convertToUri(Object target) {
        try {
            if (target instanceof URI) {
                return (URI)target;
            }
            if (target instanceof String) {
                return new URL((String)target).toURI();
            }
            if (target instanceof File) {
                return ((File)target).toURI();
            }
            if (target instanceof URL) {
                return ((URL)target).toURI();
            }
            LogUtils.warn((String)("cannot convert to an uri: " + target));
            return null;
        }
        catch (Exception e) {
            LogUtils.warn((String)("cannot convert to an uri: " + target), (Throwable)e);
            return null;
        }
    }

    private boolean removeIfTargetIsNull(Object target) {
        if (target == null && this.getExternalObjectModel() != null) {
            this.getViewerController().undoableToggleHook((NodeModel)this.getDelegate(), null);
            return true;
        }
        return false;
    }

    private void setUriImpl(URI uri) {
        if (uri != null) {
            this.getViewerController().paste(uri, (NodeModel)this.getDelegate());
        }
    }

    @Override
    @Deprecated
    public void setURI(String uri) {
        this.setUri(uri);
    }

    @Override
    public void setZoom(float zoom) {
        ExternalResource externalObject = this.getExternalObjectModel();
        if (externalObject != null) {
            this.getViewerController().setZoom((ModeController)this.getModeController(), ((NodeModel)this.getDelegate()).getMap(), externalObject, zoom);
        }
    }

    public boolean asBoolean() {
        return this.getExternalObjectModel() != null;
    }
}

