/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang.NotImplementedException;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.format.FormattedDate;
import org.freeplane.plugin.script.proxy.ConversionException;

public class Convertible
extends GroovyObjectSupport {
    private final String text;

    public Convertible(String text) {
        this.text = text;
    }

    public Convertible(Object text) {
        this.text = Convertible.toString(text);
    }

    public Number getNum() throws ConversionException {
        try {
            return TextUtils.toNumber((String)this.text);
        }
        catch (NumberFormatException e) {
            throw new ConversionException("not a number: '" + this.text + "'", e);
        }
    }

    public Number getNum0() {
        try {
            Number result = this.getNum();
            return result == null ? (Number)0L : (Number)result;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public String getString() {
        return this.text;
    }

    public String getText() {
        return this.text;
    }

    public String getPlain() {
        return this.text == null ? null : HtmlUtils.htmlToPlain((String)this.text);
    }

    public Date getDate() throws ConversionException {
        return this.text == null ? null : Convertible.parseDate(this.text);
    }

    private static Date parseDate(String text) throws ConversionException {
        FormattedDate date = FormattedDate.toDateISO((String)text);
        if (date != null) {
            return date;
        }
        throw new ConversionException("not a date: " + text);
    }

    public Calendar getCalendar() throws ConversionException {
        if (this.text == null) {
            return null;
        }
        Date date = Convertible.parseDate(this.text);
        GregorianCalendar result = new GregorianCalendar(0, 0, 0);
        result.setTime(date);
        return result;
    }

    public URI getUri() throws ConversionException {
        if (this.text == null) {
            return null;
        }
        try {
            if (TextUtils.matchUriPattern((String)this.text)) {
                return new URI(this.text);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        throw new ConversionException("not an uri: " + this.text);
    }

    public Object getObject() {
        if (this.text == null) {
            return null;
        }
        try {
            return this.getNum();
        }
        catch (ConversionException e1) {
            try {
                return this.getDate();
            }
            catch (ConversionException e2) {
                try {
                    return this.getUri();
                }
                catch (ConversionException e3) {
                    return this.text;
                }
            }
        }
    }

    public Convertible getTo() {
        return this;
    }

    public boolean isNum() {
        return TextUtils.isNumber((String)this.text);
    }

    public boolean isDate() {
        return FormattedDate.isDate((String)this.text);
    }

    public Object getProperty(String property) {
        try {
            if (property.equals("num")) {
                return this.getNum();
            }
            if (property.equals("date")) {
                return this.getDate();
            }
            if (property.equals("uri")) {
                return this.getUri();
            }
            return super.getProperty(property);
        }
        catch (ConversionException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            return InvokerHelper.getMetaClass(String.class).getProperty((Object)this.text, property);
        }
    }

    public Object invokeMethod(String name, Object args) {
        try {
            return super.invokeMethod(name, args);
        }
        catch (MissingMethodException mme) {
            return InvokerHelper.getMetaClass(String.class).invokeMethod((Object)this.text, name, args);
        }
    }

    public static String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().equals(String.class)) {
            return (String)value;
        }
        if (value instanceof Date) {
            return FormattedDate.toStringISO((Date)((Date)value));
        }
        if (value instanceof Calendar) {
            return FormattedDate.toStringISO((Date)((Calendar)value).getTime());
        }
        return value.toString();
    }

    public int compareTo(Object string) {
        if (string == null) {
            return this.text == null ? 0 : 1;
        }
        if (string.getClass() == String.class) {
            return this.text.compareTo((String)string);
        }
        return 1;
    }

    public int compareTo(Convertible convertible) {
        if (convertible == null || convertible.getText() == null) {
            return this.text == null ? 0 : 1;
        }
        return this.text.compareTo(convertible.getText());
    }

    public int hashCode() {
        return this.text == null ? 0 : this.text.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return this.text == null;
        }
        if (obj.getClass() == String.class && this.text != null) {
            return this.text.equals(obj);
        }
        if (!(obj instanceof Convertible)) {
            return false;
        }
        Convertible other = (Convertible)((Object)obj);
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public String toString() {
        return this.text;
    }

    public void setProperty(String property, Object newValue) {
        throw new NotImplementedException("Convertibles are immutable; property to be changed: " + property);
    }

    public boolean getBool() {
        return Boolean.parseBoolean(this.text);
    }

    public boolean asBoolean() {
        return this.text != null && this.text.length() > 0;
    }
}

