/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import groovy.lang.Closure;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.IEditHandler;
import org.freeplane.core.undo.IUndoHandler;
import org.freeplane.core.util.FreeplaneIconUtils;
import org.freeplane.core.util.FreeplaneVersion;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.export.mindmapmode.ExportController;
import org.freeplane.features.export.mindmapmode.IExportEngine;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapModel;
import org.freeplane.features.mapio.MapIO;
import org.freeplane.features.mapio.mindmapmode.MMapIO;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.ui.ViewController;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.MapProxy;
import org.freeplane.plugin.script.proxy.NodeProxy;
import org.freeplane.plugin.script.proxy.Proxy;
import org.freeplane.plugin.script.proxy.ProxyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ControllerProxy
implements Proxy.Controller {
    private final ScriptContext scriptContext;

    public ControllerProxy(ScriptContext scriptContext) {
        this.scriptContext = scriptContext;
    }

    @Override
    public void centerOnNode(Proxy.Node center) {
        NodeModel nodeModel = (NodeModel)((NodeProxy)center).getDelegate();
        Controller.getCurrentController().getSelection().centerNode(nodeModel);
    }

    @Override
    public void edit(Proxy.Node node) {
        this.editImpl(node, true);
    }

    @Override
    public void editInPopup(Proxy.Node node) {
        this.editImpl(node, false);
    }

    private void editImpl(Proxy.Node node, boolean editInline) {
        NodeModel nodeModel = (NodeModel)((NodeProxy)node).getDelegate();
        Controller.getCurrentController().getSelection().selectAsTheOnlyOneSelected(nodeModel);
        ((MTextController)TextController.getController()).edit(IEditHandler.FirstAction.EDIT_CURRENT, !editInline);
    }

    @Override
    public Proxy.Node getSelected() {
        if (this.scriptContext != null) {
            this.scriptContext.accessAll();
        }
        return new NodeProxy(Controller.getCurrentController().getSelection().getSelected(), this.scriptContext);
    }

    @Override
    public List<Proxy.Node> getSelecteds() {
        if (this.scriptContext != null) {
            this.scriptContext.accessAll();
        }
        return ProxyUtils.createNodeList(Controller.getCurrentController().getSelection().getOrderedSelection(), this.scriptContext);
    }

    @Override
    public List<Proxy.Node> getSortedSelection(boolean differentSubtrees) {
        if (this.scriptContext != null) {
            this.scriptContext.accessAll();
        }
        return ProxyUtils.createNodeList(Controller.getCurrentController().getSelection().getSortedSelection(differentSubtrees), this.scriptContext);
    }

    @Override
    public void select(Proxy.Node toSelect) {
        if (toSelect != null) {
            NodeModel nodeModel = (NodeModel)((NodeProxy)toSelect).getDelegate();
            Controller.getCurrentModeController().getMapController().displayNode(nodeModel);
            Controller.getCurrentController().getSelection().selectAsTheOnlyOneSelected(nodeModel);
        }
    }

    @Override
    public void selectBranch(Proxy.Node branchRoot) {
        if (branchRoot != null) {
            NodeModel nodeModel = (NodeModel)((NodeProxy)branchRoot).getDelegate();
            Controller.getCurrentModeController().getMapController().displayNode(nodeModel);
            Controller.getCurrentController().getSelection().selectBranch(nodeModel, false);
        }
    }

    @Override
    public void selectMultipleNodes(List<Proxy.Node> toSelect) {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        Iterator<Proxy.Node> it = toSelect.iterator();
        if (!it.hasNext()) {
            return;
        }
        selection.selectAsTheOnlyOneSelected((NodeModel)((NodeProxy)it.next()).getDelegate());
        while (it.hasNext()) {
            NodeModel nodeModel = (NodeModel)((NodeProxy)it.next()).getDelegate();
            Controller.getCurrentController().getSelection().toggleSelected(nodeModel);
        }
    }

    @Override
    public void deactivateUndo() {
        MapModel map = Controller.getCurrentController().getMap();
        if (map instanceof MapModel) {
            MModeController modeController = (MModeController)Controller.getCurrentModeController();
            modeController.deactivateUndo((MMapModel)map);
        }
    }

    @Override
    public void undo() {
        MapModel map = Controller.getCurrentController().getMap();
        IUndoHandler undoHandler = (IUndoHandler)map.getExtension(IUndoHandler.class);
        undoHandler.undo();
    }

    @Override
    public void redo() {
        MapModel map = Controller.getCurrentController().getMap();
        IUndoHandler undoHandler = (IUndoHandler)map.getExtension(IUndoHandler.class);
        undoHandler.redo();
    }

    @Override
    public void setStatusInfo(String info) {
        ViewController viewController = this.getViewController();
        viewController.out(info);
    }

    private ViewController getViewController() {
        return Controller.getCurrentController().getViewController();
    }

    private IMapViewManager getMapViewManager() {
        return Controller.getCurrentController().getMapViewManager();
    }

    @Override
    public void setStatusInfo(String infoPanelKey, String info) {
        ViewController viewController = this.getViewController();
        viewController.addStatusInfo(infoPanelKey, info, null);
    }

    @Override
    public void setStatusInfo(String infoPanelKey, String info, String iconKey) {
        ViewController viewController = this.getViewController();
        viewController.addStatusInfo(infoPanelKey, info, FreeplaneIconUtils.createStandardIcon((String)iconKey));
    }

    @Override
    @Deprecated
    public void setStatusInfo(String infoPanelKey, Icon icon) {
        ViewController viewController = this.getViewController();
        viewController.addStatusInfo(infoPanelKey, null, icon);
    }

    @Override
    public FreeplaneVersion getFreeplaneVersion() {
        return FreeplaneVersion.getVersion();
    }

    @Override
    public File getUserDirectory() {
        return new File(ResourceController.getResourceController().getFreeplaneUserDirectory());
    }

    @Override
    @Deprecated
    public List<Proxy.Node> find(ICondition condition) {
        if (this.scriptContext != null) {
            this.scriptContext.accessAll();
        }
        return ProxyUtils.find(condition, Controller.getCurrentController().getMap().getRootNode(), this.scriptContext);
    }

    @Override
    public List<Proxy.Node> find(Closure<Boolean> closure) {
        if (this.scriptContext != null) {
            this.scriptContext.accessAll();
        }
        return ProxyUtils.find(closure, Controller.getCurrentController().getMap().getRootNode(), this.scriptContext);
    }

    @Override
    public List<Proxy.Node> findAll() {
        if (this.scriptContext != null) {
            this.scriptContext.accessAll();
        }
        return ProxyUtils.findAll(Controller.getCurrentController().getMap().getRootNode(), this.scriptContext, true);
    }

    @Override
    public List<Proxy.Node> findAllDepthFirst() {
        if (this.scriptContext != null) {
            this.scriptContext.accessAll();
        }
        return ProxyUtils.findAll(Controller.getCurrentController().getMap().getRootNode(), this.scriptContext, false);
    }

    @Override
    public Proxy.Map newMap() {
        MapModel oldMap = Controller.getCurrentController().getMap();
        MMapIO mapIO = (MMapIO)Controller.getCurrentModeController().getExtension(MapIO.class);
        MapModel newMap = mapIO.newMapFromDefaultTemplate();
        this.restartTransaction(oldMap, newMap);
        return new MapProxy(newMap, this.scriptContext);
    }

    @Override
    public Proxy.Map newMap(URL url) {
        try {
            MapModel oldMap = Controller.getCurrentController().getMap();
            Controller.getCurrentModeController().getMapController().newMap(url);
            IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
            String key = mapViewManager.checkIfFileIsAlreadyOpened(url);
            if (key == null || !mapViewManager.tryToChangeToMapView(key)) {
                throw new RuntimeException("map " + url + " does not seem to be opened");
            }
            MapModel newMap = mapViewManager.getModel();
            this.restartTransaction(oldMap, newMap);
            return new MapProxy(newMap, this.scriptContext);
        }
        catch (Exception e) {
            throw new RuntimeException("error on newMap", e);
        }
    }

    private void restartTransaction(MapModel oldMap, MapModel newmap) {
        IUndoHandler oldUndoHandler = (IUndoHandler)oldMap.getExtension(IUndoHandler.class);
        IUndoHandler newUndoHandler = (IUndoHandler)newmap.getExtension(IUndoHandler.class);
        int transactionLevel = oldUndoHandler.getTransactionLevel();
        if (transactionLevel == 0) {
            return;
        }
        if (transactionLevel == 1) {
            oldUndoHandler.commit();
            newUndoHandler.startTransaction();
            return;
        }
        throw new RuntimeException("can not create map inside transaction");
    }

    @Override
    public float getZoom() {
        return this.getMapViewManager().getZoom();
    }

    @Override
    public void setZoom(float ratio) {
        this.getMapViewManager().setZoom(ratio);
    }

    @Override
    public boolean isInteractive() {
        return !Boolean.parseBoolean(System.getProperty("nonInteractive"));
    }

    @Override
    public List<String> getExportTypeDescriptions() {
        ArrayList<String> list = new ArrayList<String>();
        for (FileFilter fileFilter : ExportController.getContoller().getFileFilters()) {
            list.add(fileFilter.getDescription());
        }
        return list;
    }

    @Override
    public void export(Proxy.Map map, File destFile, String exportTypeDescription, boolean overwriteExisting) {
        FileFilter filter = this.findExportFileFilterByDescription(exportTypeDescription);
        if (filter == null) {
            throw new IllegalArgumentException("no export defined for '" + exportTypeDescription + "'");
        }
        if (!overwriteExisting && destFile.exists()) {
            throw new RuntimeException("destination file " + destFile.getAbsolutePath() + " already exists - set overwriteExisting to true?");
        }
        IExportEngine exportEngine = (IExportEngine)ExportController.getContoller().getFilterMap().get(filter);
        exportEngine.export((MapModel)((MapProxy)map).getDelegate(), destFile);
        LogUtils.info((String)("exported " + map.getFile() + " to " + destFile.getAbsolutePath()));
    }

    private FileFilter findExportFileFilterByDescription(String exportTypeDescription) {
        for (FileFilter fileFilter : ExportController.getContoller().getFileFilters()) {
            if (!fileFilter.getDescription().equals(exportTypeDescription)) continue;
            return fileFilter;
        }
        return null;
    }
}

