/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.AttributeController;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.attribute.mindmapmode.MAttributeController;
import org.freeplane.features.format.IFormattedObject;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.AbstractProxy;
import org.freeplane.plugin.script.proxy.Convertible;
import org.freeplane.plugin.script.proxy.Proxy;
import org.freeplane.plugin.script.proxy.ProxyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AttributesProxy
extends AbstractProxy<NodeModel>
implements Proxy.Attributes {
    AttributesProxy(NodeModel delegate, ScriptContext scriptContext) {
        super(delegate, scriptContext);
    }

    @Override
    @Deprecated
    public Object get(String name) {
        return this.getFirst(name);
    }

    @Override
    public Object getFirst(String name) {
        int index = this.findAttribute(name);
        if (index == -1) {
            return null;
        }
        NodeAttributeTableModel attributeTableModel = this.getNodeAttributeTableModel();
        return attributeTableModel.getAttribute(index).getValue();
    }

    @Override
    public List<Object> getAll(String name) {
        NodeAttributeTableModel attributeTableModel = this.getNodeAttributeTableModel();
        if (attributeTableModel == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Attribute attribute : attributeTableModel.getAttributes()) {
            if (!attribute.getName().equals(name)) continue;
            result.add(attribute.getValue());
        }
        return result;
    }

    @Override
    public List<String> getNames() {
        NodeAttributeTableModel attributeTableModel = this.getNodeAttributeTableModel();
        if (attributeTableModel == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(attributeTableModel.getRowCount());
        for (Attribute a : attributeTableModel.getAttributes()) {
            result.add(a.getName());
        }
        return result;
    }

    @Override
    @Deprecated
    public List<String> getAttributeNames() {
        return this.getNames();
    }

    @Override
    public List<? extends Convertible> getValues() {
        NodeAttributeTableModel attributeTableModel = this.getNodeAttributeTableModel();
        if (attributeTableModel == null) {
            return Collections.emptyList();
        }
        ArrayList<Convertible> result = new ArrayList<Convertible>(attributeTableModel.getRowCount());
        for (Attribute a : attributeTableModel.getAttributes()) {
            result.add(ProxyUtils.attributeValueToConvertible((NodeModel)this.getDelegate(), this.getScriptContext(), a.getValue()));
        }
        return result;
    }

    @Override
    public Map<String, Object> getMap() {
        NodeAttributeTableModel attributeTableModel = this.getNodeAttributeTableModel();
        if (attributeTableModel == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(attributeTableModel.getRowCount());
        for (Attribute a : attributeTableModel.getAttributes()) {
            result.put(a.getName(), a.getValue());
        }
        return result;
    }

    @Override
    public List<? extends Convertible> findValues(Closure<Boolean> closure) {
        try {
            NodeAttributeTableModel attributeTableModel = this.getNodeAttributeTableModel();
            if (attributeTableModel == null) {
                return Collections.emptyList();
            }
            ArrayList<Convertible> result = new ArrayList<Convertible>(attributeTableModel.getRowCount());
            for (Attribute a : attributeTableModel.getAttributes()) {
                Object bool = closure.call(new Object[]{a.getName(), a.getValue()});
                if (result == null) {
                    throw new RuntimeException("findValues(): closure returned null instead of boolean/Boolean");
                }
                if (!((Boolean)bool).booleanValue()) continue;
                result.add(ProxyUtils.attributeValueToConvertible((NodeModel)this.getDelegate(), this.getScriptContext(), a.getValue()));
            }
            return result;
        }
        catch (MissingMethodException e) {
            throw new RuntimeException("findValues(): closure needs to accept two args and must return boolean/Boolean e.g. findValues{k,v -> k != 'TOTAL'}", e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("findValues(): closure returned " + e.getMessage() + " instead of boolean/Boolean");
        }
    }

    @Override
    public Object get(int index) {
        return this.getAndCheckNodeAttributeTableModelForIndex(index, "get:").getValue(index);
    }

    private NodeAttributeTableModel getAndCheckNodeAttributeTableModelForIndex(int index, String errorPrefix) {
        NodeAttributeTableModel attributeTableModel = this.getNodeAttributeTableModel();
        if (attributeTableModel == null) {
            throw new IndexOutOfBoundsException(errorPrefix + index);
        }
        return attributeTableModel;
    }

    @Override
    public String getKey(int index) {
        return this.getAndCheckNodeAttributeTableModelForIndex(index, "getKey:").getAttribute(index).getName();
    }

    @Override
    public void set(int index, Object value) {
        NodeAttributeTableModel attributeTableModel = this.getAndCheckNodeAttributeTableModelForIndex(index, "set1:");
        String oldPattern = this.getOldValueFormatPattern(attributeTableModel, index);
        this.getAttributeController().performSetValueAt(attributeTableModel, ProxyUtils.transformObject(value, oldPattern), index, 1);
    }

    @Override
    public void set(int index, String name, Object value) {
        NodeAttributeTableModel attributeTableModel = this.getAndCheckNodeAttributeTableModelForIndex(index, "set2:");
        String oldPattern = this.getOldValueFormatPattern(attributeTableModel, index);
        this.getAttributeController().setAttribute((NodeModel)this.getDelegate(), index, new Attribute(name, ProxyUtils.transformObject(value, oldPattern)));
    }

    @Override
    public int findFirst(String name) {
        List<String> attributeNames = this.getAttributeNames();
        for (int i = 0; i < attributeNames.size(); ++i) {
            if (!attributeNames.get(i).equals(name)) continue;
            return i;
        }
        return -1;
    }

    @Override
    @Deprecated
    public int findAttribute(String name) {
        return this.findFirst(name);
    }

    @Override
    @Deprecated
    public boolean remove(String name) {
        int index = this.findFirst(name);
        if (index == -1) {
            return false;
        }
        this.getAttributeController().removeAttribute((NodeModel)this.getDelegate(), index);
        return true;
    }

    @Override
    public boolean removeAll(String name) {
        int i;
        NodeAttributeTableModel attributeTableModel = this.getNodeAttributeTableModel();
        if (attributeTableModel == null) {
            return false;
        }
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        Vector attributes = attributeTableModel.getAttributes();
        for (i = 0; i < attributes.size(); ++i) {
            if (!((Attribute)attributes.get(i)).getName().equals(name)) continue;
            toRemove.add(i);
        }
        for (i = toRemove.size() - 1; i >= 0; --i) {
            this.getAttributeController().removeAttribute((NodeModel)this.getDelegate(), ((Integer)toRemove.get(i)).intValue());
        }
        return !toRemove.isEmpty();
    }

    @Override
    public void remove(int index) {
        this.getAndCheckNodeAttributeTableModelForIndex(index, "remove:");
        this.getAttributeController().removeAttribute((NodeModel)this.getDelegate(), index);
    }

    @Override
    public void clear() {
        NodeAttributeTableModel attributeTableModel = this.getNodeAttributeTableModel();
        int size = attributeTableModel.getRowCount();
        for (int i = size - 1; i >= 0; --i) {
            this.getAttributeController().removeAttribute((NodeModel)this.getDelegate(), i);
        }
    }

    @Override
    public void set(String name, Object value) {
        int index = this.findFirst(name);
        if (index == -1) {
            Attribute attribute = new Attribute(name, ProxyUtils.transformObject(value, null));
            this.getAttributeController().addAttribute((NodeModel)this.getDelegate(), attribute);
        } else {
            String oldPattern = this.getOldValueFormatPattern(this.getNodeAttributeTableModel(), index);
            Attribute attribute = new Attribute(name, ProxyUtils.transformObject(value, oldPattern));
            this.getAttributeController().setAttribute((NodeModel)this.getDelegate(), index, attribute);
        }
    }

    private String getOldValueFormatPattern(NodeAttributeTableModel attributeTableModel, int index) {
        Object value = attributeTableModel.getAttribute(index).getValue();
        return value instanceof IFormattedObject ? ((IFormattedObject)value).getPattern() : null;
    }

    @Override
    public void add(String name, Object value) {
        Attribute attribute = new Attribute(name, ProxyUtils.transformObject(value, null));
        this.getAttributeController().addAttribute((NodeModel)this.getDelegate(), attribute);
    }

    @Override
    public int size() {
        NodeAttributeTableModel attributeTableModel = this.getNodeAttributeTableModel();
        if (attributeTableModel == null) {
            return 0;
        }
        return attributeTableModel.getRowCount();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private MAttributeController getAttributeController() {
        return (MAttributeController)AttributeController.getController();
    }

    private NodeAttributeTableModel getNodeAttributeTableModel() {
        return NodeAttributeTableModel.getModel((NodeModel)((NodeModel)this.getDelegate()));
    }

    public boolean asBoolean() {
        return !this.isEmpty();
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        final NodeAttributeTableModel attributeTableModel = this.getNodeAttributeTableModel();
        if (attributeTableModel == null) {
            return Collections.emptyMap().entrySet().iterator();
        }
        return new Iterator<Map.Entry<String, Object>>(){
            private final Iterator<Attribute> iterator;
            {
                this.iterator = attributeTableModel.getAttributes().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Map.Entry<String, Object> next() {
                final Attribute attribute = this.iterator.next();
                return new Map.Entry<String, Object>(){

                    @Override
                    public String getKey() {
                        return attribute.getName();
                    }

                    @Override
                    public Object getValue() {
                        return attribute.getValue();
                    }

                    @Override
                    public Object setValue(Object value) {
                        Object oldValue = attribute.getValue();
                        attribute.setValue(value);
                        return oldValue;
                    }
                };
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }
}

