/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.filter;

import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.plugin.script.ExecuteScriptException;
import org.freeplane.plugin.script.GroovyScript;
import org.freeplane.plugin.script.IScript;
import org.freeplane.plugin.script.ScriptingPermissions;

public class ScriptCondition
extends ASelectableCondition {
    private static final String SCRIPT_FILTER_DESCRIPTION_RESOURCE = "plugins/script_filter";
    private static final String SCRIPT_FILTER_ERROR_RESOURCE = "plugins/script_filter_error";
    private static final String SCRIPT_FILTER_EXECUTE_ERROR_RESOURCE = "plugins/script_filter_execute_error";
    static final String NAME = "script_condition";
    static final String TAG_NAME = "script";
    static final String ATTRIB_NAME = "SCRIPT";
    private final IScript script;
    private boolean errorReported = false;

    static ASelectableCondition load(XMLElement element) {
        XMLElement child = element.getFirstChildNamed(TAG_NAME);
        if (child != null) {
            return new ScriptCondition(child.getContent());
        }
        return new ScriptCondition(element.getAttribute(ATTRIB_NAME, null));
    }

    public void fillXML(XMLElement element) {
        XMLElement child = new XMLElement(TAG_NAME);
        super.fillXML(element);
        child.setContent(this.script.getScript().toString());
        element.addChild(child);
    }

    protected String getName() {
        return NAME;
    }

    public ScriptCondition(String script) {
        ScriptingPermissions formulaPermissions = ScriptingPermissions.getFormulaPermissions();
        this.script = new GroovyScript(script, formulaPermissions);
    }

    public boolean checkNode(NodeModel node) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(out);
        try {
            Object result = this.script.setOutStream(printStream).execute(node);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            if (result instanceof Number) {
                return ((Number)result).doubleValue() != 0.0;
            }
            printStream.println((Object)((Object)this) + ": got '" + result + "' for " + node);
            printStream.close();
            String info = TextUtils.format((String)SCRIPT_FILTER_ERROR_RESOURCE, (Object[])new Object[]{this.createDescription(), node.toString(), String.valueOf(result)});
            this.setErrorStatus(info);
        }
        catch (ExecuteScriptException e) {
            printStream.close();
            String info = TextUtils.format((String)SCRIPT_FILTER_EXECUTE_ERROR_RESOURCE, (Object[])new Object[]{this.createDescription(), node.toString(), e.getMessage()});
            this.setErrorStatus(info);
        }
        return false;
    }

    private void setErrorStatus(String info) {
        if (!this.errorReported) {
            this.errorReported = true;
            JOptionPane.showMessageDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), info, TextUtils.getText((String)"error"), 0);
        }
        LogUtils.warn((String)info);
        Controller.getCurrentController().getViewController().out(info.trim().replaceAll("\\s", " ").substring(0, 80));
    }

    protected String createDescription() {
        return TextUtils.format((String)SCRIPT_FILTER_DESCRIPTION_RESOURCE, (Object[])new Object[]{this.script.getScript()});
    }

    protected JComponent createRendererComponent() {
        JComponent renderer = super.createRendererComponent();
        Dimension preferredSize = renderer.getPreferredSize();
        if (preferredSize.width > 200) {
            renderer.setPreferredSize(new Dimension(200, preferredSize.height));
        }
        String scriptText = (String)this.script.getScript();
        if (preferredSize.width > 200 || scriptText.contains("\n")) {
            renderer.setToolTipText(HtmlUtils.plainToHTML((String)scriptText));
        }
        return renderer;
    }
}

