/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.addons;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.freeplane.main.addons.AddOnProperties;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.plugin.script.ExecuteScriptAction;
import org.freeplane.plugin.script.ScriptingPermissions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptAddOnProperties
extends AddOnProperties {
    private List<Script> scripts;
    private List<String> lib;

    public ScriptAddOnProperties(String name) {
        super(AddOnProperties.AddOnType.SCRIPT);
        this.setName(name);
    }

    public ScriptAddOnProperties(XMLElement addOnElement) {
        super(AddOnProperties.AddOnType.SCRIPT, addOnElement);
        this.scripts = this.parseScripts(addOnElement.getChildrenNamed("scripts"));
        this.setLib(this.parseBinaries(addOnElement.getChildrenNamed("libs")));
        this.validate();
    }

    private void validate() {
        if (this.scripts == null) {
            throw new RuntimeException((Object)((Object)this) + ": on parsing add-on XML file: scripts may not be null");
        }
        for (Script script : this.scripts) {
            if (script.name == null) {
                throw new RuntimeException((Object)((Object)this) + ": on parsing add-on XML file: no name");
            }
            if (script.executionMode == null) {
                throw new RuntimeException((Object)((Object)this) + ": on parsing add-on XML file: no execution_mode");
            }
            if (script.menuTitleKey == null) {
                throw new RuntimeException((Object)((Object)this) + ": on parsing add-on XML file: no menu title key");
            }
            if (script.menuLocation == null) {
                throw new RuntimeException((Object)((Object)this) + ": on parsing add-on XML file: no menu location");
            }
            if (script.permissions != null) continue;
            throw new RuntimeException((Object)((Object)this) + ": on parsing add-on XML file: no permissions");
        }
    }

    private List<Script> parseScripts(Vector<XMLElement> xmlElements) {
        ArrayList<Script> scripts = new ArrayList<Script>();
        if (xmlElements == null || xmlElements.isEmpty()) {
            return scripts;
        }
        for (XMLElement scriptXmlNode : xmlElements.get(0).getChildren()) {
            Script script = new Script();
            for (Map.Entry<Object, Object> entry : scriptXmlNode.getAttributes().entrySet()) {
                if (entry.getKey().equals("name")) {
                    script.name = (String)entry.getValue();
                    continue;
                }
                if (entry.getKey().equals("executionMode")) {
                    script.executionMode = ScriptAddOnProperties.parseExecutionMode(entry.getValue().toString());
                    continue;
                }
                if (entry.getKey().equals("menuTitleKey")) {
                    script.menuTitleKey = entry.getValue().toString();
                    continue;
                }
                if (!entry.getKey().equals("menuLocation")) continue;
                script.menuLocation = entry.getValue().toString();
            }
            script.permissions = new ScriptingPermissions(scriptXmlNode.getAttributes());
            scripts.add(script);
        }
        return scripts;
    }

    public static ExecuteScriptAction.ExecutionMode parseExecutionMode(String executionModeString) {
        try {
            return ExecuteScriptAction.ExecutionMode.valueOf(executionModeString.toUpperCase());
        }
        catch (Exception e) {
            throw new RuntimeException("invalid execution mode found in " + executionModeString, e);
        }
    }

    public List<Script> getScripts() {
        return this.scripts;
    }

    public List<String> getLib() {
        return this.lib;
    }

    public void setLib(Collection<String> lib) {
        this.lib = new ArrayList<String>(lib);
    }

    public static String getNameKey(String name) {
        return "addons." + name;
    }

    public XMLElement toXml() {
        XMLElement xmlElement = super.toXml();
        this.addScriptsAsChild(xmlElement);
        this.addLibAsChild(xmlElement);
        return xmlElement;
    }

    private void addScriptsAsChild(XMLElement parent) {
        XMLElement xmlElement = new XMLElement("scripts");
        for (Script script : this.scripts) {
            XMLElement scriptXmlElement = new XMLElement("script");
            scriptXmlElement.setAttribute("name", script.name);
            scriptXmlElement.setAttribute("menuTitleKey", script.menuTitleKey);
            scriptXmlElement.setAttribute("menuLocation", script.menuLocation);
            scriptXmlElement.setAttribute("executionMode", script.executionMode.toString());
            List<String> permissionNames = ScriptingPermissions.getPermissionNames();
            for (String permission : permissionNames) {
                scriptXmlElement.setAttribute(permission, Boolean.toString(script.permissions.get(permission)));
            }
            xmlElement.addChild(scriptXmlElement);
        }
        parent.addChild(xmlElement);
    }

    private void addLibAsChild(XMLElement parent) {
        XMLElement xmlElement = new XMLElement("libs");
        if (this.lib != null) {
            for (String l : this.lib) {
                XMLElement libElement = new XMLElement("lib");
                libElement.setAttribute("name", l);
                xmlElement.addChild(libElement);
            }
        }
        parent.addChild(xmlElement);
    }

    public boolean supportsOperation(String opName) {
        if (opName.equals("deactivate")) {
            return this.isActive() && !this.scripts.isEmpty();
        }
        return super.supportsOperation(opName);
    }

    public static class Script {
        public String name;
        public ExecuteScriptAction.ExecutionMode executionMode;
        public String menuTitleKey;
        public String menuLocation;
        public ScriptingPermissions permissions;
        public String keyboardShortcut;
        public String scriptBody;
        public boolean active = true;

        public String toString() {
            return this.name + "(" + (Object)((Object)this.executionMode) + "/" + this.menuTitleKey + "/" + this.menuLocation + "" + ")";
        }
    }
}

