/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.addons;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.freeplane.main.addons.AddOnProperties;
import org.freeplane.plugin.script.addons.ManageAddOnsPanel;

class ButtonsInCellRenderer
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor,
ActionListener,
MouseListener {
    static final int BUTTON_SPACER = 4;
    private final JTable table;
    private final Border border;
    private Border fborder;
    private Object editorValue;
    private boolean isButtonColumnEditor;
    private JPanel panel;
    private final Action[] actions;
    private final JButton[] buttons;

    public ButtonsInCellRenderer(JTable table, JButton[] buttons, Action[] actions, int column) {
        this.table = table;
        this.actions = actions;
        this.buttons = buttons;
        for (JButton btn : buttons) {
            btn.setFocusPainted(false);
            btn.addActionListener(this);
        }
        this.border = buttons[0].getBorder();
        this.setFocusBorder(new LineBorder(Color.BLUE));
        TableColumnModel columnModel = table.getColumnModel();
        columnModel.getColumn(column).setCellRenderer(this);
        columnModel.getColumn(column).setCellEditor(this);
        table.addMouseListener(this);
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.panel.add(Box.createHorizontalGlue());
        if (buttons.length > 0) {
            this.panel.add(buttons[0]);
        }
        for (int i = 1; i < buttons.length; ++i) {
            this.panel.add(Box.createHorizontalStrut(4));
            this.panel.add(buttons[i]);
        }
        this.panel.add(Box.createHorizontalStrut(4));
    }

    private void setFocusBorder(Border focusBorder) {
        this.fborder = focusBorder;
        for (JButton btn : this.buttons) {
            btn.setBorder(focusBorder);
        }
    }

    public Object getCellEditorValue() {
        return this.editorValue;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setButtonsVisible(table, row);
        for (JButton btn : this.buttons) {
            if (isSelected) {
                btn.setForeground(table.getSelectionForeground());
                btn.setBackground(table.getSelectionBackground());
                this.panel.setBackground(table.getSelectionBackground());
            } else {
                btn.setForeground(table.getForeground());
                btn.setBackground(UIManager.getColor("Button.background"));
                this.panel.setBackground(table.getBackground());
            }
            if (hasFocus) {
                btn.setBorder(this.fborder);
                continue;
            }
            btn.setBorder(this.border);
        }
        return this.panel;
    }

    protected void setButtonsVisible(JTable table, int row) {
        ManageAddOnsPanel.AddOnTableModel model = (ManageAddOnsPanel.AddOnTableModel)table.getModel();
        AddOnProperties addOn = model.getAddOnAt(row);
        for (JButton btn : this.buttons) {
            boolean supportsOperation = addOn.supportsOperation(btn.getName());
            btn.setVisible(supportsOperation);
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.editorValue = value;
        this.setButtonsVisible(table, row);
        return this.panel;
    }

    public void actionPerformed(ActionEvent e) {
        int row = this.table.getEditingRow();
        this.fireEditingStopped();
        for (int i = 0; i < this.buttons.length; ++i) {
            if (!e.getSource().equals(this.buttons[i])) continue;
            ActionEvent event = new ActionEvent(this.table, 1001, "" + row);
            this.actions[i].actionPerformed(event);
            break;
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.table.isEditing() && this.table.getCellEditor() == this) {
            this.isButtonColumnEditor = true;
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.isButtonColumnEditor && this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        this.isButtonColumnEditor = false;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

