/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.addons;

import java.awt.Component;
import java.text.BreakIterator;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.main.addons.AddOnProperties;
import org.freeplane.plugin.script.addons.ManageAddOnsDialog;

public class AddonRenderer
extends DefaultTableCellRenderer {
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof AddOnProperties) {
            AddOnProperties addOn = (AddOnProperties)value;
            String description = addOn.getDescription();
            String shortDescription = HtmlUtils.toXMLEscapedText((String)this.shorten(HtmlUtils.htmlToPlain((String)description), 120));
            String text = "<html><body><b><font size='+1'>" + addOn.getTranslatedName() + " " + addOn.getVersion().replaceAll("^v", "") + this.createAuthorText(addOn.getAuthor()) + "</font></b><br>" + shortDescription + "</body></html>";
            value = text;
            this.setToolTipText(description);
        }
        Component tableCellRendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        return tableCellRendererComponent;
    }

    private String createAuthorText(String author) {
        if (author == null || author.length() == 0) {
            return "";
        }
        return " " + ManageAddOnsDialog.getText("authored.by", author);
    }

    private String shorten(String string, int maxLength) {
        if (string.length() <= 3 || string.length() <= maxLength) {
            return string;
        }
        BreakIterator bi = BreakIterator.getSentenceInstance();
        bi.setText(string);
        string = string.substring(0, bi.next());
        if (string.length() <= 3 || string.length() <= maxLength) {
            return string + "...";
        }
        return string.substring(0, maxLength - 3) + "...";
    }
}

