/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.addons;

import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.MenuBuilder;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.FreeplaneIconUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.mindmapmode.MMapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.url.mindmapmode.MFileManager;
import org.freeplane.main.addons.AddOnProperties;
import org.freeplane.main.addons.AddOnsController;
import org.freeplane.plugin.script.ScriptingEngine;
import org.freeplane.plugin.script.ScriptingPermissions;
import org.freeplane.plugin.script.addons.ManageAddOnsDialog;
import org.freeplane.plugin.script.addons.ManageAddOnsPanel;

public class AddOnInstallerPanel
extends JPanel {
    private ManageAddOnsPanel manageAddOnsPanel;
    private ManageAddOnsPanel manageThemesPanel;
    private JButton installButton;
    private JTextField urlField;

    public AddOnInstallerPanel(ManageAddOnsPanel manageAddOnsPanel, ManageAddOnsPanel manageThemesPanel) {
        this.manageAddOnsPanel = manageAddOnsPanel;
        this.manageThemesPanel = manageThemesPanel;
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.add((Component)DefaultComponentFactory.getInstance().createSeparator(AddOnInstallerPanel.getTitleText("search")), "1, 2");
        this.add((Component)this.createVisitAddOnPageButton(), "1, 4, left, default");
        this.add(Box.createVerticalStrut(20), "1, 6");
        this.add((Component)DefaultComponentFactory.getInstance().createSeparator(AddOnInstallerPanel.getTitleText("install.from.known.location")), "1, 7");
        this.installButton = this.createInstallButton();
        this.urlField = this.createUrlField(this.installButton);
        JButton selectFile = this.createFileChooser(this.urlField);
        this.installButton.addActionListener(this.createInstallActionListener());
        Box box = Box.createHorizontalBox();
        box.add(this.urlField);
        box.add(selectFile);
        this.add((Component)box, "1, 9");
        this.add((Component)this.installButton, "1, 11, right, default");
    }

    private static String getText(String key, Object ... parameters) {
        return ManageAddOnsDialog.getText(key, parameters);
    }

    private static String getTitleText(String key) {
        String titleStyle = "<html><b><font size='+1'>";
        return "<html><b><font size='+1'>" + AddOnInstallerPanel.getText(key, new Object[0]);
    }

    private JButton createVisitAddOnPageButton() {
        try {
            String addOnsUriString = TextUtils.removeTranslateComment((String)TextUtils.getText((String)"addons.site"));
            URI addOnsUri = new URI(addOnsUriString);
            return UITools.createHtmlLinkStyleButton((URI)addOnsUri, (String)AddOnInstallerPanel.getText("visit.addon.page", new Object[0]));
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    private JButton createInstallButton() {
        JButton installButton = new JButton();
        MenuBuilder.setLabelAndMnemonic((AbstractButton)installButton, (String)AddOnInstallerPanel.getText("install", new Object[0]));
        installButton.setEnabled(false);
        installButton.setMargin(new Insets(0, 25, 0, 25));
        return installButton;
    }

    private ActionListener createInstallActionListener() {
        return new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                Controller controller = Controller.getCurrentController();
                try {
                    LogUtils.info((String)("installing add-on from " + AddOnInstallerPanel.this.urlField.getText()));
                    controller.getViewController().setWaitingCursor(true);
                    URL url = this.toURL(AddOnInstallerPanel.this.urlField.getText());
                    AddOnInstallerPanel.setStatusInfo(AddOnInstallerPanel.getText("status.installing", new Object[0]));
                    ModeController modeController = controller.getModeController("MindMap");
                    MFileManager fileManager = MFileManager.getController((ModeController)modeController);
                    MMapModel newMap = new MMapModel();
                    if (!fileManager.loadCatchExceptions(url, (MapModel)newMap)) {
                        LogUtils.warn((String)("can not load " + url));
                        return;
                    }
                    controller.getModeController().getMapController().fireMapCreated((MapModel)newMap);
                    AddOnProperties addOn = (AddOnProperties)ScriptingEngine.executeScript(newMap.getRootNode(), this.getInstallScriptSource(), ScriptingPermissions.getPermissiveScriptingPermissions());
                    if (addOn != null) {
                        AddOnInstallerPanel.setStatusInfo(AddOnInstallerPanel.getText("status.success", new Object[]{addOn.getName()}));
                        AddOnsController.getController().registerInstalledAddOn(addOn);
                        ManageAddOnsPanel managementPanel = addOn.isTheme() ? AddOnInstallerPanel.this.manageThemesPanel : AddOnInstallerPanel.this.manageAddOnsPanel;
                        managementPanel.getTableModel().addAddOn(addOn);
                        AddOnInstallerPanel.this.urlField.setText("");
                        ((JTabbedPane)AddOnInstallerPanel.this.getParent()).setSelectedComponent(managementPanel);
                        AddOnInstallerPanel.this.selectLastAddOn(managementPanel);
                    }
                }
                catch (Exception ex) {
                    UITools.errorMessage((Object)AddOnInstallerPanel.getText("error", new Object[]{ex.toString()}));
                }
                finally {
                    controller.getViewController().setWaitingCursor(false);
                }
            }

            private String getInstallScriptSource() throws IOException {
                ResourceController resourceController = ResourceController.getResourceController();
                File scriptDir = new File(resourceController.getInstallationBaseDir(), "scripts");
                File installScript = new File(scriptDir, "installScriptAddOn.groovy");
                if (!installScript.exists()) {
                    throw new RuntimeException("internal error: installer not found at " + installScript);
                }
                return FileUtils.slurpFile((File)installScript);
            }

            private URL toURL(String urlText) throws MalformedURLException {
                try {
                    return new URL(urlText);
                }
                catch (Exception e2) {
                    return new File(urlText).toURI().toURL();
                }
            }
        };
    }

    private void selectLastAddOn(JComponent managementPanel) {
        try {
            JTable table = this.findJTable(managementPanel);
            int row = table.getModel().getRowCount() - 1;
            table.getSelectionModel().setSelectionInterval(row, row);
        }
        catch (Exception e) {
            LogUtils.warn((String)"cannot select just installed add-on", (Throwable)e);
        }
    }

    private JTable findJTable(JComponent child) {
        for (Component component : child.getComponents()) {
            JTable findResult;
            if (component instanceof JTable) {
                return (JTable)component;
            }
            if (!(component instanceof JComponent) || (findResult = this.findJTable((JComponent)component)) == null) continue;
            return findResult;
        }
        return null;
    }

    private JButton createFileChooser(final JTextField urlField) {
        JButton selectFile = new JButton(AddOnInstallerPanel.getText("search.file", new Object[0]), FreeplaneIconUtils.createImageIconByResourceKey((String)"OpenAction.icon"));
        final JFileChooser fileChooser = new JFileChooser();
        selectFile.setToolTipText(AddOnInstallerPanel.getText("select.tooltip", new Object[0]));
        selectFile.setMaximumSize(UITools.MAX_BUTTON_DIMENSION);
        selectFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                fileChooser.showOpenDialog(urlField);
                File selectedFile = fileChooser.getSelectedFile();
                if (selectedFile != null) {
                    urlField.setText(selectedFile.getAbsolutePath());
                }
            }
        });
        return selectFile;
    }

    private JTextField createUrlField(final JButton install) {
        JTextField urlField = new JTextField();
        urlField.setToolTipText(AddOnInstallerPanel.getText("install.tooltip", new Object[0]));
        urlField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                this.updateImpl(e);
            }

            public void removeUpdate(DocumentEvent e) {
                this.updateImpl(e);
            }

            public void changedUpdate(DocumentEvent e) {
                this.updateImpl(e);
            }

            private void updateImpl(DocumentEvent e) {
                install.setEnabled(e.getDocument().getLength() > 0);
            }
        });
        urlField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 10) {
                    install.requestFocusInWindow();
                    install.doClick();
                }
            }
        });
        return urlField;
    }

    JButton getInstallButton() {
        return this.installButton;
    }

    JTextField getUrlField() {
        return this.urlField;
    }

    private static void setStatusInfo(String message) {
        Controller.getCurrentController().getViewController().out(message);
    }
}

