/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.addons;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.lang.StringUtils;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.MenuBuilder;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.MenuUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.IconNotFound;
import org.freeplane.features.mode.Controller;
import org.freeplane.main.addons.AddOnProperties;
import org.freeplane.plugin.script.ExecuteScriptAction;
import org.freeplane.plugin.script.addons.ScriptAddOnProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddOnDetailsPanel
extends JPanel {
    private int maxWidth = 500;
    private String warning;

    public AddOnDetailsPanel(AddOnProperties addOn, String warning) {
        this.warning = warning;
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, RowSpec.decode((String)"top:default:grow")}));
        if (warning != null) {
            JLabel warningLabel = this.createWarningLabel(addOn);
            this.add((Component)warningLabel, "3, 2");
        }
        JLabel imageLabel = this.createImageLabel(addOn);
        this.add((Component)imageLabel, "1, 4");
        JLabel title = this.createTitleLabel(addOn);
        this.add((Component)title, "3, 4");
        JLabel author = this.createAuthorLabel(addOn);
        this.add((Component)author, "3, 6");
        Box box = Box.createHorizontalBox();
        box.add(new JLabel(AddOnDetailsPanel.getText("homepage", new Object[0])));
        box.add(this.createAddOnHomepageButton(addOn));
        this.add((Component)box, "3, 8, left, default");
        JComponent details = this.createDetails(addOn);
        this.add((Component)details, "3, 9");
    }

    private JLabel createImageLabel(AddOnProperties addOn) {
        JLabel label = new JLabel("");
        label.setIcon(IconNotFound.createIconOrReturnNotFoundIcon((String)(addOn.getName() + ".png")));
        return label;
    }

    public AddOnDetailsPanel(AddOnProperties addOn) {
        this(addOn, null);
    }

    private JLabel createWarningLabel(AddOnProperties addOn) {
        return new JLabel("<html><body>" + this.warning.replaceAll("</?(html|body)>", "") + "</body></html>");
    }

    private JLabel createTitleLabel(AddOnProperties addOn) {
        return new JLabel("<html><body><b><font size='+2'>" + this.toHtml(addOn.getTranslatedName()) + " " + addOn.getVersion().replaceAll("^v", "") + "</font></b></body></html>");
    }

    private JLabel createAuthorLabel(AddOnProperties addOn) {
        String text = addOn.getAuthor() == null ? "" : "<html><body><strong><font size='-1'>" + AddOnDetailsPanel.getText("authored.by", this.toHtml(addOn.getAuthor())) + "</font></strong></body></html>";
        return new JLabel(text);
    }

    private JComponent createAddOnHomepageButton(AddOnProperties addOn) {
        try {
            return UITools.createHtmlLinkStyleButton((URI)addOn.getHomepage().toURI(), (String)addOn.getHomepage().toString());
        }
        catch (Exception e) {
            LogUtils.warn((String)("add-on " + addOn + " has no valid homepage: " + e));
            return new JLabel("-");
        }
    }

    private JComponent createDetails(AddOnProperties addOn) {
        List<ScriptAddOnProperties.Script> scripts;
        StringBuilder text = new StringBuilder(1024);
        text.append("<html><body>");
        text.append(this.toHtml(addOn.getDescription()));
        text.append("<p>");
        if (addOn instanceof ScriptAddOnProperties && !(scripts = ((ScriptAddOnProperties)addOn).getScripts()).isEmpty()) {
            text.append("<table border='1'>");
            text.append(this.row("th", AddOnDetailsPanel.getText("header.function", new Object[0]), AddOnDetailsPanel.getText("header.menu", new Object[0]), AddOnDetailsPanel.getText("header.shortcut", new Object[0])));
            for (ScriptAddOnProperties.Script script : scripts) {
                text.append(this.row("td", this.bold(TextUtils.getText((String)script.menuTitleKey)), this.formatMenuLocation(script), this.formatShortcut(script)));
            }
            text.append("</table>");
        }
        text.append("</body></html>");
        JLabel label = new JLabel(text.toString());
        label.setAutoscrolls(true);
        ImageIcon icon = IconNotFound.createIconOrReturnNull((String)(addOn.getName() + "-screenshot-1.png"));
        if (icon != null) {
            label.setIcon(icon);
        }
        return label;
    }

    private String toHtml(String htmlOrPlainText) {
        if (HtmlUtils.isHtmlNode((String)htmlOrPlainText)) {
            return htmlOrPlainText.replaceAll("</?(html|body)>", "");
        }
        return HtmlUtils.toHTMLEscapedText((String)htmlOrPlainText);
    }

    private String formatShortcut(ScriptAddOnProperties.Script script) {
        String menuItemKey = ExecuteScriptAction.makeMenuItemKey(script.menuTitleKey, script.executionMode);
        String shortcutKey = MenuUtils.makeAcceleratorKey((String)menuItemKey);
        String oldShortcut = ResourceController.getResourceController().getProperty(shortcutKey);
        KeyStroke keyStroke = UITools.getKeyStroke((String)(oldShortcut != null ? oldShortcut : script.keyboardShortcut));
        return UITools.keyStrokeToString((KeyStroke)keyStroke);
    }

    private String formatMenuLocation(ScriptAddOnProperties.Script script) {
        String location = script.menuLocation == null ? "main_menu_scripting" : script.menuLocation;
        MenuBuilder menuBuilder = Controller.getCurrentModeController().getUserInputListenerFactory().getMenuBuilder();
        List<String> pathElements = AddOnDetailsPanel.getMenuPathElements(menuBuilder, location);
        Collections.reverse(pathElements);
        pathElements.add(TextUtils.getText((String)script.menuTitleKey));
        return StringUtils.join(pathElements.iterator(), (String)"->");
    }

    public static List<String> getMenuPathElements(MenuBuilder menuBuilder, String location) {
        ArrayList<String> pathElements = new ArrayList<String>();
        DefaultMutableTreeNode node = menuBuilder.get((Object)location);
        if (node != null) {
            pathElements.addAll(AddOnDetailsPanel.getMenuPathElements(node));
        } else {
            int index = location.lastIndexOf(47);
            if (index != -1) {
                String lastKey = location.substring(index + 1);
                pathElements.add(TextUtils.getText((String)lastKey, (String)TextUtils.getText((String)("addons." + lastKey), (String)lastKey)));
                if (index > 1) {
                    pathElements.addAll(AddOnDetailsPanel.getMenuPathElements(menuBuilder, location.substring(0, index)));
                }
            }
        }
        return pathElements;
    }

    private static List<String> getMenuPathElements(DefaultMutableTreeNode node) {
        ArrayList<String> pathElements = new ArrayList<String>();
        while (node != null) {
            if (node.getUserObject() instanceof JMenuItem) {
                pathElements.add(((JMenuItem)node.getUserObject()).getText());
            }
            node = (DefaultMutableTreeNode)node.getParent();
        }
        return pathElements;
    }

    private String bold(String text) {
        return "<b>" + text + "</b>";
    }

    private String row(String td, Object ... columns) {
        String separator = "</" + td + "><" + td + ">";
        return "<tr><" + td + ">" + StringUtils.join((Object[])columns, (String)separator) + "</" + td + "></tr>";
    }

    private static String getText(String key, Object ... parameters) {
        if (parameters.length == 0) {
            return TextUtils.getRawText((String)AddOnDetailsPanel.getResourceKey(key));
        }
        return TextUtils.format((String)AddOnDetailsPanel.getResourceKey(key), (Object[])parameters);
    }

    private static String getResourceKey(String key) {
        return "AddOnDetailsPanel." + key;
    }

    public String getWarning() {
        return this.warning;
    }

    public void setWarning(String warning) {
        this.warning = warning;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        preferredSize.width = Math.min(preferredSize.width, this.maxWidth);
        return preferredSize;
    }
}

