/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.EnterPasswordDialog;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.encrypt.DesEncrypter;
import org.freeplane.features.mode.Controller;

class SignedScriptHandler {
    public static final String FREEPLANE_SCRIPT_KEY_NAME = "FreeplaneScriptKey";
    private static KeyStore mKeyStore = null;
    private static final String SIGN_PREFIX = "//SIGN:";
    private static final String SIGN_PREFIX_REGEXP = "//SIGN\\((.*?)\\):(.*)";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeKeystore(char[] pPassword) {
        if (mKeyStore != null) {
            return;
        }
        FileInputStream fis = null;
        try {
            mKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            fis = new FileInputStream(System.getProperty("user.home") + File.separator + ".keystore");
            mKeyStore.load(fis, pPassword);
        }
        catch (FileNotFoundException e) {
            LogUtils.warn((Throwable)e);
        }
        catch (Exception e) {
            LogUtils.severe((Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LogUtils.severe((Throwable)e);
                }
            }
        }
    }

    public boolean isScriptSigned(String pScript, OutputStream pOutStream) {
        ScriptContents content = new ScriptContents(pScript);
        if (content.mSignature != null) {
            try {
                Signature instanceVerify = Signature.getInstance("SHA1withDSA");
                if (content.mKeyName == null) {
                    String cer = "-----BEGIN CERTIFICATE-----\nMIIDKDCCAuWgAwIBAgIESAY2ADALBgcqhkjOOAQDBQAwdzELMAkGA1UEBhMCREUxCzAJBgNVBAgTAkRFMRMwEQYDVQQHEwpPcGVuU291cmNlMRgwFgYDVQQKEw9zb3VyY2Vmb3JnZS5uZXQxETAPBgNVBAsTCEZyZWVNaW5kMRkwFwYDVQQDExBDaHJpc3RpYW4gRm9sdGluMB4XDTA4MDQxNjE3MjMxMloXDTA4MDcxNTE3MjMxMlowdzELMAkGA1UEBhMCREUxCzAJBgNVBAgTAkRFMRMwEQYDVQQHEwpPcGVuU291cmNlMRgwFgYDVQQKEw9zb3VyY2Vmb3JnZS5uZXQxETAPBgNVBAsTCEZyZWVNaW5kMRkwFwYDVQQDExBDaHJpc3RpYW4gRm9sdGluMIIBtzCCASwGByqGSM44BAEwggEfAoGBAP1/U4EddRIpUt9KnC7s5Of2EbdSPO9EAMMeP4C2USZpRV1AIlH7WT2NWPq/xfW6MPbLm1Vs14E7gB00b/JmYLdrmVClpJ+f6AR7ECLCT7up1/63xhv4O1fnxqimFQ8E+4P208UewwI1VBNaFpEy9nXzrith1yrv8iIDGZ3RSAHHAhUAl2BQjxUjC8yykrmCouuEC/BYHPUCgYEA9+GghdabPd7LvKtcNrhXuXmUr7v6OuqC+VdMCz0HgmdRWVeOutRZT+ZxBxCBgLRJFnEj6EwoFhO3zwkyjMim4TwWeotUfI0o4KOuHiuzpnWRbqN/C/ohNWLx+2J6ASQ7zKTxvqhRkImog9/hWuWfBpKLZl6Ae1UlZAFMO/7PSSoDgYQAAoGAZm5z5EZXVhtye5jY3X9w24DJ3yNJbNl2tfkOBIc0KfgyxONTSJKtUpmLI3btUxy3pQf/T8BShlY3PAC0fp3MeDG8WRq1wM3luLd1V9SS8EG6tPJBZ3mciCUymTT7n9CZNzATIpqNIXHSD/wljRABedUi8PMg4KbVPnhu6Y6b1uAwCwYHKoZIzjgEAwUAAzAAMC0CFQCFHGwe+HHOvY0MmKYHbiq7fRxMGwIUC0voAGYUu6vgVFqdLI5F96JLTqk=\n-----END CERTIFICATE-----\n";
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    Collection<? extends Certificate> c = cf.generateCertificates(new ByteArrayInputStream("-----BEGIN CERTIFICATE-----\nMIIDKDCCAuWgAwIBAgIESAY2ADALBgcqhkjOOAQDBQAwdzELMAkGA1UEBhMCREUxCzAJBgNVBAgTAkRFMRMwEQYDVQQHEwpPcGVuU291cmNlMRgwFgYDVQQKEw9zb3VyY2Vmb3JnZS5uZXQxETAPBgNVBAsTCEZyZWVNaW5kMRkwFwYDVQQDExBDaHJpc3RpYW4gRm9sdGluMB4XDTA4MDQxNjE3MjMxMloXDTA4MDcxNTE3MjMxMlowdzELMAkGA1UEBhMCREUxCzAJBgNVBAgTAkRFMRMwEQYDVQQHEwpPcGVuU291cmNlMRgwFgYDVQQKEw9zb3VyY2Vmb3JnZS5uZXQxETAPBgNVBAsTCEZyZWVNaW5kMRkwFwYDVQQDExBDaHJpc3RpYW4gRm9sdGluMIIBtzCCASwGByqGSM44BAEwggEfAoGBAP1/U4EddRIpUt9KnC7s5Of2EbdSPO9EAMMeP4C2USZpRV1AIlH7WT2NWPq/xfW6MPbLm1Vs14E7gB00b/JmYLdrmVClpJ+f6AR7ECLCT7up1/63xhv4O1fnxqimFQ8E+4P208UewwI1VBNaFpEy9nXzrith1yrv8iIDGZ3RSAHHAhUAl2BQjxUjC8yykrmCouuEC/BYHPUCgYEA9+GghdabPd7LvKtcNrhXuXmUr7v6OuqC+VdMCz0HgmdRWVeOutRZT+ZxBxCBgLRJFnEj6EwoFhO3zwkyjMim4TwWeotUfI0o4KOuHiuzpnWRbqN/C/ohNWLx+2J6ASQ7zKTxvqhRkImog9/hWuWfBpKLZl6Ae1UlZAFMO/7PSSoDgYQAAoGAZm5z5EZXVhtye5jY3X9w24DJ3yNJbNl2tfkOBIc0KfgyxONTSJKtUpmLI3btUxy3pQf/T8BShlY3PAC0fp3MeDG8WRq1wM3luLd1V9SS8EG6tPJBZ3mciCUymTT7n9CZNzATIpqNIXHSD/wljRABedUi8PMg4KbVPnhu6Y6b1uAwCwYHKoZIzjgEAwUAAzAAMC0CFQCFHGwe+HHOvY0MmKYHbiq7fRxMGwIUC0voAGYUu6vgVFqdLI5F96JLTqk=\n-----END CERTIFICATE-----\n".getBytes()));
                    if (c.isEmpty()) {
                        throw new IllegalArgumentException("Internal certificate wrong.");
                    }
                    for (Certificate certificate : c) {
                        instanceVerify.initVerify(certificate);
                    }
                } else {
                    this.initializeKeystore(null);
                    instanceVerify.initVerify(mKeyStore.getCertificate(content.mKeyName));
                }
                instanceVerify.update(content.mScript.getBytes());
                boolean verify = instanceVerify.verify(DesEncrypter.fromBase64((String)content.mSignature));
                return verify;
            }
            catch (Exception e) {
                LogUtils.severe((Throwable)e);
                try {
                    pOutStream.write(e.toString().getBytes());
                    pOutStream.write("\n".getBytes());
                }
                catch (Exception e1) {
                    LogUtils.severe((Throwable)e1);
                }
            }
        }
        return false;
    }

    public String signScript(String pScript) {
        ScriptContents content = new ScriptContents(pScript);
        EnterPasswordDialog pwdDialog = new EnterPasswordDialog((Frame)Controller.getCurrentController().getViewController().getJFrame(), false);
        pwdDialog.setModal(true);
        pwdDialog.setVisible(true);
        if (pwdDialog.getResult() == -1) {
            return content.mScript;
        }
        char[] password = pwdDialog.getPassword().toString().toCharArray();
        this.initializeKeystore(password);
        try {
            Signature instance = Signature.getInstance("SHA1withDSA");
            String keyName = FREEPLANE_SCRIPT_KEY_NAME;
            String propertyKeyName = ResourceController.getResourceController().getProperty("script_user_key_name_for_signing");
            if (content.mKeyName != null) {
                keyName = content.mKeyName;
            } else if (propertyKeyName != null && propertyKeyName.length() > 0) {
                keyName = content.mKeyName = propertyKeyName;
            }
            instance.initSign((PrivateKey)mKeyStore.getKey(keyName, password));
            instance.update(content.mScript.getBytes());
            byte[] signature = instance.sign();
            content.mSignature = DesEncrypter.toBase64((byte[])signature);
            return content.toString();
        }
        catch (Exception e) {
            if (!(e instanceof KeyStoreException)) {
                LogUtils.severe((Throwable)e);
            }
            UITools.errorMessage((Object)e.getLocalizedMessage());
            return content.mScript;
        }
    }

    public static class ScriptContents {
        private static Pattern sSignWithKeyPattern = null;
        public String mKeyName;
        public String mScript;
        public String mSignature;

        public ScriptContents() {
            if (sSignWithKeyPattern == null) {
                sSignWithKeyPattern = Pattern.compile(SignedScriptHandler.SIGN_PREFIX_REGEXP);
            }
        }

        public ScriptContents(String pScript) {
            this();
            int indexOfSignaturePrefix = pScript.lastIndexOf(SignedScriptHandler.SIGN_PREFIX);
            int indexOfSignature = indexOfSignaturePrefix + SignedScriptHandler.SIGN_PREFIX.length();
            if (indexOfSignaturePrefix > 0 && pScript.length() > indexOfSignature) {
                this.mSignature = pScript.substring(indexOfSignature);
                this.mScript = pScript.substring(0, indexOfSignaturePrefix);
                this.mKeyName = null;
            } else {
                Matcher matcher = sSignWithKeyPattern.matcher(pScript);
                if (matcher.find()) {
                    this.mScript = pScript.substring(0, matcher.start());
                    this.mKeyName = matcher.group(1);
                    this.mSignature = matcher.group(2);
                } else {
                    this.mSignature = null;
                    this.mScript = pScript;
                    this.mKeyName = null;
                }
            }
        }

        public String toString() {
            String prefix = this.mKeyName != null ? "//SIGN(" + this.mKeyName + "):" : SignedScriptHandler.SIGN_PREFIX;
            return this.mScript + prefix + this.mSignature + "\n";
        }
    }
}

