/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.io.FileDescriptor;
import java.net.InetAddress;
import java.security.Permission;
import java.util.HashSet;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.plugin.script.proxy.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ScriptingSecurityManager
extends SecurityManager {
    private static final String INTERNAL_API_PACKAGE_BASE = "org.freeplane";
    private static final HashSet<String> whiteList = ScriptingSecurityManager.createWhiteList();
    private static final int PERM_Accept = 0;
    private static final int PERM_Connect = 1;
    private static final int PERM_Delete = 7;
    private static final int PERM_Exec = 5;
    private static final int PERM_GROUP_EXEC = 2;
    private static final int PERM_GROUP_FILE = 0;
    private static final int PERM_GROUP_NETWORK = 1;
    private static final int PERM_Link = 6;
    private static final int PERM_Listen = 2;
    private static final int PERM_Multicast = 3;
    private static final int PERM_Read = 8;
    private static final int PERM_SetFactory = 4;
    private static final int PERM_Write = 9;
    private final boolean mWithoutReadRestriction;
    private final boolean mWithoutWriteRestriction;
    private final boolean mWithoutExecRestriction;
    private final boolean mWithoutNetworkRestriction;

    public ScriptingSecurityManager(boolean pWithoutFileRestriction, boolean pWithoutWriteRestriction, boolean pWithoutNetworkRestriction, boolean pWithoutExecRestriction) {
        this.mWithoutReadRestriction = pWithoutFileRestriction;
        this.mWithoutWriteRestriction = pWithoutWriteRestriction;
        this.mWithoutNetworkRestriction = pWithoutNetworkRestriction;
        this.mWithoutExecRestriction = pWithoutExecRestriction;
    }

    private static HashSet<String> createWhiteList() {
        HashSet<String> result = new HashSet<String>();
        result.add(Proxy.class.getPackage().getName());
        result.add(TextUtils.class.getPackage().getName());
        result.add(UITools.class.getPackage().getName());
        result.add(ICondition.class.getPackage().getName());
        return result;
    }

    @Override
    public void checkAccept(String pHost, int pPort) {
        if (this.mWithoutNetworkRestriction) {
            return;
        }
        throw this.getException(1, 0);
    }

    @Override
    public void checkAccess(Thread pT) {
    }

    @Override
    public void checkAccess(ThreadGroup pG) {
    }

    public void checkAwtEventQueueAccess() {
    }

    @Override
    public void checkConnect(String pHost, int pPort) {
        if (this.mWithoutNetworkRestriction) {
            return;
        }
        throw this.getException(1, 1);
    }

    @Override
    public void checkConnect(String pHost, int pPort, Object pContext) {
        if (this.mWithoutNetworkRestriction) {
            return;
        }
        throw this.getException(1, 1);
    }

    @Override
    public void checkCreateClassLoader() {
    }

    @Override
    public void checkDelete(String pFile) {
        if (this.mWithoutReadRestriction) {
            return;
        }
        throw this.getException(0, 7);
    }

    @Override
    public void checkExec(String pCmd) {
        if (this.mWithoutExecRestriction) {
            return;
        }
        throw this.getException(2, 5);
    }

    @Override
    public void checkExit(int pStatus) {
    }

    @Override
    public void checkLink(String pLib) {
        HashSet<String> set = new HashSet<String>();
        set.add("awt");
        set.add("net");
        set.add("jpeg");
        set.add("fontmanager");
        if (this.mWithoutExecRestriction || set.contains(pLib)) {
            return;
        }
        throw this.getException(2, 6);
    }

    @Override
    public void checkListen(int pPort) {
        if (this.mWithoutNetworkRestriction) {
            return;
        }
        throw this.getException(1, 2);
    }

    public void checkMemberAccess(Class<?> arg0, int arg1) {
    }

    @Override
    public void checkMulticast(InetAddress pMaddr) {
        if (this.mWithoutNetworkRestriction) {
            return;
        }
        throw this.getException(1, 3);
    }

    @Override
    public void checkMulticast(InetAddress pMaddr, byte pTtl) {
        if (this.mWithoutNetworkRestriction) {
            return;
        }
        throw this.getException(1, 3);
    }

    @Override
    public void checkPackageAccess(String pkg) {
        if (!pkg.startsWith(INTERNAL_API_PACKAGE_BASE) || !whiteList.contains(pkg)) {
            // empty if block
        }
    }

    @Override
    public void checkPackageDefinition(String pPkg) {
    }

    @Override
    public void checkPermission(Permission pPerm) {
    }

    @Override
    public void checkPermission(Permission pPerm, Object pContext) {
    }

    @Override
    public void checkPrintJobAccess() {
    }

    @Override
    public void checkPropertiesAccess() {
    }

    @Override
    public void checkPropertyAccess(String pKey) {
    }

    @Override
    public void checkRead(FileDescriptor pFd) {
        if (this.mWithoutReadRestriction) {
            return;
        }
        throw this.getException(0, 8);
    }

    @Override
    public void checkRead(String pFile) {
        if (this.mWithoutReadRestriction) {
            return;
        }
        throw this.getException(0, 8, pFile);
    }

    @Override
    public void checkRead(String pFile, Object pContext) {
        if (this.mWithoutReadRestriction) {
            return;
        }
        throw this.getException(0, 8);
    }

    @Override
    public void checkSecurityAccess(String pTarget) {
    }

    @Override
    public void checkSetFactory() {
        if (this.mWithoutNetworkRestriction) {
            return;
        }
        throw this.getException(1, 4);
    }

    public void checkSystemClipboardAccess() {
    }

    public boolean checkTopLevelWindow(Object pWindow) {
        return true;
    }

    @Override
    public void checkWrite(FileDescriptor pFd) {
        if (this.mWithoutWriteRestriction) {
            return;
        }
        throw this.getException(0, 9);
    }

    @Override
    public void checkWrite(String pFile) {
        if (this.mWithoutWriteRestriction) {
            return;
        }
        throw this.getException(0, 9);
    }

    private SecurityException getException(int pPermissionGroup, int pPermission, String pFile) {
        return new SecurityException(TextUtils.format((String)"plugins/ScriptEditor.FORBIDDEN_ACTION", (Object[])new Object[]{new Integer(pPermissionGroup), new Integer(pPermission), pFile}));
    }

    private SecurityException getException(int pPermissionGroup, int pPermission) {
        return this.getException(pPermissionGroup, pPermission, "");
    }
}

