/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxEditor;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.commons.lang.StringUtils;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.IValidator;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.IMenuContributor;
import org.freeplane.core.ui.IUserInputListenerFactory;
import org.freeplane.core.ui.MenuBuilder;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.IElementaryConditionController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.script.IScriptEditorStarter;
import org.freeplane.features.script.IScriptStarter;
import org.freeplane.main.addons.AddOnInstaller;
import org.freeplane.main.addons.AddOnProperties;
import org.freeplane.main.addons.AddOnsController;
import org.freeplane.n3.nanoxml.IXMLParser;
import org.freeplane.n3.nanoxml.IXMLReader;
import org.freeplane.n3.nanoxml.StdXMLReader;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.n3.nanoxml.XMLParserFactory;
import org.freeplane.plugin.script.ExecuteScriptAction;
import org.freeplane.plugin.script.ExecuteScriptForAllNodes;
import org.freeplane.plugin.script.ExecuteScriptForSelectionAction;
import org.freeplane.plugin.script.IFreeplaneScriptErrorHandler;
import org.freeplane.plugin.script.ScriptComboBoxEditor;
import org.freeplane.plugin.script.ScriptCompiler;
import org.freeplane.plugin.script.ScriptEditor;
import org.freeplane.plugin.script.ScriptEditorPanel;
import org.freeplane.plugin.script.ScriptEditorWindowConfigurationStorage;
import org.freeplane.plugin.script.ScriptResources;
import org.freeplane.plugin.script.ScriptingConfiguration;
import org.freeplane.plugin.script.ScriptingEngine;
import org.freeplane.plugin.script.ScriptingPermissions;
import org.freeplane.plugin.script.addons.ManageAddOnsAction;
import org.freeplane.plugin.script.addons.ManageAddOnsDialog;
import org.freeplane.plugin.script.addons.ScriptAddOnProperties;
import org.freeplane.plugin.script.filter.ScriptConditionController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ScriptingRegistration {
    private final HashMap<String, Object> mScriptCookies = new HashMap();

    public ScriptingRegistration(ModeController modeController) {
        this.register(modeController);
    }

    private void addPropertiesToOptionPanel() {
        URL preferences = this.getClass().getResource("preferences.xml");
        if (preferences == null) {
            throw new RuntimeException("cannot open preferences");
        }
        Controller.getCurrentController().addOptionValidator(new IValidator(){

            public IValidator.ValidationResult validate(Properties properties) {
                boolean classpathIsSet;
                IValidator.ValidationResult result = new IValidator.ValidationResult();
                String readAccessString = properties.getProperty("execute_scripts_without_file_restriction");
                String writeAccessString = properties.getProperty("execute_scripts_without_write_restriction");
                String classpath = properties.getProperty("script_classpath");
                boolean readAccess = readAccessString != null && Boolean.parseBoolean(readAccessString);
                boolean writeAccess = writeAccessString != null && Boolean.parseBoolean(writeAccessString);
                boolean bl = classpathIsSet = classpath != null && classpath.length() > 0;
                if (classpathIsSet && !readAccess) {
                    result.addError(TextUtils.getText((String)"OptionPanel.validate_classpath_needs_readaccess"));
                }
                if (writeAccess && !readAccess) {
                    result.addWarning(TextUtils.getText((String)"OptionPanel.validate_write_without_read"));
                }
                return result;
            }
        });
        MModeController modeController = (MModeController)Controller.getCurrentModeController();
        modeController.getOptionPanelBuilder().load(preferences);
    }

    public HashMap<String, Object> getScriptCookies() {
        return this.mScriptCookies;
    }

    private void register(ModeController modeController) {
        modeController.addExtension(IScriptEditorStarter.class, (IExtension)new IScriptEditorStarter(){

            public String startEditor(String pScriptInput) {
                ScriptModel scriptModel = new ScriptModel(pScriptInput);
                ScriptEditorPanel scriptEditorPanel = new ScriptEditorPanel(scriptModel, false);
                scriptEditorPanel.setVisible(true);
                return scriptModel.getScript();
            }

            public ComboBoxEditor createComboBoxEditor(Dimension minimumSize) {
                ScriptComboBoxEditor scriptComboBoxEditor = new ScriptComboBoxEditor();
                if (minimumSize != null) {
                    scriptComboBoxEditor.setMinimumSize(minimumSize);
                }
                return scriptComboBoxEditor;
            }
        });
        modeController.addExtension(IScriptStarter.class, (IExtension)new IScriptStarter(){

            public void executeScript(NodeModel node, String script) {
                ScriptingEngine.executeScript(node, script);
            }
        });
        this.registerScriptAddOns();
        if (!modeController.getController().getViewController().isHeadless()) {
            IUserInputListenerFactory userInputListenerFactory = modeController.getUserInputListenerFactory();
            this.addPropertiesToOptionPanel();
            final MenuBuilder menuBuilder = userInputListenerFactory.getMenuBuilder();
            modeController.addAction((AFreeplaneAction)new ScriptEditor());
            modeController.addAction((AFreeplaneAction)new ExecuteScriptForAllNodes());
            modeController.addAction((AFreeplaneAction)new ExecuteScriptForSelectionAction());
            final ManageAddOnsAction manageAddOnsAction = new ManageAddOnsAction();
            modeController.addAction((AFreeplaneAction)manageAddOnsAction);
            modeController.addExtension(AddOnInstaller.class, (IExtension)new AddOnInstaller(){

                public void install(URL url) {
                    ManageAddOnsDialog dialog = manageAddOnsAction.getDialog();
                    dialog.install(url);
                }
            });
            final ScriptingConfiguration configuration = new ScriptingConfiguration();
            ScriptCompiler.compileScriptsOnPath(ScriptResources.getClasspath());
            modeController.addMenuContributor(new IMenuContributor(){

                public void updateMenus(ModeController modeController, MenuBuilder builder) {
                    ScriptingRegistration.this.registerScripts(menuBuilder, configuration);
                }
            });
            this.createUserScriptsDirectory();
            this.createUserLibDirectory();
        }
        FilterController.getCurrentFilterController().getConditionFactory().addConditionController(10, (IElementaryConditionController)new ScriptConditionController());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerScriptAddOns() {
        File[] addonXmlFiles = AddOnsController.getController().getAddOnsDir().listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".script.xml");
            }
        });
        IXMLParser parser = XMLParserFactory.createDefaultXMLParser();
        for (File file : addonXmlFiles) {
            BufferedInputStream inputStream = null;
            try {
                inputStream = new BufferedInputStream(new FileInputStream(file));
                StdXMLReader reader = new StdXMLReader((InputStream)inputStream);
                parser.setReader((IXMLReader)reader);
                ScriptAddOnProperties addOn = new ScriptAddOnProperties((XMLElement)parser.parse());
                addOn.setAddOnPropertiesFile(file);
                AddOnsController.getController().registerInstalledAddOn((AddOnProperties)addOn);
            }
            catch (Exception e) {
                try {
                    LogUtils.warn((String)("error parsing " + file), (Throwable)e);
                }
                catch (Throwable throwable) {
                    FileUtils.silentlyClose((Closeable[])new Closeable[]{inputStream});
                    throw throwable;
                }
                FileUtils.silentlyClose((Closeable[])new Closeable[]{inputStream});
                continue;
            }
            FileUtils.silentlyClose((Closeable[])new Closeable[]{inputStream});
        }
    }

    private void createUserScriptsDirectory() {
        File scriptDir = ScriptResources.getUserScriptsDir();
        if (!scriptDir.exists()) {
            LogUtils.info((String)("creating user scripts directory " + scriptDir));
            scriptDir.mkdirs();
        }
    }

    private void createUserLibDirectory() {
        File libDir = ScriptResources.getUserLibDir();
        if (!libDir.exists()) {
            LogUtils.info((String)("creating user lib directory " + libDir));
            libDir.mkdirs();
        }
    }

    private void registerScripts(MenuBuilder menuBuilder, ScriptingConfiguration configuration) {
        HashSet<String> registeredLocations = new HashSet<String>();
        for (String scriptsParentLocation : ScriptingConfiguration.getScriptsParentLocations()) {
            String scriptsLocation = ScriptingConfiguration.getScriptsLocation(scriptsParentLocation);
            this.addSubMenu(menuBuilder, scriptsParentLocation, scriptsLocation, TextUtils.getText((String)"ExecuteScripts.text"));
            registeredLocations.add(scriptsLocation);
            if (configuration.getMenuTitleToPathMap().isEmpty()) {
                String message = "<html><body><em>" + TextUtils.getText((String)"ExecuteScripts.noScriptsAvailable") + "</em></body></html>";
                menuBuilder.addElement((Object)scriptsLocation, (Object)new JMenuItem(message), 0);
            }
            for (Map.Entry<String, String> entry : configuration.getMenuTitleToPathMap().entrySet()) {
                String scriptName = entry.getKey();
                ScriptingConfiguration.ScriptMetaData metaData = (ScriptingConfiguration.ScriptMetaData)configuration.getMenuTitleToMetaDataMap().get(scriptName);
                for (ExecuteScriptAction.ExecutionMode executionMode : metaData.getExecutionModes()) {
                    String scriptLocation;
                    String titleKey;
                    String location = metaData.getMenuLocation(executionMode);
                    if (location == null) {
                        location = scriptsLocation + "/" + scriptName;
                        if (!registeredLocations.contains(location)) {
                            String parentMenuTitle = this.pimpMenuTitle(metaData.getScriptName());
                            this.addSubMenu(menuBuilder, this.parentLocation(location), location, parentMenuTitle);
                            registeredLocations.add(location);
                        }
                        titleKey = metaData.getTitleKey(executionMode);
                        scriptLocation = location + "/" + titleKey;
                    } else {
                        if (!registeredLocations.contains(location)) {
                            this.addSubMenu(menuBuilder, this.parentLocation(location), location, this.getMenuTitle(location));
                            registeredLocations.add(location);
                        }
                        titleKey = metaData.getTitleKey(executionMode);
                        scriptLocation = location + "/" + titleKey;
                    }
                    if (registeredLocations.contains(scriptLocation)) continue;
                    this.addMenuItem(menuBuilder, location, entry, executionMode, titleKey, metaData);
                    registeredLocations.add(scriptLocation);
                }
            }
        }
    }

    private String getMenuTitle(String location) {
        int index = location.lastIndexOf(47);
        String lastKey = location.substring(index + 1);
        return TextUtils.getText((String)lastKey, (String)TextUtils.getText((String)("addons." + lastKey), (String)lastKey));
    }

    private String parentLocation(String location) {
        return location.replaceFirst("/[^/]*$", "");
    }

    private void addSubMenu(MenuBuilder menuBuilder, String parentLocation, String location, String menuTitle) {
        if (menuBuilder.get((Object)location) == null) {
            JMenu menuItem = new JMenu();
            MenuBuilder.setLabelAndMnemonic((AbstractButton)menuItem, (String)menuTitle);
            menuBuilder.addMenuItem(parentLocation, (JMenuItem)menuItem, location, 0);
        }
    }

    private void addMenuItem(MenuBuilder menuBuilder, String location, Map.Entry<String, String> entry, ExecuteScriptAction.ExecutionMode executionMode, String titleKey, ScriptingConfiguration.ScriptMetaData metaData) {
        String scriptName = entry.getKey();
        String translation = TextUtils.getText((String)titleKey, (String)titleKey.replace('_', ' '));
        String menuName = translation.contains("{0}") ? MessageFormat.format(translation, this.pimpMenuTitle(scriptName)) : translation;
        menuBuilder.addAction(location, (AFreeplaneAction)new ExecuteScriptAction(scriptName, menuName, entry.getValue(), executionMode, metaData.cacheContent(), metaData.getPermissions()), 0);
    }

    private String pimpMenuTitle(String menuTitle) {
        String translation = TextUtils.getText((String)menuTitle, null);
        return translation != null ? translation : menuTitle.replaceAll("([a-z])([A-Z])", "$1 $2");
    }

    private final class ScriptModel
    implements ScriptEditorPanel.IScriptModel {
        private final String mOriginalScript;
        private String mScript;

        public ScriptModel(String pScript) {
            this.mScript = pScript;
            this.mOriginalScript = pScript;
        }

        public int addNewScript() {
            return 0;
        }

        public ScriptEditorWindowConfigurationStorage decorateDialog(ScriptEditorPanel pPanel, String pWindow_preference_storage_property) {
            String marshalled = ResourceController.getResourceController().getProperty(pWindow_preference_storage_property);
            return ScriptEditorWindowConfigurationStorage.decorateDialog(marshalled, pPanel);
        }

        public void endDialog(boolean pIsCanceled) {
            if (pIsCanceled) {
                this.mScript = this.mOriginalScript;
            }
        }

        public Object executeScript(int pIndex, PrintStream pOutStream, IFreeplaneScriptErrorHandler pErrorHandler) {
            ModeController modeController = Controller.getCurrentModeController();
            ScriptingPermissions restrictedPermissions = ScriptingPermissions.getPermissiveScriptingPermissions();
            return ScriptingEngine.executeScript(modeController.getMapController().getSelectedNode(), this.mScript, pErrorHandler, pOutStream, null, restrictedPermissions);
        }

        public int getAmountOfScripts() {
            return 1;
        }

        public String getScript() {
            return this.mScript;
        }

        public ScriptEditorPanel.ScriptHolder getScript(int pIndex) {
            return new ScriptEditorPanel.ScriptHolder("Script", this.mScript);
        }

        public boolean isDirty() {
            return !StringUtils.equals((String)this.mScript, (String)this.mOriginalScript);
        }

        public void setScript(int pIndex, ScriptEditorPanel.ScriptHolder pScript) {
            this.mScript = pScript.getScript();
        }

        public void storeDialogPositions(ScriptEditorPanel pPanel, ScriptEditorWindowConfigurationStorage pStorage, String pWindow_preference_storage_property) {
            pStorage.storeDialogPositions(pPanel, pWindow_preference_storage_property);
        }
    }
}

