/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.LogUtils;
import org.freeplane.plugin.script.IFreeplaneScriptErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptResources {
    static final IFreeplaneScriptErrorHandler IGNORING_SCRIPT_ERROR_HANDLER = new IFreeplaneScriptErrorHandler(){

        public void gotoLine(int pLineNumber) {
        }
    };
    private static final String RESOURCES_SCRIPT_COMPILATION_DISABLED_EXTENSIONS = "script_compilation_disabled_extensions";
    static final String RESOURCES_SCRIPT_DIRECTORIES = "script_directories";
    static final String RESOURCES_SCRIPT_CLASSPATH = "script_classpath";
    static final String[] SCRIPT_COMPILATION_DISABLED_EXTENSIONS = ResourceController.getResourceController().getProperty("script_compilation_disabled_extensions", "").split("\\W+");
    private static final String USER_SCRIPTS_DIR = "scripts";
    private static final String USER_LIB_DIR = "lib";
    private static final String BUILTIN_SCRIPTS_DIR = "scripts";
    private static List<String> classpath;
    private static final File builtinScriptsDir;
    private static final File userScriptsDir;
    private static final File userLibDir;

    public static File getUserScriptDir() {
        return ScriptResources.getUserScriptsDir();
    }

    public static File getUserScriptsDir() {
        return userScriptsDir;
    }

    public static File getUserLibDir() {
        return userLibDir;
    }

    static File getBuiltinScriptsDir() {
        return builtinScriptsDir;
    }

    static List<String> getClasspath() {
        return classpath;
    }

    static void setClasspath(List<String> newClasspath) {
        if (classpath != null) {
            throw new SecurityException("reset of script classpath is forbidden.");
        }
        classpath = Collections.unmodifiableList(newClasspath);
        if (!classpath.isEmpty()) {
            LogUtils.info((String)("extending script's classpath by " + classpath));
        }
    }

    private static File buildBuiltinScriptsDir() {
        return new File(ResourceController.getResourceController().getInstallationBaseDir(), "scripts");
    }

    private static File buildUserScriptsDir(String userDir) {
        return new File(ResourceController.getResourceController().getFreeplaneUserDirectory(), userDir);
    }

    static {
        builtinScriptsDir = ScriptResources.buildBuiltinScriptsDir();
        userScriptsDir = ScriptResources.buildUserScriptsDir("scripts");
        userLibDir = ScriptResources.buildUserScriptsDir(USER_LIB_DIR);
    }
}

