/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.tools.FileSystemCompiler;
import org.freeplane.core.util.LogUtils;
import org.freeplane.plugin.script.GroovyScript;
import org.freeplane.plugin.script.ScriptingEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptCompiler {
    public static void compileScriptsOnPath(List<String> pathElements) {
        for (String pathElement : pathElements) {
            File dir = new File(pathElement);
            if (!dir.isDirectory()) continue;
            ScriptCompiler.compileScriptsInDirectory(dir);
        }
    }

    private static void compileScriptsInDirectory(File dir) {
        Collection files = FileUtils.listFiles((File)dir, (String[])new String[]{".groovy"}, (boolean)true);
        if (!files.isEmpty()) {
            ScriptCompiler.compile(dir, files);
        }
    }

    private static void compile(File dir, Collection<File> files) {
        ScriptCompiler.compile(dir, ScriptCompiler.toArray(files));
    }

    private static void compile(File dir, File[] files) {
        try {
            CompilerConfiguration compilerConfiguration = GroovyScript.createCompilerConfiguration();
            compilerConfiguration.setTargetDirectory(dir);
            CompilationUnit unit = new CompilationUnit(compilerConfiguration, null, new GroovyClassLoader(ScriptingEngine.class.getClassLoader()));
            new FileSystemCompiler(compilerConfiguration, unit).compile(files);
            LogUtils.info((String)("compiled in " + dir + ": " + ScriptCompiler.createNameList(files)));
        }
        catch (Exception e) {
            LogUtils.severe((String)("error compiling in " + dir + ScriptCompiler.createNameList(files)), (Throwable)e);
        }
    }

    private static File[] toArray(Collection<File> groovyFiles) {
        return groovyFiles.toArray(new File[groovyFiles.size()]);
    }

    private static ArrayList<String> createNameList(File[] files) {
        ArrayList<String> names = new ArrayList<String>(files.length);
        for (File file : files) {
            names.add(file.getName());
        }
        return names;
    }
}

